/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryfile;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.TextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsas.business.paysalarysetting.paysetting.UpdatePaySettingService;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryFileSaveServiceHelper {
    private static final Log LOG = LogFactory.getLog(SalaryFileSaveServiceHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_SUCCESS_ROWS = "successRows";
    private static final String KEY_FAIL_ROWS = "failRows";
    private static final String KEY_WAITDEAL_ROWS = "waitDealRows";
    private static final String KEY_MSG = "message";
    private static final String KEY_DATA = "data";
    private static final String OPTYPE = "opType";
    private static final String OPTYPE_NEW = "new";
    private static final String OPTYPE_MODIFY = "modify";
    private static final String OPTYPE_CHANGE = "saveafteraudit";
    private static final int BATCH_SIZE_MAX = 10000;
    private static final int BATCH_SIZE = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> saveSalaryFile(List<Map<String, Object>> params) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try {
            if (params.size() > 10000) {
                result.put(KEY_SUCCESS, Boolean.FALSE);
                String overMaxSize = ResManager.loadKDString((String)"\u8d85\u8fc7\u6700\u5927\u5904\u7406\u6570\u3002", (String)"SalaryFileSaveServiceHelper_3", (String)"swc-hsas-business", (Object[])new Object[0]);
                result.put(KEY_MSG, overMaxSize);
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            this.dealSaveSalaryFile(params);
            this.clearResultData(params);
            result.put(KEY_SUCCESS, Boolean.TRUE);
            result.put(KEY_DATA, params);
        }
        catch (Exception ex) {
            LOG.error("SalaryFileSaveServiceHelper...saveSalaryFile...runerror...", (Throwable)ex);
            result.put(KEY_SUCCESS, Boolean.FALSE);
            result.put(KEY_MSG, ex.getMessage());
        }
        finally {
            this.statParams(result, params);
        }
        return result;
    }

    private void statParams(Map<String, Object> result, List<Map<String, Object>> params) {
        int succ = 0;
        int fail = 0;
        int wait = 0;
        for (Map<String, Object> param : params) {
            Boolean isSuccc = (Boolean)param.get(KEY_SUCCESS);
            if (isSuccc == null) {
                ++wait;
                continue;
            }
            if (isSuccc.booleanValue()) {
                ++succ;
                continue;
            }
            ++fail;
        }
        result.put(KEY_SUCCESS_ROWS, succ);
        result.put(KEY_FAIL_ROWS, fail);
        result.put(KEY_WAITDEAL_ROWS, wait);
        if (fail + wait >= 1) {
            result.put(KEY_SUCCESS, Boolean.FALSE);
        }
    }

    private void clearResultData(List<Map<String, Object>> paramRights) {
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("number");
        ignoreField.add("employee");
        ignoreField.add("org");
        ignoreField.add("payrollregion");
        ignoreField.add("payrollgroup");
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile").getFields();
        for (Map<String, Object> re : paramRights) {
            re.remove("empIsEndWhenStopPay");
            re.remove("fileDy");
            for (Map.Entry prop : fieldProps.entrySet()) {
                if (ignoreField.contains(prop.getKey())) continue;
                re.remove(prop.getKey());
                re.remove((String)prop.getKey() + "id");
            }
        }
    }

    private List<Map<String, Object>> dealSaveSalaryFile(List<Map<String, Object>> params) {
        LOG.info("call...saveSalaryFile...bgein...params.size={}...", (Object)params.size());
        if (params.size() <= 30) {
            LOG.info("call...saveSalaryFile...bgein...params.size={}...params= {}", (Object)params.size(), (Object)SerializationUtils.toJsonString(params));
        }
        List<Map<String, Object>> paramRights = params;
        this.validateParams(paramRights);
        paramRights = this.filterRights(paramRights);
        this.convertToFileDy(paramRights);
        paramRights = this.filterRights(paramRights);
        this.completeFileDy(paramRights);
        this.validateFileDy(paramRights);
        paramRights = this.filterRights(paramRights);
        Map<Integer, List<Map<String, Object>>> splitParamRights = this.splitParamsByEmpid(paramRights);
        for (Map.Entry<Integer, List<Map<String, Object>>> entry : splitParamRights.entrySet()) {
            ArrayList tmpList = new ArrayList(entry.getValue().size());
            tmpList.addAll(entry.getValue());
            List tmpListSplit = Lists.partition(tmpList, (int)500);
            for (List minList : tmpListSplit) {
                this.batchSaveSalaryFile(minList);
            }
        }
        paramRights = this.filterRights(paramRights);
        this.afterSaveSalaryFile(paramRights);
        LOG.info("call...saveSalaryFile...end.....params.size={}...", (Object)params.size());
        return params;
    }

    private void afterSaveSalaryFile(List<Map<String, Object>> paramRights) {
        LOG.info("call...saveSalaryFile...afterSaveSalaryFile..1...paramRights.size={}...", (Object)paramRights.size());
        this.afterSaveSalaryFileForNewNumber(paramRights);
        LOG.info("call...saveSalaryFile...afterSaveSalaryFile..2...paramRights.size={}...", (Object)paramRights.size());
        this.afterSaveSalaryFileForPaySetting(paramRights);
        LOG.info("call...saveSalaryFile...afterSaveSalaryFile..3...paramRights.size={}...", (Object)paramRights.size());
    }

    private void afterSaveSalaryFileForPaySetting(List<Map<String, Object>> paramRights) {
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(10);
        ArrayList<Long> salaryFileIdsFalse = new ArrayList<Long>(10);
        for (Map<String, Object> param : paramRights) {
            Long id = ((DynamicObject)param.get("fileDy")).getLong("id");
            Object isHandUpdateBankCard = param.get("isHandUpdateBankCard");
            if (isHandUpdateBankCard != null && !Boolean.parseBoolean(String.valueOf(isHandUpdateBankCard))) {
                salaryFileIdsFalse.add(id);
                continue;
            }
            salaryFileIds.add(id);
        }
        UpdatePaySettingService service = new UpdatePaySettingService();
        String recordId = String.valueOf(System.currentTimeMillis());
        service.updatePaySetting(salaryFileIds, recordId, Boolean.TRUE);
        String recordIdFalse = String.valueOf(System.currentTimeMillis());
        service.updatePaySetting(salaryFileIdsFalse, recordIdFalse, Boolean.FALSE);
    }

    private void afterSaveSalaryFileForNewNumber(List<Map<String, Object>> paramRights) {
        Set newIds = paramRights.stream().filter(o1 -> OPTYPE_NEW.equals(o1.get(OPTYPE))).map(param -> param.get("id")).collect(Collectors.toSet());
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        QFilter filter = new QFilter("id", "in", newIds);
        DynamicObject[] fileDys = fileHelper.query("id,number", new QFilter[]{filter});
        Map<Long, String> idNumberMap = Arrays.stream(fileDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("number")));
        for (Map<String, Object> param2 : paramRights) {
            Object number = param2.get("number");
            String numberDB = idNumberMap.get(param2.get("id"));
            if (number == null || numberDB == null || SWCStringUtils.isEmpty((String)String.valueOf(number)) || String.valueOf(number).equals(numberDB)) continue;
            param2.put(KEY_MSG, "newNumber:" + numberDB);
        }
    }

    private void batchSaveSalaryFile(List<Map<String, Object>> paramRights) {
        LOG.info("call...saveSalaryFile...batchSaveSalaryFile..1...paramRights.size={}...", (Object)paramRights.size());
        this.adjustOpType(paramRights);
        paramRights = this.filterRights(paramRights);
        this.validateFileDyBeforeCallOp(paramRights);
        paramRights = this.filterRights(paramRights);
        Map<String, List<Map>> waitParamsMap = paramRights.stream().collect(Collectors.groupingBy(param -> (String)param.get(OPTYPE)));
        List<Map<String, Object>> waitAddParams = waitParamsMap.get(OPTYPE_NEW);
        List<Map<String, Object>> waitModifyParams = waitParamsMap.get(OPTYPE_MODIFY);
        List<Map<String, Object>> waitChangeParams = waitParamsMap.get(OPTYPE_CHANGE);
        this.completeWaitAddParams(waitAddParams);
        LOG.info("call...saveSalaryFile...batchSaveSalaryFile..3...paramRights.size={}...", (Object)paramRights.size());
        this.executeOpForSave(OPTYPE_NEW, waitAddParams);
        LOG.info("call...saveSalaryFile...batchSaveSalaryFile..4...waitAddParams.size={}...", (Object)(waitAddParams == null ? 0 : waitAddParams.size()));
        this.executeOpForSave(OPTYPE_MODIFY, waitModifyParams);
        LOG.info("call...saveSalaryFile...batchSaveSalaryFile..5...waitModifyParams.size={}...", (Object)(waitModifyParams == null ? 0 : waitModifyParams.size()));
        this.executeOp(OPTYPE_CHANGE, waitChangeParams, "C");
        LOG.info("call...saveSalaryFile...batchSaveSalaryFile..6...waitChangeParams.size={}...", (Object)(waitChangeParams == null ? 0 : waitChangeParams.size()));
    }

    private void executeOpForSave(String opType, List<Map<String, Object>> waitParams) {
        if (waitParams == null || waitParams.size() == 0) {
            return;
        }
        Map<String, List<Map>> waitParamsMap = waitParams.stream().collect(Collectors.groupingBy(param -> ((DynamicObject)param.get("fileDy")).getString("status")));
        List<Map<String, Object>> draftParams = waitParamsMap.get("A");
        this.executeOp("save", draftParams, "A");
        List<Map<String, Object>> auditParams = waitParamsMap.get("C");
        if (auditParams != null && auditParams.size() >= 1) {
            for (Map map : auditParams) {
                ((DynamicObject)map.get("fileDy")).set("status", (Object)"A");
            }
            this.executeOp("save", auditParams, "C");
        }
    }

    private void completeWaitAddParams(List<Map<String, Object>> paramRights) {
        if (paramRights == null || paramRights.size() == 0) {
            return;
        }
        Long userId = RequestContext.get().getCurrUserId();
        long[] ids = DB.genLongIds((String)"hsas_salaryfile", (int)paramRights.size());
        for (int i = 0; i < paramRights.size(); ++i) {
            Map<String, Object> param = paramRights.get(i);
            DynamicObject fileDy = (DynamicObject)param.get("fileDy");
            Long id = fileDy.getLong("id");
            if (id == null || id == 0L) {
                fileDy.set("id", (Object)ids[i]);
            }
            param.put("id", fileDy.getLong("id"));
            fileDy.set("creator", (Object)userId);
            fileDy.set("modifier", (Object)userId);
        }
    }

    private void adjustOpType(List<Map<String, Object>> paramRights) {
        Set idSet = paramRights.stream().map(param -> param.get("id")).collect(Collectors.toSet());
        Set numberSet = paramRights.stream().map(param -> param.get("number")).collect(Collectors.toSet());
        Set personIdSet = paramRights.stream().map(param -> ((DynamicObject)param.get("fileDy")).getLong("employee.person.id")).collect(Collectors.toSet());
        Set orgSet = paramRights.stream().map(param -> param.get("org")).collect(Collectors.toSet());
        Set payrollregionSet = paramRights.stream().map(param -> param.get("payrollregion")).collect(Collectors.toSet());
        Set payrollgroupSet = paramRights.stream().map(param -> param.get("payrollgroup")).collect(Collectors.toSet());
        QFilter statusFilter = new QFilter("status", "!=", (Object)"E");
        QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProperties = SWCHisBaseDataHelper.getSelectProperties((String)helper.getEntityName());
        QFilter filter = new QFilter("id", "in", idSet);
        DynamicObject[] dys = helper.query(selectProperties, new QFilter[]{filter});
        Map<Long, DynamicObject> dysIdMap = Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (t1, t2) -> t1));
        QFilter numberFilter = new QFilter("number", "in", numberSet);
        DynamicObject[] numberDys = helper.query(selectProperties, new QFilter[]{numberFilter, hisCurrFilter});
        Map<String, DynamicObject> dysNumberMap = Arrays.asList(numberDys).stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (t1, t2) -> t1));
        QFilter mainFilter = new QFilter("employee.person.id", "in", personIdSet);
        mainFilter.and("org.id", "in", orgSet);
        mainFilter.and("payrollregion.id", "in", payrollregionSet);
        mainFilter.and("payrollgroup.id", "in", payrollgroupSet);
        DynamicObject[] mainDys = helper.query(selectProperties, new QFilter[]{mainFilter, statusFilter, hisCurrFilter});
        Map<String, DynamicObject> dysMainMap = Arrays.asList(mainDys).stream().collect(Collectors.toMap(dy -> this.getUniqueFieldsKey((DynamicObject)dy), dy -> dy, (t1, t2) -> t1));
        String msg = ResManager.loadKDString((String)"\u201c\u6863\u6848\u7f16\u53f7\u201d \u503c \u201c{0}\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"SalaryFileSaveValidator_11", (String)"swc-hsas-opplugin", (Object[])new Object[0]);
        for (int i = 0; i < paramRights.size(); ++i) {
            DynamicObject fileDy;
            DynamicObject dyDB;
            Map<String, Object> param2 = paramRights.get(i);
            Long id = (Long)param2.get("id");
            String number = (String)param2.get("number");
            if (id != null && SWCStringUtils.isEmpty((String)number)) {
                dyDB = dysIdMap.get(id);
                if (dyDB == null) {
                    param2.put(OPTYPE, OPTYPE_NEW);
                } else {
                    this.adjustOpTypeForHasDB(param2, dyDB);
                }
            }
            if (id != null && SWCStringUtils.isNotEmpty((String)number)) {
                dyDB = dysIdMap.get(id);
                DynamicObject dyDBNumber = dysNumberMap.get(number);
                if (dyDB == null) {
                    if (dyDBNumber == null) {
                        param2.put(OPTYPE, OPTYPE_NEW);
                    } else {
                        param2.put(KEY_SUCCESS, Boolean.FALSE);
                        param2.put(KEY_MSG, MessageFormat.format(msg, number));
                    }
                } else {
                    this.adjustOpTypeForHasDB(param2, dyDB);
                }
            }
            if (id == null && SWCStringUtils.isNotEmpty((String)number)) {
                dyDB = dysNumberMap.get(number);
                if (dyDB == null) {
                    param2.put(OPTYPE, OPTYPE_NEW);
                } else {
                    this.adjustOpTypeForHasDB(param2, dyDB);
                }
            }
            if (id != null || !SWCStringUtils.isEmpty((String)number) || (fileDy = (DynamicObject)param2.get("fileDy")) == null) continue;
            String mainKey = String.valueOf(fileDy.get("employee.person.id")) + '.' + param2.get("org") + '.' + param2.get("payrollgroup") + '.' + param2.get("payrollregion");
            DynamicObject dyDB2 = dysMainMap.get(mainKey);
            if (dyDB2 == null) {
                param2.put(OPTYPE, OPTYPE_NEW);
                continue;
            }
            this.adjustOpTypeForHasDB(param2, dyDB2);
        }
    }

    private String getUniqueFieldsKey(DynamicObject salaryFileDyobj) {
        String personId = salaryFileDyobj.getString("employee.person.id");
        String orgId = salaryFileDyobj.getString("org.id");
        String payRollGroupId = salaryFileDyobj.getString("payrollgroup.id");
        String payRollRegionId = salaryFileDyobj.getString("payrollregion.id");
        StringBuilder sb = new StringBuilder();
        sb.append(personId).append('.').append(orgId).append('.').append(payRollGroupId).append('.').append(payRollRegionId);
        return String.valueOf(sb);
    }

    private void adjustOpTypeForHasDB(Map<String, Object> param, DynamicObject dyDB) {
        DynamicObject fileDy = (DynamicObject)param.get("fileDy");
        HashSet<String> ignoreField = new HashSet<String>(16);
        ignoreField.add("boid");
        ignoreField.add("number");
        ignoreField.add("org");
        ignoreField.add("payrollregion");
        ignoreField.add("payrollgroup");
        ignoreField.add("status");
        ignoreField.add("createtime");
        if (!this.getUniqueFieldsKey(dyDB).equals(this.getUniqueFieldsKey(fileDy))) {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            String errorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u4fee\u6539\u201c\u6863\u6848\u7f16\u53f7\u201d\u3001\u201c\u8ba1\u85aa\u4eba\u5458\u201d\u3001\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3001\u201c\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201d\u3001\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3002", (String)"SalaryFileSaveServiceHelper_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            param.put(KEY_MSG, errorMsg);
            return;
        }
        param.put("id", dyDB.getLong("id"));
        String status = dyDB.getString("status");
        String paramStatus = fileDy.getString("status");
        if ("A".equals(status)) {
            param.put(OPTYPE, OPTYPE_MODIFY);
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)fileDy, (DynamicObject)dyDB, ignoreField, null);
            if ("C".equals(paramStatus)) {
                dyDB.set("status", (Object)paramStatus);
            }
            param.put("fileDy", dyDB);
        } else if ("C".equals(status)) {
            param.put(OPTYPE, OPTYPE_CHANGE);
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)fileDy, (DynamicObject)dyDB, ignoreField, null);
            param.put("fileDy", dyDB);
        } else {
            param.put(KEY_SUCCESS, Boolean.FALSE);
            String msg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SalaryFileSaveServiceHelper_4", (String)"swc-hsas-business", (Object[])new Object[0]);
            if ("B".equals(status)) {
                msg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u5df2\u63d0\u4ea4\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SalaryFileSaveServiceHelper_5", (String)"swc-hsas-business", (Object[])new Object[0]);
            } else if ("E".equals(status)) {
                msg = ResManager.loadKDString((String)"\u8be5\u85aa\u8d44\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"SalaryFileSaveServiceHelper_6", (String)"swc-hsas-business", (Object[])new Object[0]);
            }
            param.put(KEY_MSG, msg);
        }
        Long userId = RequestContext.get().getCurrUserId();
        fileDy.set("modifier", (Object)userId);
    }

    private Map<Integer, List<Map<String, Object>>> splitParamsByEmpid(List<Map<String, Object>> paramRights) {
        paramRights.sort((o1, o2) -> {
            if (o1 == null || o2 == null || o1.get("fileDy") == null || o2.get("fileDy") == null) {
                return 0;
            }
            Date o1Bsed = ((DynamicObject)o1.get("fileDy")).getDate("bsed");
            Date o2Bsed = ((DynamicObject)o2.get("fileDy")).getDate("bsed");
            if (o1Bsed != null && o2Bsed != null) {
                return o1Bsed.compareTo(o2Bsed);
            }
            return 0;
        });
        HashMap<Integer, List<Map<String, Object>>> batchDyMap = new HashMap<Integer, List<Map<String, Object>>>(16);
        HashMap<Long, Integer> batchRls = new HashMap<Long, Integer>(16);
        for (Map<String, Object> dy : paramRights) {
            Long employeeId = (Long)dy.get("employee");
            Integer batch = (Integer)batchRls.get(employeeId);
            if (batch == null) {
                batch = -1;
            }
            Integer n = batch;
            Integer n2 = batch = Integer.valueOf(batch + 1);
            batchRls.put(employeeId, batch);
            ArrayList<Map<String, Object>> dys = (ArrayList<Map<String, Object>>)batchDyMap.get(batch);
            if (dys == null) {
                dys = new ArrayList<Map<String, Object>>(10);
            }
            dys.add(dy);
            batchDyMap.put(batch, dys);
        }
        return batchDyMap;
    }

    private List<Map<String, Object>> filterRights(List<Map<String, Object>> params) {
        return params.stream().filter(o1 -> o1.get(KEY_SUCCESS) == null || (Boolean)o1.get(KEY_SUCCESS) != false).collect(Collectors.toList());
    }

    private void validateParams(List<Map<String, Object>> params) {
        String msgEmployee = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u85aa\u4eba\u5458\u201d\u3002", (String)"SalaryFileSaveServiceHelper_7", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgBsed = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6548\u65e5\u671f\u3002", (String)"SalaryFileSaveServiceHelper_8", (String)"swc-hsas-business", (Object[])new Object[0]);
        String overMaxLengthMsg = ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u503c\u8d85\u8fc7{1}\u4f4d\u6700\u5927\u957f\u5ea6\u3002", (String)"SalaryFileSaveServiceHelper_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        String dataTypeErrMsg = ResManager.loadKDString((String)"\u201c{0}\u201d\u7684\u503c\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u7c7b\u578b\u548c\u957f\u5ea6\u3002", (String)"SalaryFileSaveServiceHelper_13", (String)"swc-hsas-business", (Object[])new Object[0]);
        String empIsEndErrMsg = ResManager.loadKDString((String)"\u201c\u5c97\u4f4d\u662f\u5426\u7b97\u85aa\u7ed3\u675f\u5f53\u505c\u6b62\u7b97\u85aa\u65f6\u201d\u53c2\u6570\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"SalaryFileSaveServiceHelper_17", (String)"swc-hsas-business", (Object[])new Object[0]);
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile").getFields();
        block2: for (Map<String, Object> param : params) {
            Object valId = param.get("id");
            if (valId != null && String.valueOf(valId).length() > 19) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, MessageFormat.format(overMaxLengthMsg, "id", 19));
                continue;
            }
            Object valEmp = param.get("employee");
            if (valEmp == null) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, msgEmployee);
                continue;
            }
            if (String.valueOf(valEmp).length() <= 19 && Long.parseLong(String.valueOf(valEmp)) == 0L) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, msgEmployee);
                continue;
            }
            Object valBsed = param.get("bsed");
            if (valBsed == null) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, msgBsed);
                continue;
            }
            Object isEnd = param.get("empIsEndWhenStopPay");
            if (!(isEnd == null || isEnd instanceof String && ("1".equals(String.valueOf(isEnd)) || "0".equals(String.valueOf(isEnd))))) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, empIsEndErrMsg);
                continue;
            }
            for (Map.Entry prop : fieldProps.entrySet()) {
                String pkey = (String)prop.getKey();
                IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
                Object pValue = param.get(pkey);
                if (pValue == null) continue;
                if (propval instanceof BasedataProp) {
                    try {
                        param.put(pkey, Long.parseLong(String.valueOf(pValue)));
                        continue;
                    }
                    catch (Exception ex) {
                        LOG.error("validateParams error...", (Throwable)ex);
                        param.put(KEY_SUCCESS, Boolean.FALSE);
                        param.put(KEY_MSG, MessageFormat.format(dataTypeErrMsg, propval.getDisplayName().getLocaleValue()));
                        continue block2;
                    }
                }
                if (!(propval instanceof TextProp)) continue;
                int maxLength = ((TextProp)propval).getMaxLenth();
                if (String.valueOf(pValue).length() <= maxLength) continue;
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, MessageFormat.format(overMaxLengthMsg, propval.getDisplayName().getLocaleValue(), maxLength));
                continue block2;
            }
        }
    }

    private void validateFileDy(List<Map<String, Object>> params) {
        String msgEmployee = ResManager.loadKDString((String)"\u6240\u586b\u5199\u7684\u8ba1\u85aa\u4eba\u5458\u4e0d\u5b58\u5728\u8be5\u4e3b\u8981\u5c97\u4f4d\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SalaryFileSaveServiceHelper_9", (String)"swc-hsas-business", (Object[])new Object[0]);
        String msgEmpG = ResManager.loadKDString((String)"\u6240\u586b\u5199\u7684\u201c\u8ba1\u85aa\u4eba\u5458\u7ec4\u201d\u7684\u6240\u5c5e\u4e1a\u52a1\u7c7b\u578b\u4e0d\u662f\u7b97\u53d1\u85aa\u7ba1\u7406\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"SalaryFileSaveServiceHelper_10", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map<String, Object> param : params) {
            DynamicObject fileDy = (DynamicObject)param.get("fileDy");
            Long empEmployeeId = fileDy.getLong("depemp.employee.id");
            if (fileDy.getLong("employee.id") != empEmployeeId.longValue()) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, msgEmployee);
            }
            if (fileDy.getLong("empgroup.bussinessfield.id") == 107010L) continue;
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, msgEmpG);
        }
    }

    private void validateFileDyBeforeCallOp(List<Map<String, Object>> params) {
        String empIsEndForNewMsg = ResManager.loadKDString((String)"\u65b0\u589e\u85aa\u8d44\u6863\u6848\u65f6\uff0c\u4e3b\u8981\u5c97\u4f4d\u4e0d\u5141\u8bb8\u7b97\u85aa\u7ed3\u675f\u3002", (String)"SalaryFileSaveServiceHelper_14", (String)"swc-hsas-business", (Object[])new Object[0]);
        String empIsEndForModifyMsg = ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6838\uff0c\u4e3b\u8981\u5c97\u4f4d\u4e0d\u5141\u8bb8\u7b97\u85aa\u7ed3\u675f\u3002", (String)"SalaryFileSaveServiceHelper_15", (String)"swc-hsas-business", (Object[])new Object[0]);
        String empIsEndForNormalMsg = ResManager.loadKDString((String)"\u6b63\u5e38\u7b97\u85aa\u65f6\uff0c\u4e3b\u8981\u5c97\u4f4d\u4e0d\u5141\u8bb8\u7b97\u85aa\u7ed3\u675f\u3002", (String)"SalaryFileSaveServiceHelper_16", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (Map<String, Object> param : params) {
            Object isEnd = param.get("empIsEndWhenStopPay");
            if (!(isEnd instanceof String) || !"1".equals(String.valueOf(isEnd))) continue;
            String opType = (String)param.get(OPTYPE);
            DynamicObject fileDy = (DynamicObject)param.get("fileDy");
            String salarycalstyle = fileDy.getString("salarycalcstyle.salarycalstyle");
            String errorMsg = null;
            if (OPTYPE_NEW.equals(opType)) {
                errorMsg = empIsEndForNewMsg;
            } else if (OPTYPE_MODIFY.equals(opType)) {
                errorMsg = empIsEndForModifyMsg;
            } else if (OPTYPE_CHANGE.equals(opType) && "1".equals(salarycalstyle)) {
                errorMsg = empIsEndForNormalMsg;
            }
            if (errorMsg == null) continue;
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, errorMsg);
        }
    }

    private void completeFileDy(List<Map<String, Object>> params) {
        DynamicObject fileDy = null;
        for (int i = 0; i < params.size(); ++i) {
            Map<String, Object> param = params.get(i);
            fileDy = (DynamicObject)param.get("fileDy");
            fileDy.set("id", param.get("id"));
            fileDy.set("paystatus", fileDy.get("salarycalcstyle.salarycalstyle"));
            if (fileDy.getLong("adminorg.id") == fileDy.getLong("depemp.orgteam.id")) {
                fileDy.set("isescrowstaff", (Object)Boolean.FALSE);
            } else {
                fileDy.set("isescrowstaff", (Object)Boolean.TRUE);
            }
            String status = fileDy.getString("status");
            if (SWCStringUtils.isEmpty((String)status)) {
                fileDy.set("status", (Object)"A");
            } else if ("B".equals(status) || "E".equals(status)) {
                fileDy.set("status", (Object)"A");
            }
            if (!SWCStringUtils.isEmpty((String)fileDy.getString("enable"))) continue;
            fileDy.set("enable", (Object)"1");
        }
    }

    private void convertToFileDy(List<Map<String, Object>> params) {
        SWCDataServiceHelper fileHelper = new SWCDataServiceHelper("hsas_salaryfile");
        Map fieldProps = EntityMetadataCache.getDataEntityType((String)"hsas_salaryfile").getFields();
        HashMap bdValue = new HashMap(16);
        HashMap<String, Map<Long, DynamicObject>> bdValueDB = new HashMap<String, Map<Long, DynamicObject>>(16);
        DynamicObject fileDy = null;
        for (int i = 0; i < params.size(); ++i) {
            Map<String, Object> param = params.get(i);
            fileDy = fileHelper.generateEmptyDynamicObject();
            param.put("fileDy", fileDy);
            for (Map.Entry prop : fieldProps.entrySet()) {
                String pkey = (String)prop.getKey();
                IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
                if (propval instanceof BasedataProp) {
                    Object pValue;
                    HashSet<Long> values = (HashSet<Long>)bdValue.get(propval);
                    if (values == null) {
                        values = new HashSet<Long>(16);
                        bdValue.put((BasedataProp)propval, values);
                    }
                    if (!((pValue = param.get(pkey)) instanceof Long)) continue;
                    values.add(Long.parseLong(String.valueOf(pValue)));
                    fileDy.set(pkey, pValue);
                    continue;
                }
                if (propval instanceof DateProp) {
                    this.dealDateValue(fileDy, param, pkey);
                    continue;
                }
                fileDy.set(pkey, param.get(pkey));
            }
        }
        for (Map.Entry bdProp : bdValue.entrySet()) {
            BasedataProp prop = (BasedataProp)bdProp.getKey();
            SWCDataServiceHelper helper = new SWCDataServiceHelper(prop.getBaseEntityId());
            QFilter filter = new QFilter("id", "in", bdProp.getValue());
            MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)helper.getEntityName());
            Set fieldSet = mainEntityType.getFields().keySet();
            if (fieldSet.contains("enable") && !"bos_org".equals(prop.getBaseEntityId()) && !"haos_adminorghr".equals(prop.getBaseEntityId())) {
                filter.and("enable", "=", (Object)"1");
            }
            if (fieldSet.contains("status")) {
                filter.and("status", "=", (Object)"C");
            }
            if (fieldSet.contains("iscurrentversion")) {
                filter.and("iscurrentversion", "=", (Object)"1");
            }
            DynamicObject[] dys = helper.query(SWCHisBaseDataHelper.getSelectProperties((String)prop.getBaseEntityId()), new QFilter[]{filter});
            Map<Long, DynamicObject> dysIdMap = Arrays.asList(dys).stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (t1, t2) -> t1));
            bdValueDB.put(prop.getName(), dysIdMap);
        }
        SWCDataServiceHelper empPosOrgRelHr = new SWCDataServiceHelper("hsas_empposorgrelhr");
        QFilter depEmpIdFilter = new QFilter("depemp.id", "in", bdValue.get("depemp"));
        QFilter isCurrentVersionFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter dataStatusFilter = new QFilter("datastatus", "=", (Object)"1");
        DynamicObject[] empPosOrgs = empPosOrgRelHr.query(new QFilter[]{depEmpIdFilter, isCurrentVersionFilter, dataStatusFilter});
        Map<Long, DynamicObject> dysIdMap = Arrays.asList(empPosOrgs).stream().collect(Collectors.toMap(dy -> dy.getLong("depemp.id"), dy -> dy, (t1, t2) -> t1));
        bdValueDB.put("empposinfo", dysIdMap);
        String bdNotFindMsg = ResManager.loadKDString((String)"\u201c{0}\u201d\u4e0d\u5b58\u5728\u6216\u4e0d\u662f\u6709\u6548\u72b6\u6001\u3002", (String)"SalaryFileSaveServiceHelper_11", (String)"swc-hsas-business", (Object[])new Object[0]);
        for (int i = 0; i < params.size(); ++i) {
            Map<String, Object> param = params.get(i);
            if (param.containsKey(KEY_SUCCESS)) continue;
            fileDy = (DynamicObject)param.get("fileDy");
            for (Map.Entry prop : fieldProps.entrySet()) {
                Object pValueEmp;
                String pkey = (String)prop.getKey();
                IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
                if (!(propval instanceof BasedataProp)) continue;
                Object pValue = param.get(pkey);
                if (pValue instanceof Long) {
                    DynamicObject bdValueTmp = (DynamicObject)((Map)bdValueDB.get(pkey)).get(pValue);
                    if (bdValueTmp != null) {
                        fileDy.set(pkey, (Object)bdValueTmp);
                    } else {
                        param.put(KEY_SUCCESS, Boolean.FALSE);
                        param.put(KEY_MSG, MessageFormat.format(bdNotFindMsg, propval.getDisplayName().getLocaleValue()));
                    }
                }
                if (!"empposinfo".equals(pkey) || !((pValueEmp = param.get("depemp")) instanceof Long)) continue;
                fileDy.set(pkey, ((Map)bdValueDB.get("empposinfo")).get(pValueEmp));
            }
        }
    }

    private void dealDateValue(DynamicObject fileDy, Map<String, Object> param, String pkey) {
        Object pValue = param.get(pkey);
        if (pValue == null) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u683c\u5f0f\u9519\u8bef\uff0c\u6b63\u786e\u683c\u5f0f\uff1a2023/12/31 \u6216\u8005 2023-12-31", (String)"BizDataFailStatusEnum_4108", (String)"swc-hsbp-common", (Object[])new Object[0]);
        if (pValue instanceof String) {
            try {
                pValue = SWCDateTimeUtils.parseDate((String)String.valueOf(pValue));
            }
            catch (ParseException var4) {
                LOG.error("SalaryFileSaveServiceHelper.convertToFileDy.parseDateValue error...2...", (Throwable)var4);
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, errorMsg);
                pValue = null;
            }
        }
        if (pValue != null) {
            Calendar ca = Calendar.getInstance();
            ca.setTime((Date)pValue);
            if (ca.get(1) > 2999) {
                pValue = null;
                LOG.error("SalaryFileSaveServiceHelper.convertToFileDy.parseDateValue error...3...{}", (Object)SWCDateTimeUtils.format((Date)((Date)pValue)));
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, errorMsg);
            }
        }
        fileDy.set(pkey, pValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOp(String opName, List<Map<String, Object>> waitParams, String status) {
        if (waitParams == null || waitParams.size() == 0) {
            return;
        }
        try (TXHandle txHandle = TX.required();){
            ArrayList<DynamicObject> waitDys = new ArrayList<DynamicObject>(10);
            HashMap<String, String> empIsEndWhenStopPayMap = new HashMap<String, String>(16);
            HashMap<Long, Map<String, Object>> waitMap = new HashMap<Long, Map<String, Object>>(16);
            for (Map<String, Object> param : waitParams) {
                DynamicObject fileDyObj = (DynamicObject)param.get("fileDy");
                waitDys.add(fileDyObj);
                waitMap.put(fileDyObj.getLong("id"), param);
                Object isEnd = param.get("empIsEndWhenStopPay");
                if (!(isEnd instanceof String) || !"1".equals(String.valueOf(isEnd)) && !"0".equals(String.valueOf(isEnd))) continue;
                empIsEndWhenStopPayMap.put(fileDyObj.getString("id"), String.valueOf(isEnd));
            }
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("ignoreinteraction", String.valueOf(true));
            operateOption.setVariableValue("ishasright", String.valueOf(true));
            operateOption.setVariableValue("skipCheckDataPermission", Boolean.toString(true));
            operateOption.setVariableValue("OPERATE_SRC", "salaryFileServiceHelper.saveSalaryFile");
            operateOption.setVariableValue("status", status);
            operateOption.setVariableValue("empIsEndWhenStopPay", JSON.toJSONString(empIsEndWhenStopPayMap));
            OperationServiceImpl opImpl = new OperationServiceImpl();
            OperationResult operationResult = opImpl.localInvokeOperation(opName, waitDys.toArray(new DynamicObject[0]), operateOption);
            this.dealOperationResult(opName, operationResult, waitMap);
        }
    }

    private void dealOperationResult(String opName, OperationResult operationResult, Map<Long, Map<String, Object>> waitMap) {
        for (Object pkId : operationResult.getSuccessPkIds()) {
            Map<String, Object> param = waitMap.get(Long.parseLong(String.valueOf(pkId)));
            param.put(KEY_SUCCESS, Boolean.TRUE);
            param.put(KEY_MSG, "");
        }
        List operateInfos = operationResult.getAllErrorOrValidateInfo();
        for (IOperateInfo operateInfo : operateInfos) {
            Long pkId = Long.parseLong(String.valueOf(operateInfo.getPkValue()));
            Map<String, Object> param = waitMap.get(Long.parseLong(String.valueOf(pkId)));
            param.put(KEY_SUCCESS, Boolean.FALSE);
            param.put(KEY_MSG, (param.get(KEY_MSG) == null ? "" : param.get(KEY_MSG)) + operateInfo.getMessage());
        }
        String sucessMsg = ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SalaryFileSaveServiceHelper_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        String cancelMsg = ResManager.loadKDString((String)"\u53d6\u6d88\u4e86\u64cd\u4f5c", (String)"PersonImportDataTask_12", (String)"swc-hsas-business", (Object[])new Object[0]);
        String validateMsg = ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"EntityOperateService_11", (String)"bos-mservice-operation", (Object[])new Object[0]);
        String msg = operationResult.getMessage();
        if (StringUtils.isNotEmpty((CharSequence)msg) && !msg.contains(sucessMsg) && !msg.contains(cancelMsg) && !msg.contains(validateMsg)) {
            for (Map<String, Object> param : waitMap.values()) {
                param.put(KEY_SUCCESS, Boolean.FALSE);
                param.put(KEY_MSG, msg);
            }
        }
    }
}

