/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.salaryrpt;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.entity.RptDisplayColumnEntity;
import kd.swc.hsbp.common.entity.RptDisplayFieldEntity;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import org.jetbrains.annotations.NotNull;

public class SalaryRptItemService {
    private static final int LEVEL_FIVE = 5;
    static Map<String, String> itemTypeToEntityCodeMap = Maps.newLinkedHashMapWithExpectedSize((int)5);
    static Map<String, String> itemEntityToFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)6);
    static Map<String, String> itemGroupFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
    static Map<String, String> itemScaleFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)4);

    public static String getItemGroupFieldCode(String entityCode) {
        return itemGroupFieldMap.get(entityCode);
    }

    public static Map<String, String> getItemEntityToFieldMap() {
        return itemEntityToFieldMap;
    }

    public static String getItemScaleFieldCode(String entityCode) {
        return itemScaleFieldMap.get(entityCode);
    }

    public static Map<String, Map<Long, DynamicObject>> queryItemMap(Map<String, List<Long>> itemIdMap) {
        if (CollectionUtils.isEmpty(itemIdMap)) {
            return new HashMap<String, Map<Long, DynamicObject>>(0);
        }
        HashMap ItemTypeToItemDynMap = Maps.newHashMapWithExpectedSize((int)itemIdMap.size());
        for (Map.Entry<String, List<Long>> itemTypeEntry : itemIdMap.entrySet()) {
            QFilter filter;
            String selectFields;
            String itemType = itemTypeEntry.getKey();
            List<Long> itemIds = itemTypeEntry.getValue();
            String entityCode = itemTypeToEntityCodeMap.get(itemType);
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityCode);
            DynamicObject[] itemArry = serviceHelper.query(selectFields = itemEntityToFieldMap.get(entityCode), new QFilter[]{filter = new QFilter("id", "in", itemIds)});
            if (itemArry == null || itemArry.length == 0) continue;
            HashMap itemDynMap = Maps.newHashMapWithExpectedSize((int)itemArry.length);
            ItemTypeToItemDynMap.put(itemType, itemDynMap);
            Arrays.stream(itemArry).forEach(obj -> itemDynMap.put(obj.getLong("id"), obj));
        }
        return ItemTypeToItemDynMap;
    }

    public static Map<String, DynamicObjectCollection> queryItemMap(String reportPermEntityCode) {
        LinkedHashMap itemMap = Maps.newLinkedHashMapWithExpectedSize((int)itemEntityToFieldMap.size());
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"/UHMBBGZQ65X", (String)reportPermEntityCode);
        for (Map.Entry<String, String> itemEntry : itemEntityToFieldMap.entrySet()) {
            String orderBys;
            String entityCode = itemEntry.getKey();
            String fieldCodes = itemEntry.getValue();
            QFilter filter = SalaryRptItemService.getItemFilter(reportPermEntityCode, entityCode, hasPermOrgResult);
            String groupFieldCode = itemGroupFieldMap.get(entityCode);
            if ("hsbs_statisticstag".equals(entityCode)) {
                orderBys = "longnumber asc, number asc";
            } else if ("hsbs_attbizitem".equals(entityCode)) {
                orderBys = "index,number";
            } else if (!StringUtils.isEmpty((CharSequence)groupFieldCode)) {
                StringBuilder orderBysBuilder = new StringBuilder();
                orderBys = orderBysBuilder.append(groupFieldCode).append(".index,").append(groupFieldCode).append(".number,index,number").toString();
            } else {
                orderBys = "index,number";
            }
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityCode);
            DynamicObjectCollection collection = serviceHelper.queryColl(fieldCodes, new QFilter[]{filter}, orderBys);
            itemMap.put(entityCode, collection);
        }
        return itemMap;
    }

    private static QFilter getItemFilter(String reportPermEntityCode, String entityCode, HasPermOrgResult hasPermOrgResult) {
        QFilter permFilter;
        QFilter defaultFilter = new QFilter("status", "=", (Object)"C");
        if (StringUtils.equals((CharSequence)reportPermEntityCode, (CharSequence)"hsas_monthdeptsalsumrptquery") && !"hsbs_statisticstag".equals(entityCode)) {
            defaultFilter.and(new QFilter("datatype.storagetype", "in", (Object)Lists.newArrayList((Object[])new String[]{"amount", "num"})));
        }
        switch (entityCode) {
            case "hsbs_fetchitem": {
                permFilter = SalaryRptItemService.getNoControlItemFilter(entityCode);
                break;
            }
            default: {
                permFilter = SalaryRptItemService.getControlItemFilter(entityCode, hasPermOrgResult);
            }
        }
        if (permFilter != null) {
            defaultFilter.and(permFilter);
        }
        if ("hsbs_bizitem".equals(entityCode)) {
            defaultFilter.and(new QFilter("classification", "!=", (Object)"1"));
        } else if ("hsbs_attbizitem".equals(entityCode)) {
            defaultFilter.and(new QFilter("classification", "=", (Object)"1"));
        }
        return defaultFilter;
    }

    private static QFilter getControlItemFilter(String entityCode, HasPermOrgResult hasPermOrgResult) {
        if (hasPermOrgResult.hasAllOrgPerm()) {
            return null;
        }
        List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
        QFilter permFilter = new QFilter("1", "=", (Object)2);
        if (hasPermOrgs.size() > 0) {
            permFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)entityCode, (List)hasPermOrgs, (boolean)true);
        }
        return permFilter;
    }

    private static QFilter getNoControlItemFilter(String entityCode) {
        List filters = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)entityCode, (String)"47150e89000000ac");
        if (CollectionUtils.isEmpty((Collection)filters)) {
            return null;
        }
        QFilter filter = (QFilter)filters.get(0);
        for (int i = 1; i < filters.size(); ++i) {
            filter.and((QFilter)filters.get(i));
        }
        return filter;
    }

    public static void buildStatisticstagNodes(Map<String, RptDisplayColumnEntity> firstNodeMap, Map.Entry<String, DynamicObjectCollection> itemEntry, int defaultColWidth) {
        String entityCode = itemEntry.getKey();
        DynamicObjectCollection itemDyns = itemEntry.getValue();
        String itemPre = SalaryRptItemTypeEnum.getCodeByEntityCode((String)entityCode) + "_";
        ArrayList<RptDisplayColumnEntity> nodeList = new ArrayList<RptDisplayColumnEntity>(itemDyns.size());
        RptDisplayColumnEntity rootNode = firstNodeMap.get(entityCode);
        if (rootNode != null) {
            nodeList.add(rootNode);
        }
        RptDisplayColumnEntity itemNode = null;
        RptDisplayColumnEntity childrenNode = null;
        HashMap<String, List<RptDisplayColumnEntity>> dataMap = new HashMap<String, List<RptDisplayColumnEntity>>(itemDyns.size());
        HashMap<String, String> nodeRelMap = new HashMap<String, String>(itemDyns.size());
        long parentId = 0L;
        HashMap<String, RptDisplayColumnEntity> selfNodeMap = new HashMap<String, RptDisplayColumnEntity>(itemDyns.size());
        String parentValue = null;
        for (DynamicObject obj : itemDyns) {
            itemNode = SalaryRptItemService.getRptDisplayColumnEntityObj(defaultColWidth, itemPre, obj, false);
            parentId = obj.getLong("parent.id");
            if (parentId != 0L) {
                parentValue = "parent_" + itemPre + parentId;
                itemNode.setSecondaryHeader(obj.getString("parent.name"));
            } else {
                parentValue = entityCode;
            }
            nodeRelMap.put(itemNode.getFieldValue(), parentValue);
            List childrenList = dataMap.computeIfAbsent(parentValue, single -> new ArrayList(10));
            childrenList.add(itemNode);
            nodeList.add(itemNode);
            if (5 == obj.getInt("taglevel.level")) continue;
            childrenNode = SalaryRptItemService.getRptDisplayColumnEntityObj(defaultColWidth, itemPre, obj, true);
            childrenNode.setSecondaryHeader(itemNode.getSecondaryHeader());
            selfNodeMap.put(itemNode.getFieldValue(), childrenNode);
        }
        Map<String, RptDisplayColumnEntity> nodeMap = nodeList.stream().collect(Collectors.toMap(RptDisplayFieldEntity::getFieldValue, Function.identity()));
        for (RptDisplayColumnEntity node : nodeList) {
            SalaryRptItemService.assembleNodeData(node, nodeMap, dataMap, nodeRelMap);
        }
        if (rootNode == null || rootNode.getChildren() == null) {
            return;
        }
        for (RptDisplayColumnEntity node : rootNode.getChildren()) {
            SalaryRptItemService.addSelfNode(selfNodeMap, node.getChildren(), node);
        }
    }

    @NotNull
    private static RptDisplayColumnEntity getRptDisplayColumnEntityObj(int defaultColWidth, String itemPre, DynamicObject obj, boolean isChildNode) {
        RptDisplayColumnEntity itemNode = new RptDisplayColumnEntity();
        if (isChildNode || 5 == obj.getInt("taglevel.level")) {
            itemNode.setFieldValue(itemPre + obj.getLong("id"));
        } else {
            itemNode.setFieldValue("parent_" + itemPre + obj.getLong("id"));
        }
        itemNode.setFieldName(obj.getString("name"));
        itemNode.setColumnWidth(defaultColWidth);
        itemNode.setFieldAlias(itemNode.getFieldValue());
        itemNode.setFieldType(SalaryRptService.getRlsMap().get("num"));
        return itemNode;
    }

    private static void assembleNodeData(RptDisplayColumnEntity node, Map<String, RptDisplayColumnEntity> nodeMap, Map<String, List<RptDisplayColumnEntity>> dataMap, Map<String, String> nodeRelMap) {
        String id = node.getFieldValue();
        String parentId = nodeRelMap.get(id);
        if (SWCStringUtils.isNotEmpty((String)parentId)) {
            RptDisplayColumnEntity parentNode = nodeMap.get(parentId);
            if (parentNode == null) {
                return;
            }
            List parentChildList = dataMap.computeIfAbsent(parentId, single -> new ArrayList(10));
            parentNode.setChildren(parentChildList);
            List<RptDisplayColumnEntity> childList = dataMap.get(id);
            if (SWCListUtils.isEmpty(childList)) {
                return;
            }
            node.setChildren(childList);
            String itemPre = "hsbs_statisticstag";
            if (!SWCStringUtils.equals((String)itemPre, (String)parentId)) {
                SalaryRptItemService.assembleNodeData(parentNode, nodeMap, dataMap, nodeRelMap);
            }
        }
    }

    private static void addSelfNode(Map<String, RptDisplayColumnEntity> selfNodeMap, List<RptDisplayColumnEntity> nodeList, RptDisplayColumnEntity node) {
        RptDisplayColumnEntity selfNode = selfNodeMap.get(node.getFieldValue());
        if (selfNode == null) {
            return;
        }
        if (nodeList == null) {
            nodeList = new ArrayList<RptDisplayColumnEntity>(10);
            nodeList.add(selfNode);
            node.setChildren(nodeList);
            return;
        }
        for (RptDisplayColumnEntity temp : nodeList) {
            SalaryRptItemService.addSelfNode(selfNodeMap, temp.getChildren(), temp);
        }
        nodeList.add(0, selfNode);
    }

    static {
        itemEntityToFieldMap.put("hsbs_statisticstag", "id,number,name,parent.id,parent.number,parent.name,index,longnumber,taglevel.level,dataprecision.scale");
        itemEntityToFieldMap.put("hsbs_salaryitem", "id,number, name,index,enable, datatype.storagetype,datatype.showtype, datalength ,dataprecision.scale, dataround.number, salaryitemtype,salaryitemtype.number,salaryitemtype.index,salaryitemtype.name");
        itemEntityToFieldMap.put("hsbs_bizitem", "id,number,name,index,enable,datatype.storagetype,datatype.showtype, datalength,scalelimit,bizitemcategory,bizitemcategory.number,bizitemcategory.index,bizitemcategory.name");
        itemEntityToFieldMap.put("hsbs_attbizitem", "id,number,name,index,enable, datatype.storagetype,datatype.showtype, datalength,scalelimit,uniquecode,classification, attitemtype");
        itemEntityToFieldMap.put("hsbs_fetchitem", "id,number,name,index,enable,datatype.storagetype,datatype.showtype,fetchitemgroupid,fetchitemgroupid.number,fetchitemgroupid.index,fetchitemgroupid.name,dataprecision.scale,dataround.id");
        itemEntityToFieldMap.put("hsbs_supportitem", "id,number,name,index,enable,datatype.storagetype,datatype.showtype, datalength,dataprecision.scale, dataround.number");
        itemTypeToEntityCodeMap.put(SalaryRptItemTypeEnum.ITEM.getCode(), "hsbs_salaryitem");
        itemTypeToEntityCodeMap.put(SalaryRptItemTypeEnum.ITEMBS.getCode(), "hsbs_bizitem");
        itemTypeToEntityCodeMap.put(SalaryRptItemTypeEnum.ATTITEMBS.getCode(), "hsbs_attbizitem");
        itemTypeToEntityCodeMap.put(SalaryRptItemTypeEnum.ITEMBC.getCode(), "hsbs_fetchitem");
        itemTypeToEntityCodeMap.put(SalaryRptItemTypeEnum.ITEMSP.getCode(), "hsbs_supportitem");
        itemTypeToEntityCodeMap.put(SalaryRptItemTypeEnum.ITEMTAG.getCode(), "hsbs_statisticstag");
        itemGroupFieldMap.put("hsbs_salaryitem", "salaryitemtype");
        itemGroupFieldMap.put("hsbs_bizitem", "bizitemcategory");
        itemGroupFieldMap.put("hsbs_attbizitem", "attitemtype");
        itemGroupFieldMap.put("hsbs_fetchitem", "fetchitemgroupid");
        itemScaleFieldMap.put("hsbs_statisticstag", "dataprecision.scale");
        itemScaleFieldMap.put("hsbs_salaryitem", "dataprecision.scale");
        itemScaleFieldMap.put("hsbs_bizitem", "scalelimit");
        itemScaleFieldMap.put("hsbs_attbizitem", "scalelimit");
        itemScaleFieldMap.put("hsbs_supportitem", "dataprecision.scale");
        itemScaleFieldMap.put("hsbs_fetchitem", "dataprecision.scale");
    }
}

