/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.extension.ExtensionFactory;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hsas.business.api.ResourceLoader;
import kd.swc.hsas.business.bankoffer.excel.InputStreamLoader;
import kd.swc.hsas.business.stream.StreamType;
import kd.swc.hsas.business.stream.StreamTypeLoader;

public class StreamUtil {
    private static final Log LOGGER = LogFactory.getLog(StreamUtil.class);
    private static ExtensionFactory<InputStreamLoader> LOADER_MAP = ExtensionFactory.getExtensionFacotry(InputStreamLoader.class);
    private static Map<String, StreamType> STREAM_TYPE_MAP = new HashMap<String, StreamType>();

    private StreamUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(String fileName, InputStream inStream) {
        String string;
        try {
            string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, inStream, 10000);
        }
        catch (Exception e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when writeFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely(inStream);
                throw throwable;
            }
            StreamUtil.closeSafely(inStream);
            return string2;
        }
        StreamUtil.closeSafely(inStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String storeFile(String fileName, InputStream inStream) {
        String string;
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            RequestContext requestContext = RequestContext.get();
            String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"taxDataInGuide", (String)fileName);
            FileItem item = new FileItem(fileName, pathParam, inStream);
            String path = fileService.upload(item);
            string = UrlService.getAttachmentFullUrl((String)path);
        }
        catch (Exception e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when writeFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely(inStream);
                throw throwable;
            }
            StreamUtil.closeSafely(inStream);
            return string2;
        }
        StreamUtil.closeSafely(inStream);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeZipFile(Map<String, String> content, String fileName) {
        String string;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ZipOutputStream zos = new ZipOutputStream(outputStream);
        try {
            for (Map.Entry<String, String> entry : content.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey()));
                zos.write(entry.getValue().getBytes(Charset.forName("UTF-8")));
                zos.closeEntry();
            }
            zos.finish();
            string = StreamUtil.writeFile(fileName, new ByteArrayInputStream(outputStream.toByteArray()));
        }
        catch (IOException e) {
            String string2;
            try {
                LOGGER.warn("Error occurs when writeFile", (Throwable)e);
                string2 = null;
            }
            catch (Throwable throwable) {
                StreamUtil.closeSafely(zos, outputStream);
                throw throwable;
            }
            StreamUtil.closeSafely(zos, outputStream);
            return string2;
        }
        StreamUtil.closeSafely(zos, outputStream);
        return string;
    }

    public static void closeSafely(OutputStream ... oses) {
        if (oses != null) {
            for (OutputStream os : oses) {
                try {
                    os.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeSafely(InputStream ... ins) {
        if (ins != null) {
            for (InputStream in : ins) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeSafely(Scanner ... scanners) {
        if (scanners != null) {
            for (Scanner scanner : scanners) {
                try {
                    scanner.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeSafely(OutputStream os, InputStream in) {
        if (os != null) {
            try {
                os.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static InputStream loadInputStream(String resourceType, String url) {
        try {
            InputStreamLoader extension = (InputStreamLoader)LOADER_MAP.getExtension(resourceType);
            return extension.load(url);
        }
        catch (Exception e) {
            LOGGER.warn("Error occurs when load InputStream", (Throwable)e);
            return null;
        }
    }

    public static InputStream loadResource(String url) {
        for (StreamType streamType : STREAM_TYPE_MAP.values()) {
            if (!streamType.match(url)) continue;
            try {
                return ((InputStreamLoader)LOADER_MAP.getExtension(streamType.getCode())).load(streamType.clean(url));
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    static {
        ResourceLoader.load(StreamTypeLoader.class, STREAM_TYPE_MAP);
    }
}

