/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class AccHalfYearPersonIndexUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(AccHalfYearPersonIndexUpdateTask.class);
    private static final String QUERY_SQL = "SELECT TOP 10000 a.FID,p.fpersonindexid FROM T_HSAS_ACCRESULT a JOIN T_HSAS_EMPLOYEE e ON a.femployeeid= e.fid JOIN t_hsas_personhr p ON e.fpersonid = p.FID WHERE a.FPERSONINDEXID = 0 OR a.FPERSONINDEXID IS NULL";
    private static final String UPDATE_SQL = "UPDATE T_HSAS_ACCRESULT SET FPERSONINDEXID = ? WHERE FID = ?";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.debug("AccHalfYearPersonIndexUpdateTask started");
        this.updatePersonIndexByBatch();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        LOGGER.debug("AccHalfYearPersonIndexUpdateTask ended");
    }

    public void updatePersonIndexByBatch() {
        DBRoute dbRoute = new DBRoute("swc");
        DataSet dateSet = SWCDbUtil.queryDataSet((String)"AccHalfYearPersonIndexUpdateTask", (DBRoute)dbRoute, (String)QUERY_SQL, (Object[])new Object[0]);
        ArrayList updateList = Lists.newArrayListWithExpectedSize((int)10000);
        while (!dateSet.isEmpty()) {
            while (dateSet.hasNext()) {
                Row next = dateSet.next();
                updateList.add(new Object[]{next.getLong("fpersonindexid"), next.getLong("fid")});
            }
            SWCDbUtil.executeBatch((DBRoute)dbRoute, (String)UPDATE_SQL, (List)updateList);
            updateList.clear();
            dateSet.close();
            dateSet = SWCDbUtil.queryDataSet((String)"AccHalfYearPersonIndexUpdateTask", (DBRoute)dbRoute, (String)QUERY_SQL, (Object[])new Object[0]);
        }
        dateSet.close();
    }
}

