/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class AccumulatorDataUpgradeTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(AccumulatorDataUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("AccumulatorDataUpgradeTask start");
        QFilter qFilter = new QFilter("status", "in", (Object)new String[]{"A", "B", "C"});
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_accumulator");
        DynamicObjectCollection result = helper.queryOriginalCollection("id,createorg.id,ctrlstrategy,status", new QFilter[]{qFilter});
        if (result == null || result.size() == 0) {
            this.disableTask();
            return;
        }
        String queryUseRegSql = "select fdataid from t_hsas_accumulatorusereg";
        Set userRegIdSet = (Set)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)queryUseRegSql, (Object[])new Object[0], rs -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (rs.next()) {
                long id = rs.getLong(1);
                idSet.add(id);
            }
            return idSet;
        });
        String queryUSql = "select fdataid from t_hsas_accumulator_u";
        Set uIdSet = (Set)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)queryUSql, (Object[])new Object[0], rs -> {
            HashSet<Long> idSet = new HashSet<Long>(16);
            while (rs.next()) {
                long id = rs.getLong(1);
                idSet.add(id);
            }
            return idSet;
        });
        ArrayList<Object[]> saveUseRegList = new ArrayList<Object[]>(result.size());
        ArrayList<Object[]> saveUList = new ArrayList<Object[]>(result.size());
        Object[] saveObj = null;
        for (DynamicObject obj : result) {
            if (!"A".equals(obj.getString("status"))) {
                this.addUseRegData(userRegIdSet, saveUseRegList, obj);
            }
            if (uIdSet.contains(obj.getLong("id"))) continue;
            saveObj = new Object[]{obj.getLong("id"), obj.getLong("createorg.id")};
            saveUList.add(saveObj);
        }
        try (TXHandle tx = TX.requiresNew();){
            if (!saveUseRegList.isEmpty()) {
                String saveUserRegInsertSql = "insert into t_hsas_accumulatorusereg(fdataid, fuseorgid, fcreateorgid, fctrlstrategy, fisassign, fadminorgid, fassignorgid) values(?,?,?,?,?,?,?)";
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)saveUserRegInsertSql, saveUseRegList);
            }
            if (saveUList.size() > 0) {
                String insertSql = "insert into t_hsas_accumulator_u(fdataid, fuseorgid) values(?,?)";
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)insertSql, saveUList);
            }
        }
        this.disableTask();
        logger.info("AccumulatorDataUpgradeTask end");
    }

    private void addUseRegData(Set<Long> userRegIdSet, List<Object[]> saveUseRegList, DynamicObject obj) {
        if (userRegIdSet.contains(obj.getLong("id"))) {
            return;
        }
        Object[] saveObj = new Object[]{obj.getLong("id"), obj.getLong("createorg.id"), obj.getLong("createorg.id"), obj.getString("ctrlstrategy"), "0", 0L, null};
        saveUseRegList.add(saveObj);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

