/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BankOfferTplOldDataUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(BankOfferTplOldDataUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try {
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"hsas_bankoffertpl");
            EntityType type = (EntityType)mainType.getAllEntities().get("detailent");
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_bankoffertpl");
            String selectProperties = "id,isshowseq,detailent.seq,fieldname,fieldsource,fieldvalue,fieldquerytable,fieldselect,fieldlength,fixway,fixcontent,isshowthousandth,isnull";
            QFilter filter = new QFilter("1", "=", (Object)1);
            DynamicObject[] dynamicObjects = helper.query(selectProperties, new QFilter[]{filter});
            if (dynamicObjects == null || dynamicObjects.length == 0) {
                return;
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                this.setSeqEntry(dynamicObject, type);
                this.updateFieldEntry(dynamicObject);
            }
            helper.update(dynamicObjects);
            ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
            service.disableSchedule(taskInfo.getScheduleId());
        }
        catch (Exception e) {
            logger.error("update bankoffertpl failed!");
        }
    }

    private void setSeqEntry(DynamicObject tplData, EntityType type) {
        boolean isShowSeq = tplData.getBoolean("isshowseq");
        if (isShowSeq) {
            DynamicObject entry;
            DynamicObjectCollection detailEntCol = tplData.getDynamicObjectCollection("detailent");
            if (!detailEntCol.isEmpty() && "3".equals((entry = (DynamicObject)detailEntCol.get(0)).getString("fieldsource"))) {
                return;
            }
            DynamicObject detailEnt = (DynamicObject)type.createInstance();
            detailEnt.set("seq", (Object)0);
            detailEnt.set("fieldname", (Object)ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"BankOfferTplOldDataUpdateTask_0", (String)"swc-hsas-business", (Object[])new Object[0]));
            detailEnt.set("fieldsource", (Object)"3");
            detailEntCol.add(0, detailEnt);
        }
    }

    private void updateFieldEntry(DynamicObject tplData) {
        DynamicObjectCollection detailEntCol = tplData.getDynamicObjectCollection("detailent");
        for (DynamicObject detailEnt : detailEntCol) {
            String fieldSource = detailEnt.getString("fieldsource");
            String fieldQueryTable = detailEnt.getString("fieldquerytable");
            if (!"2".equals(fieldSource) || !SWCStringUtils.isEmpty((String)fieldQueryTable)) continue;
            detailEnt.set("fieldquerytable", (Object)"hsas_bankofferexport");
        }
    }
}

