/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class BizDataUniqueCodeUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(BizDataUniqueCodeUpdateTask.class);
    private static final int batchSize = 1000;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long startTime = System.currentTimeMillis();
        try {
            this.updateBizData("t_hsas_nonrecurbizdata");
            this.updateBizData("t_hsas_recurbizdata");
            this.addUniqueIndex();
        }
        catch (Exception e) {
            logger.error("BizDataUniqueCodeUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        logger.info("BizDataIdentifyNumberUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void addUniqueIndex() {
        logger.info("start to add unique index nonrecurbizdata");
        String sql = "IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_HSAS_NONRECURBIZDATA' AND KSQL_INDNAME = 'IDX_HSAS_NONRECURBIZDATA_UNC') CREATE UNIQUE INDEX IDX_HSAS_NONRECURBIZDATA_UNC ON T_HSAS_NONRECURBIZDATA ( FBIZUNIQUECODE )";
        DB.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        logger.info("end to add unique index nonrecurbizdata");
        logger.info("start to add unique index recurbizdata");
        sql = " IF NOT EXISTS (SELECT 1 FROM KSQL_INDEXES WHERE KSQL_TABNAME = 'T_HSAS_RECURBIZDATA' AND KSQL_INDNAME = 'IDX_HSAS_RECURBIZDATA_UNC') CREATE UNIQUE INDEX IDX_HSAS_RECURBIZDATA_UNC ON T_HSAS_RECURBIZDATA ( FBIZUNIQUECODE )";
        DB.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        logger.info("end to add unique index recurbizdata");
    }

    private void updateBizData(String tableName) {
        logger.info("start to deal bizdata indentifyNumber\uff1a{}", (Object)tableName);
        String beforeIdenNumStr = "";
        HashMap<Long, String> updateDataMap = new HashMap<Long, String>(1000);
        String tmpIdentifyNumber = "";
        StringBuilder sbSql = new StringBuilder();
        sbSql.append("select top ").append(1000).append(" fid,fidentifynumber,fbizitemid from ").append(tableName).append(" where fidentifynumber >= '");
        int currentCount = 1;
        while (true) {
            logger.info("{} current page is:{}", (Object)tableName, (Object)currentCount);
            StringBuilder querysb = new StringBuilder();
            querysb.append((CharSequence)sbSql).append(beforeIdenNumStr).append("' order by fidentifynumber asc,fcreatetime desc");
            List<Map<String, Object>> queryList = this.queryData(querysb);
            int index = 1;
            if (queryList != null && queryList.size() > 0) {
                for (Map<String, Object> queryMap : queryList) {
                    String bizuniquecode;
                    Long id;
                    String identifyNumber = (String)queryMap.get("identifynumber");
                    if (tmpIdentifyNumber.equals(identifyNumber)) {
                        id = (Long)queryMap.get("id");
                        bizuniquecode = (String)queryMap.get("bizuniquecode");
                        updateDataMap.put(id, bizuniquecode + "_" + index);
                        ++index;
                        continue;
                    }
                    id = (Long)queryMap.get("id");
                    bizuniquecode = (String)queryMap.get("bizuniquecode");
                    updateDataMap.put(id, bizuniquecode);
                    tmpIdentifyNumber = identifyNumber;
                    index = 1;
                }
            }
            if (updateDataMap.size() > 0) {
                this.updateUniqueCode(tableName, updateDataMap);
                updateDataMap.clear();
            }
            if (queryList != null) {
                if (queryList.size() < 1000) break;
                tmpIdentifyNumber = "";
                beforeIdenNumStr = (String)queryList.get(999).get("identifynumber");
            }
            ++currentCount;
        }
    }

    private List<Map<String, Object>> queryData(StringBuilder querysb) {
        List queryList = (List)DB.query((DBRoute)SWCConstants.SWC_ROUETE, (String)querysb.toString(), (Object[])new Object[0], (ResultSetHandler)new ResultSetHandler<List<Map<String, Object>>>(){

            public List<Map<String, Object>> handle(ResultSet rs) throws Exception {
                ArrayList<Map<String, Object>> retList = new ArrayList<Map<String, Object>>(1000);
                while (rs.next()) {
                    long id = rs.getLong(1);
                    String identifyNumber = rs.getString(2);
                    long bizItemId = rs.getLong(3);
                    HashMap<String, Object> retMap = new HashMap<String, Object>(2);
                    retMap.put("id", id);
                    retMap.put("identifynumber", identifyNumber);
                    retMap.put("bizuniquecode", identifyNumber + Long.toHexString(bizItemId));
                    retList.add(retMap);
                }
                return retList;
            }
        });
        return queryList;
    }

    private void updateUniqueCode(String tableName, Map<Long, String> updateDataMap) {
        String updateSql = "update " + tableName + " set fbizuniquecode = ? where fid = ?";
        ArrayList<Object[]> saveList = new ArrayList<Object[]>(10);
        if (updateDataMap != null && updateDataMap.size() > 0) {
            for (Map.Entry<Long, String> entry : updateDataMap.entrySet()) {
                Long id = entry.getKey();
                String bizuniquecode = entry.getValue();
                Object[] obj = new Object[]{bizuniquecode, id};
                saveList.add(obj);
            }
            DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, saveList);
        }
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

