/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class BizDataUpgradeTask
extends AbstractTask {
    private static final String codePrefix = "HSAS";
    private static final Log logger = LogFactory.getLog(BizDataUpgradeTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.queryNeedUpgradeData();
    }

    private void queryNeedUpgradeData() {
        logger.info("BizDataUpgradeService begin.");
        String recurSql = "SELECT FID from T_HSAS_RECURBIZDATA WHERE FIDENTIFYNUMBER = ' '";
        ArrayList<Long> recurIdList = new ArrayList<Long>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryRecurBizDataSQL", (DBRoute)SWCConstants.SWC_ROUETE, (String)recurSql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long id = row.getLong("FID");
                recurIdList.add(id);
            }
        }
        logger.info("recurIdList is: {}", (Object)JSON.toJSONString(recurIdList));
        List bizDataCodeList = (List)SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSBizDataCodeService", (String)"getBizDataCodes", (Object[])new Object[]{codePrefix, recurIdList.size()});
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(recurIdList.size());
        for (int index = 0; index < recurIdList.size(); ++index) {
            Long bizDataId = (Long)recurIdList.get(index);
            String bizDataCode = (String)bizDataCodeList.get(index);
            updateParamList.add(new Object[]{bizDataCode, bizDataId});
        }
        String nonRecurSql = "SELECT FID from T_HSAS_NONRECURBIZDATA WHERE FIDENTIFYNUMBER = ' '";
        ArrayList<Long> nonRecurIdList = new ArrayList<Long>(10);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryNonRecurBizDataSQL", (DBRoute)SWCConstants.SWC_ROUETE, (String)nonRecurSql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long id = row.getLong("FID");
                nonRecurIdList.add(id);
            }
        }
        logger.info("nonRecurIdList is: {}", (Object)JSON.toJSONString(nonRecurIdList));
        List nonRecurbizDataCodeList = (List)SWCMServiceUtils.invokeSWCService((String)"hsbs", (String)"IHSBSBizDataCodeService", (String)"getBizDataCodes", (Object[])new Object[]{codePrefix, nonRecurIdList.size()});
        ArrayList<Object[]> updateNonRecurParamList = new ArrayList<Object[]>(nonRecurIdList.size());
        for (int index = 0; index < nonRecurIdList.size(); ++index) {
            Long bizDataId = (Long)nonRecurIdList.get(index);
            String bizDataCode = (String)nonRecurbizDataCodeList.get(index);
            updateNonRecurParamList.add(new Object[]{bizDataCode, bizDataId});
        }
        String updateRecurSql = "UPDATE T_HSAS_RECURBIZDATA  SET FIDENTIFYNUMBER = ? WHERE FID = ?";
        String updateNonRecurSql = "UPDATE T_HSAS_NONRECURBIZDATA  SET FIDENTIFYNUMBER = ? WHERE FID = ?";
        try (TXHandle txHandle = TX.requiresNew();){
            if (!SWCListUtils.isEmpty(updateParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateRecurSql, updateParamList);
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateNonRecurSql, updateNonRecurParamList);
            }
            logger.info("BizDataUpgradeService end");
        }
        catch (Exception e) {
            logger.error("BizDataUpgradeService error,", (Throwable)e);
        }
        this.disableTask();
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

