/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;

public class CalRuleItemEntryDataUpdateTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        boolean isTableExist = SWCDbUtil.exitsTable((DBRoute)SWCConstants.SWC_ROUETE, (String)"t_hsbs_salaryitem");
        if (isTableExist) {
            String querySql = "select fid from t_hsbs_salaryitem where fenable = ? and fstatus = ? and ftaxtag = ?";
            Object[] queryParams = new Object[]{"1", "C", "0"};
            ArrayList salaryItemIds = Lists.newArrayListWithExpectedSize((int)10);
            try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"calRuleItemEntryDataUpdateTask", (DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, (Object[])queryParams);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    salaryItemIds.add(row.getLong("fid"));
                }
            }
            if (!salaryItemIds.isEmpty()) {
                StringBuilder updateSql = new StringBuilder();
                int size = salaryItemIds.size();
                updateSql.append("update t_hsas_calruleitementry set fdatasource = ?,fallowresultcover = ? where fdatasource = ? and fsalaryitemid in ");
                updateSql.append(this.getPlaceHolderConditionSql(size));
                Object[] updateParams = new Object[3 + size];
                updateParams[0] = "4";
                updateParams[1] = "1";
                updateParams[2] = "6";
                for (int i = 0; i < salaryItemIds.size(); ++i) {
                    Long salaryItemId = (Long)salaryItemIds.get(i);
                    updateParams[i + 3] = salaryItemId;
                }
                SWCDbUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql.toString(), (Object[])updateParams);
            }
        } else {
            throw new KDBizException("t_hsbs_salaryitem is not exist !");
        }
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private String getPlaceHolderConditionSql(int count) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

