/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.ReleaseStateEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class CalSalarySlipStatusUpdateTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(CalSalarySlipStatusUpdateTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (TXHandle txHandle = TX.requiresNew();){
            this.updateCalTableSalarySlip();
            this.updateCalSalarySlipRecord();
        }
    }

    private void updateCalTableSalarySlip() {
        QFilter filter;
        SWCDataServiceHelper calHelper;
        DynamicObject[] query;
        ISWCAppCache appCache = SWCAppCache.get((String)"paySalarySlip");
        appCache.remove("paySalarySlip");
        appCache = SWCAppCache.get((String)"payedlock");
        appCache.remove("payedlock");
        appCache = SWCAppCache.get((String)"recoverSalarySlip");
        appCache.remove("recoverSalarySlip");
        DLockInfo lockInfo = DLock.getLockInfo((String)"salaryslipparameterlock");
        if (lockInfo != null) {
            DLock.forceUnlock((String[])new String[]{lockInfo.getKey()});
        }
        if ((query = (calHelper = new SWCDataServiceHelper("hsas_calperson")).query("salarystatus,id", new QFilter[]{filter = new QFilter("salarystatus", "in", Arrays.asList(ReleaseStateEnum.RELEASEING.getCode(), ReleaseStateEnum.RECOVEREING.getCode()))})) == null || query.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : query) {
            String salaryStatus = dynamicObject.getString("salarystatus");
            if (ReleaseStateEnum.RELEASEING.getCode().equals(salaryStatus)) {
                dynamicObject.set("salarystatus", (Object)ReleaseStateEnum.RELEASEFAILED.getCode());
                continue;
            }
            if (!ReleaseStateEnum.RECOVEREING.getCode().equals(salaryStatus)) continue;
            dynamicObject.set("salarystatus", (Object)ReleaseStateEnum.RELEASED.getCode());
        }
        calHelper.update(query);
    }

    private void updateCalSalarySlipRecord() {
        SWCDataServiceHelper calRecordHelper = new SWCDataServiceHelper("hsas_calsalarysliprecord");
        QFilter filter = new QFilter("salarystatus", "in", Arrays.asList("1", "3"));
        filter.and(new QFilter("createtime", "<=", (Object)SWCDateTimeUtils.getBeforeDay((Date)new Date())));
        DynamicObject[] dyobjs = calRecordHelper.query("id,salarystatus", new QFilter[]{filter});
        if (dyobjs == null || dyobjs.length == 0) {
            return;
        }
        for (DynamicObject dynamicObject : dyobjs) {
            String salaryStatus = dynamicObject.getString("salarystatus");
            if ("1".equals(salaryStatus)) {
                dynamicObject.set("salarystatus", (Object)"5");
                continue;
            }
            if (!"3".equals(salaryStatus)) continue;
            dynamicObject.set("salarystatus", (Object)"6");
        }
        calRecordHelper.update(dyobjs);
    }
}

