/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.workflow.bpmn.converter.util.CollectionUtils;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.swc.hsbp.common.constants.SWCConstants;

public class CalTableDataFromMigrationUpgradeTask
extends AbstractTask {
    private static final String codePrefix = "HSAS";
    private static final Log LOGGER = LogFactory.getLog(CalTableDataFromMigrationUpgradeTask.class);
    private static final int BATCH_SIZE = 5000;
    private static final String SELECT_CALTABLE_SQL = "select fid,fcalpersonid from t_hsas_caltable where fcaltaskid = 0";
    private static final String SELECT_CALPERSON_SQL = "select fid,fcalresultid,forgid,fcaltaskid,fcalperiodid from t_hsas_calperson where fcaltaskid > 0 and fid in ";
    private static final String DELETE_CALTABLE_SQL = "delete from t_hsas_caltable where fid in ";
    private static final String DELETE_CALTABLE_ENTRY_SQL = "delete from t_hsas_caltableentry where fid in ";
    private static final String DELETE_CAL_BS_ENTRY_SQL = "delete from t_hsas_calbsentry where fid in ";
    private static final String DELETE_CAL_SP_ENTRY_SQL = "delete from t_hsas_calspentry where fid in ";
    private static final String DELETE_CAL_BC_ENTRY_SQL = "delete from t_hsas_calbcentry where fid in ";
    private static final String UPDATE_CALTABLE_SQL = "update t_hsas_caltable set forgid = ?,fcaltaskid = ?,fcalperiodid = ? where fid = ?";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updateCalTableData();
            }
        }
        catch (Exception e) {
            LOGGER.error("CalTableDataFromMigrationUpgradeTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOGGER.info("CalTableDataFromMigrationUpgradeTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateCalTableData() {
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryCalTableInfo", (DBRoute)SWCConstants.SWC_ROUETE, (String)SELECT_CALTABLE_SQL);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryCalTableInfo", (DBRoute)SWCConstants.SWC_ROUETE, (String)SELECT_CALTABLE_SQL);
            this.queryBatch = 0;
            LOGGER.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashSet<Long> calTableIdSet = new HashSet<Long>(5000);
        HashSet<Long> calPersonIdSet = new HashSet<Long>(5000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            calTableIdSet.add(id);
            calPersonIdSet.add(row.getLong("fcalpersonid"));
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        if (calTableIdSet.size() > 0) {
            try (TXHandle txHandle = TX.requiresNew();){
                String selectCalPersonSql = SELECT_CALPERSON_SQL + this.getPlaceHolderConditionSql(calPersonIdSet.size());
                HashMap<Long, Map<String, Object>> calPersonInfoMap = new HashMap<Long, Map<String, Object>>(calTableIdSet.size());
                HashSet<Long> usedCalTableIdSet = new HashSet<Long>(calTableIdSet.size());
                HashSet<Long> unUsedCalTableIdSet = new HashSet<Long>(calTableIdSet.size());
                try (DataSet dataSet = HRDBUtil.queryDataSet((String)"queryCalPersonDataService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectCalPersonSql, (Object[])calPersonIdSet.toArray());){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        HashMap<String, Long> calPersonInfo = new HashMap<String, Long>(3);
                        calPersonInfo.put("forgid", row.getLong("forgid"));
                        calPersonInfo.put("fcaltaskid", row.getLong("fcaltaskid"));
                        calPersonInfo.put("fcalperiodid", row.getLong("fcalperiodid"));
                        calPersonInfoMap.put(row.getLong("fcalresultid"), calPersonInfo);
                        usedCalTableIdSet.add(row.getLong("fcalresultid"));
                    }
                }
                unUsedCalTableIdSet.addAll(calTableIdSet);
                unUsedCalTableIdSet.removeAll(usedCalTableIdSet);
                this.updateUsedCalTable(usedCalTableIdSet, calPersonInfoMap);
                this.deleteUnUsedCalTable(unUsedCalTableIdSet);
            }
        }
        return true;
    }

    private void updateUsedCalTable(Set<Long> usedCalTableIdSet, Map<Long, Map<String, Object>> calPersonInfoMap) {
        if (CollectionUtils.isEmpty(usedCalTableIdSet)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(usedCalTableIdSet.size());
        for (Long usedCalTableId : usedCalTableIdSet) {
            Map<String, Object> calPersonInfo = calPersonInfoMap.get(usedCalTableId);
            if (calPersonInfo == null) continue;
            Object[] params = new Object[]{calPersonInfo.get("forgid"), calPersonInfo.get("fcaltaskid"), calPersonInfo.get("fcalperiodid"), usedCalTableId};
            paramsList.add(params);
        }
        HRDBUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)UPDATE_CALTABLE_SQL, paramsList);
    }

    private void deleteUnUsedCalTable(Set<Long> unUsedCalTableIdSet) {
        if (CollectionUtils.isEmpty(unUsedCalTableIdSet)) {
            return;
        }
        String placeHolderConditionSql = this.getPlaceHolderConditionSql(unUsedCalTableIdSet.size());
        String deleteCalTableSql = DELETE_CALTABLE_SQL + placeHolderConditionSql;
        String deleteCalBcEntrySql = DELETE_CAL_BC_ENTRY_SQL + placeHolderConditionSql;
        String deleteCalBsEntrySql = DELETE_CAL_BS_ENTRY_SQL + placeHolderConditionSql;
        String deleteCalSpEntrySql = DELETE_CAL_SP_ENTRY_SQL + placeHolderConditionSql;
        String deleteCalTableEntrySql = DELETE_CALTABLE_ENTRY_SQL + placeHolderConditionSql;
        HRDBUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteCalTableSql, (Object[])unUsedCalTableIdSet.toArray());
        HRDBUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteCalBcEntrySql, (Object[])unUsedCalTableIdSet.toArray());
        HRDBUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteCalBsEntrySql, (Object[])unUsedCalTableIdSet.toArray());
        HRDBUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteCalSpEntrySql, (Object[])unUsedCalTableIdSet.toArray());
        HRDBUtil.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteCalTableEntrySql, (Object[])unUsedCalTableIdSet.toArray());
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }

    private String getPlaceHolderConditionSql(int count) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int index = 0; index < count; ++index) {
            if (index > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('?');
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

