/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.cal.helper.CalPersonListHelper;
import kd.swc.hsas.business.cal.helper.CalResultCoverHelper;
import kd.swc.hsas.business.progress.CalPersonOPProgressInfo;
import kd.swc.hsas.business.salarydeatilresult.helper.SalaryDetailResultMarkListHelper;
import kd.swc.hsbp.business.cal.helper.PayrollTaskHelper;
import kd.swc.hsbp.business.calperson.CalPersonHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.enums.CalPersonOperationEnum;
import kd.swc.hsbp.common.enums.CalStateEnum;

public class DeleteCalPersonTask {
    private static final Log LOGGER = LogFactory.getLog(DeleteCalPersonTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> execute(List<Long> ids, Long taskId) {
        try {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
            QFilter filter = new QFilter("id", "in", ids);
            List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)"hsas_calperson", (String)CalPersonOperationEnum.OP_DELCALPERSON.getPermission());
            if (authorizedDataRuleQFilter != null) {
                authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
            } else {
                filter.and("1", "!=", (Object)1);
            }
            DynamicObjectCollection hasPermsDatas = helper.queryOriginalCollection("id", filter.toArray());
            Set hasPermIds = hasPermsDatas.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            HashSet<Long> notHasPermIds = new HashSet<Long>(ids);
            notHasPermIds.removeAll(hasPermIds);
            QFilter permFilter = new QFilter("id", "in", hasPermIds);
            permFilter.and("calstatus", "!=", (Object)CalStateEnum.UNCAL.getCode());
            DynamicObjectCollection statusfails = helper.queryOriginalCollection("id,filenumber", permFilter.toArray());
            DynamicObjectCollection noPermFails = helper.queryOriginalCollection("id,filenumber", new QFilter("id", "in", notHasPermIds).toArray());
            ArrayList<String> errormsglist = new ArrayList<String>(statusfails.size() + notHasPermIds.size());
            String errmsg = ResManager.loadKDString((String)"%s\uff1a\u5220\u9664\u5931\u8d25\uff0c\u53ea\u53ef\u5bf9\u6838\u7b97\u72b6\u6001\u4e3a\u201c\u672a\u8ba1\u7b97\u201d\u7684\u6838\u7b97\u4eba\u5458\u8bb0\u5f55\u64cd\u4f5c\u5220\u9664\u3002", (String)"DeleteCalPersonTask_0", (String)"swc-hsas-business", (Object[])new Object[0]);
            String noPermMsg = ResManager.loadKDString((String)"%s\uff1a\u5f88\u62b1\u6b49\uff0c\u60a8\u6ca1\u6709[\u5220\u9664][\u6838\u7b97\u540d\u5355]\u7684\u6570\u636e\u89c4\u5219\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DeleteCalPersonTask_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            statusfails.forEach(o -> errormsglist.add(String.format(Locale.ROOT, errmsg, o.getString("filenumber"))));
            noPermFails.forEach(o -> errormsglist.add(String.format(Locale.ROOT, noPermMsg, o.getString("filenumber"))));
            Set errids = statusfails.stream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            CalPersonOPProgressInfo progressinfo = new CalPersonOPProgressInfo();
            progressinfo.setTotal(ids.size());
            progressinfo.setFail(errormsglist.size());
            progressinfo.setFailList(errormsglist);
            progressinfo.setFinish(errormsglist.size());
            progressinfo.setRemain(progressinfo.getTotal() - progressinfo.getFinish());
            ISWCAppCache appCache = SWCAppCache.get((String)"hsas");
            ids.removeAll(errids);
            ids.removeAll(notHasPermIds);
            SalaryDetailResultMarkListHelper salaryDetailHelper = new SalaryDetailResultMarkListHelper();
            List partition = Lists.partition(ids, (int)5000);
            for (List bathids : partition) {
                appCache.put(String.format(Locale.ROOT, "CAL_PERSON_DEL_CACHE_KEY_%s", taskId), (Object)progressinfo);
                helper.delete(bathids.toArray());
                salaryDetailHelper.delCalPersonAndDelCalPersonMark(taskId, new HashSet<Long>(bathids));
                progressinfo.setFinish(progressinfo.getFinish() + bathids.size());
                progressinfo.setSuccess(progressinfo.getSuccess() + bathids.size());
                progressinfo.setRemain(progressinfo.getTotal() - progressinfo.getFinish());
                this.deleteProration(bathids);
                CalResultCoverHelper.cleanPersonCoverData(bathids);
            }
            CalPersonListHelper.updatePersonCount(taskId);
            PayrollTaskHelper.updateCalPayRollTaskStatus((Long)taskId);
            appCache.put(String.format(Locale.ROOT, "CAL_PERSON_DEL_CACHE_KEY_%s", taskId), (Object)progressinfo);
            ArrayList<String> arrayList = errormsglist;
            return arrayList;
        }
        finally {
            CalPersonHelper.releaseLock((Long)taskId);
            PayrollTaskHelper.release((String)"hsas_calpayrolltask", (String)String.valueOf(taskId), (String)CalPersonOperationEnum.OP_DELCALPERSON.getOperationKey());
        }
    }

    public void deleteProration(List<Long> calPersonIdList) {
        if (CollectionUtils.isEmpty(calPersonIdList)) {
            return;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calprorationrel");
        QFilter[] filters = new QFilter[]{new QFilter("calpersonid", "in", calPersonIdList)};
        DynamicObject[] calProrationRels = helper.queryOriginalArray("id,prorationevent.id", filters);
        if (calProrationRels == null || calProrationRels.length == 0) {
            return;
        }
        Object[] pks = new Object[calProrationRels.length];
        LinkedList<Long> eventIds = new LinkedList<Long>();
        for (int index = 0; index < calProrationRels.length; ++index) {
            pks[index] = calProrationRels[index].get("id");
            eventIds.add(calProrationRels[index].getLong("prorationevent.id"));
        }
        helper.delete(pks);
        DynamicObjectCollection existRels = helper.queryOriginalCollection("prorationevent.id", new QFilter[]{new QFilter("prorationevent.id", "in", eventIds)});
        Set existEventIdSet = existRels.stream().map(existRel -> existRel.getLong("prorationevent.id")).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(existEventIdSet)) {
            eventIds.removeAll(existEventIdSet);
        }
        if (!CollectionUtils.isEmpty(eventIds)) {
            DynamicObject[] prorationEvents;
            helper.setEntityName("hsas_prorationevent");
            for (DynamicObject prorationEvent : prorationEvents = helper.query(eventIds.toArray())) {
                prorationEvent.set("referencestatus", (Object)"1");
            }
            helper.update(prorationEvents);
        }
        helper.setEntityName("hsas_slprorationrecord");
        helper.deleteByFilter(filters);
    }
}

