/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.alibaba.fastjson.JSONArray;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class MessageTplPreDataUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(MessageTplPreDataUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.debug("MessageTplPreDataUpdateTask started");
        this.updateData();
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        LOGGER.debug("MessageTplPreDataUpdateTask ended");
    }

    private void updateData() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("msg_template");
        QFilter filter = new QFilter("id", "=", (Object)1227440757489623040L);
        DynamicObject msg = helper.queryOne("number,name,msgtype,msgchannel,msgentity,msgscenename,msgscene,msgscenevalue,msgtemplate,commonlang", new QFilter[]{filter});
        if (msg != null) {
            DynamicObject msgScene;
            this.deleteCache(msg);
            String messageTplPreDataUpdateTask_3 = ResManager.loadKDString((String)"{\"content\":\"{model.salaryfilehis.person.name}\u60a8\u597d\uff1a\n\u60a8\u7684\u94f6\u884c\u5361\uff08{model.perbankcard.username}{model.perbankcard.bankcardnum}\uff09\u88ab\u53d1\u8d77\u53d8\u66f4\u3002\u5904\u7406\u4eba\uff1a{model.acctmodifybill.handler.name}\u3002\u8bf7\u77e5\u6089\u3002\"}", (String)"MessageTplPreDataUpdateTask_3", (String)"swc-hsas-business", (Object[])new Object[0]);
            String messageTplPreDataUpdateTask_1 = ResManager.loadKDString((String)"{\"content\":\"{model.personhis.name}\u60a8\u597d\uff1a\n\u60a8\u7684\u94f6\u884c\u8d26\u6237\uff08{model.receivername}{model.bankaccount}\uff09\u88ab\u53d1\u8d77\u53d8\u66f4\u3002\u5904\u7406\u4eba\uff1a{model.acctmodifybill.auditor.name}\u3002\u8bf7\u77e5\u6089\u3002\"}", (String)"MessageTplPreDataUpdateTask_1", (String)"swc-hsas-business", (Object[])new Object[0]);
            this.compareAndSet(msg, "number", "bankaccount001", "hsas_bankaccountmodify");
            this.compareAndSet(msg, "name", ResManager.loadKDString((String)"\u77ed\u4fe1\u63d0\u9192", (String)"MessageTplPreDataUpdateTask_0", (String)"swc-hsas-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u975e\u5458\u5de5\u672c\u4eba\u53d8\u66f4\u94f6\u884c\u5361_\u5458\u5de5\u63d0\u9192", (String)"MessageTplPreDataUpdateTask_2", (String)"swc-hsas-business", (Object[])new Object[0]));
            this.compareAndSet(msg, "msgtemplate", messageTplPreDataUpdateTask_1, messageTplPreDataUpdateTask_3);
            this.compareAndSet(msg, "commonlang", messageTplPreDataUpdateTask_1, messageTplPreDataUpdateTask_3);
            if (SWCStringUtils.isEmpty((String)msg.getString("commonlang"))) {
                msg.set("commonlang", (Object)messageTplPreDataUpdateTask_3);
            }
            if ((msgScene = (helper = new SWCDataServiceHelper("msg_tplscene")).queryOne("id,name", new QFilter[]{filter = new QFilter("id,number,name", "=", (Object)1236063189087582208L)})) != null) {
                this.compareAndSet(msgScene, "name", ResManager.loadKDString((String)"\u94f6\u884c\u8d26\u6237\u53d8\u66f4", (String)"MessageTplPreDataUpdateTask_4", (String)"swc-hsas-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u94f6\u884c\u5361\u53d8\u66f4", (String)"MessageTplPreDataUpdateTask_5", (String)"swc-hsas-business", (Object[])new Object[0]));
                helper.saveOne(msgScene);
            }
            if (CollectionUtils.isEmpty((Collection)msg.getDynamicObjectCollection("msgscenevalue")) && msgScene != null) {
                msg.set("msgscenevalue", (Object)this.getMulBaseDataDyColl(msg, Collections.singletonList(1236063189087582208L), "msgscenevalue", "msg_tplscene"));
                msg.set("msgscenename", (Object)msgScene.getString("name"));
                msg.set("msgscene", (Object)msgScene.getString("number"));
            }
            helper.saveOne(msg);
        }
    }

    private void deleteCache(DynamicObject data) {
        String msgType = data.getString("msgtype");
        String msgChannel = data.getString("msgchannel");
        String[] msgScene = data.getString("msgscene").split(",");
        String entityNumber = data.getString("msgentity.number");
        String number = data.getString("number");
        JSONArray cacheKeys = new JSONArray();
        for (String aMsgScene : msgScene) {
            String k = MsgServiceCacheHelper.getTemplateCacheKey((String)msgType, (String)msgChannel, (String)aMsgScene, (String)entityNumber);
            cacheKeys.add((Object)k);
        }
        if (StringUtils.isNotBlank((CharSequence)number)) {
            String k = MsgServiceCacheHelper.getTemplateCacheKey((String)number);
            cacheKeys.add((Object)k);
        }
        String[] deleteCacheKeys = (String[])cacheKeys.toArray((Object[])new String[0]);
        MsgServiceCacheHelper.deleteCache((String[])deleteCacheKeys);
    }

    private void compareAndSet(DynamicObject data, String field, String oldValue, String newValue) {
        if (oldValue.equals(data.getString(field))) {
            data.set(field, (Object)newValue);
        }
    }

    private DynamicObjectCollection getMulBaseDataDyColl(DynamicObject data, List<Long> fieldValueIds, String fieldName, String mulBasedataEntity) {
        DynamicObjectCollection dyColl = data.getDynamicObjectCollection(fieldName);
        DynamicObjectType dynamicObjectType = dyColl.getDynamicObjectType();
        for (Long fieldValueId : fieldValueIds) {
            DynamicObject mulBasedataDy = new DynamicObject(dynamicObjectType);
            DynamicObject personDy = this.getDynamicObjectById(mulBasedataEntity, fieldValueId);
            mulBasedataDy.set("fbasedataid", (Object)personDy);
            dyColl.add((Object)mulBasedataDy);
        }
        return dyColl;
    }

    private DynamicObject getDynamicObjectById(String entityName, Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }
}

