/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCListUtils;

public class NonRecurbizDataCalBackUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(NonRecurbizDataCalBackUpdateTask.class);
    private static final int batchSize = 5000;
    private static final String querySql = "select fid from t_hsas_nonrecurbizdata non where non.fbizdatarecordid > 0 and fusagecount = 0 and not exists (select record.fid from t_hsas_bizdatarecord record where non.fbizdatarecordid = record.fid)";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        Long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.dealNonBizData();
            }
        }
        catch (Exception e) {
            logger.error("NonRecurbizDataCalBackUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        logger.info("NonRecurbizDataCalBackUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean dealNonBizData() {
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryNonBizDataSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)querySql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryNonBizDataSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)querySql);
            this.queryBatch = 0;
            logger.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        ArrayList<Long> bizDataIdList = new ArrayList<Long>(10);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long id = row.getLong("fid");
            bizDataIdList.add(id);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        List splitBizDataIdList = SWCListUtils.split(bizDataIdList, (int)500);
        String preSql = "delete from t_hsas_nonrecurbizdata where fid in (";
        for (List list : splitBizDataIdList) {
            StringBuilder sb = new StringBuilder(preSql);
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                sb.append(list.get(i));
                if (i == size - 1) continue;
                sb.append(',');
            }
            sb.append(')');
            this.delData(sb.toString());
        }
        return true;
    }

    private void delData(String sql) {
        DB.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

