/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.OnHoldStatusEnum;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class OnHoldBillStatusUpdateTask
extends AbstractTask {
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        SWCDataServiceHelper onHoldHelper = new SWCDataServiceHelper("hsas_onholdbill");
        String selectProperties = "id,status,releasedate";
        QFilter qFilter = new QFilter("status", "=", (Object)(OnHoldStatusEnum.STATUS_ONHOLD.getCode() + ""));
        DynamicObject[] dynamicObjects = onHoldHelper.query(selectProperties, new QFilter[]{qFilter});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return;
        }
        Date currDate = new Date();
        Date releaseDate = null;
        ArrayList<DynamicObject> needUpdateList = new ArrayList<DynamicObject>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            releaseDate = dynamicObject.getDate("releasedate");
            if (releaseDate == null || !SWCDateTimeUtils.dayBefore((Date)releaseDate, (Date)currDate)) continue;
            dynamicObject.set("status", (Object)OnHoldStatusEnum.STATUS_TOPAY.getCode());
            needUpdateList.add(dynamicObject);
        }
        if (needUpdateList.size() > 0) {
            DynamicObject[] needUpdateDatas = new DynamicObject[needUpdateList.size()];
            for (int index = 0; index < needUpdateList.size(); ++index) {
                needUpdateDatas[index] = (DynamicObject)needUpdateList.get(index);
            }
            onHoldHelper.update(needUpdateDatas);
        }
    }
}

