/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.SceneGroupVO;
import kd.swc.hsbp.common.vo.SceneRuleVO;

public class PayRollSceneUpdateTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PayRollSceneUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        LOGGER.debug("PayRollSceneUpdateTask started");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payrollscene");
        DynamicObject[] scenes = helper.query("id,groupcontent,callistrule,entryentity,entryentity.salarycalcstyle,entryentity.attachcondition,entryentity.calbordermulbd", new QFilter("1", "=", (Object)1).toArray());
        if (scenes != null) {
            ArrayList<DynamicObject> updateScenes = new ArrayList<DynamicObject>(scenes.length);
            for (DynamicObject scene : scenes) {
                if (SWCStringUtils.isNotEmpty((String)scene.getString("groupcontent"))) continue;
                ArrayList<SceneGroupVO> groups = new ArrayList<SceneGroupVO>(10);
                DynamicObject calListRule = scene.getDynamicObject("callistrule");
                DynamicObjectCollection entryColl = scene.getDynamicObjectCollection("entryentity");
                SceneGroupVO group = new SceneGroupVO();
                group.setIndex(1);
                group.setName(ResManager.getLocaleString((String)"\u9ed8\u8ba4\u89c4\u5219", (String)"PayRollSceneUpdateTask_1", (String)"swc-hsas-business"));
                group.setCalListRuleId(calListRule != null ? Long.valueOf(calListRule.getLong("id")) : null);
                ArrayList<SceneRuleVO> rules = new ArrayList<SceneRuleVO>(10);
                if (entryColl != null) {
                    for (DynamicObject entry : entryColl) {
                        SceneRuleVO rule = new SceneRuleVO();
                        rule.setAttachcondition(entry.getString("attachcondition"));
                        rule.setCalcstyle(Long.valueOf(entry.getLong("salarycalcstyle.id")));
                        DynamicObjectCollection mulbizItems = entry.getDynamicObjectCollection("calbordermulbd");
                        if (mulbizItems != null) {
                            List bizItems = mulbizItems.stream().map(o -> o.getLong("fbasedataid_id")).collect(Collectors.toList());
                            rule.setBizItems(bizItems);
                        }
                        rules.add(rule);
                    }
                }
                group.setRules(rules);
                groups.add(group);
                scene.set("groupcontent", (Object)JSON.toJSONString(groups));
                updateScenes.add(scene);
            }
            helper.save(updateScenes.toArray(new DynamicObject[0]));
        }
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableSchedule(taskInfo.getScheduleId());
        LOGGER.debug("PayRollSceneUpdateTask ended");
    }
}

