/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.swc.hsas.common.enums.PayScheduleStatusEnum;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class PaySchStatusUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(PaySchStatusUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        logger.info("PaySchStatusUpdateTask is Started!");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_payschedule");
        String props = "schedulestatus,enddate";
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        qFilter.and(new QFilter("schedulestatus", "in", (Object)new String[]{PayScheduleStatusEnum.UNSTARTED.getCode(), PayScheduleStatusEnum.PROCESSING.getCode()}));
        DynamicObject[] paySchDys = helper.query(props, qFilter.toArray());
        DynamicObjectCollection savePaySchDys = new DynamicObjectCollection();
        Date currentDay = SWCDateTimeUtils.addDay((Date)new Date(), (long)-1L);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String currDateStr = format.format(currentDay);
        for (DynamicObject paySchDy : paySchDys) {
            Date endDate = paySchDy.getDate("enddate");
            if (!endDate.before(currentDay) && !currDateStr.equals(format.format(endDate))) continue;
            paySchDy.set("schedulestatus", (Object)PayScheduleStatusEnum.OVERDUE.getCode());
            savePaySchDys.add((Object)paySchDy);
        }
        if (!savePaySchDys.isEmpty()) {
            helper.save(savePaySchDys);
            logger.info("PaySchStatusUpdateTask is End!");
        }
    }
}

