/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsas.business.modifybankaccount.helper.BankAccountModifyHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class PerBankModifyBillPerContactUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PerBankModifyBillPerContactUpdateTask.class);
    private static final int batchSize = 5000;
    private static final String tableName = "t_hsas_perbceditbill";
    private static final String sql = "select fpersonid from t_hsas_perbceditbill where fpercontactid = 0 or fpercontactid is null";
    private DataSet rows = null;
    private int queryBatch = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            boolean flag = true;
            while (flag) {
                flag = this.updatePerBankPerContactId();
            }
        }
        catch (Exception e) {
            LOG.error("PerBankModifyBillPerContactUpdateTask execute error:", (Throwable)e);
        }
        finally {
            this.disableTask();
        }
        LOG.info("PerBankModifyBillPerContactUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private boolean updatePerBankPerContactId() {
        LOG.info("start to deal t_hsas_perbceditbill \uff1a{}", (Object)tableName);
        long startTimeMillis = System.currentTimeMillis();
        if (this.rows == null) {
            this.rows = DB.queryDataSet((String)"queryPerBankModifyBillEntSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
        }
        if (this.queryBatch >= 1000) {
            this.rows.close();
            this.rows = DB.queryDataSet((String)"queryPerBankModifyBillEntSQl", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql);
            this.queryBatch = 0;
            LOG.info("\u5b8c\u62101000\u6279\u6b21\u67e5\u8be2\u540e,dataset\u8fdb\u884c\u91cd\u7f6e,\u9632\u6b62\u8d85\u65f6!");
        }
        if (!this.rows.hasNext()) {
            return false;
        }
        HashSet<Long> personIdSet = new HashSet<Long>(5000);
        int count = 0;
        while (this.rows.hasNext()) {
            Row row = this.rows.next();
            Long personId = row.getLong("fpersonid");
            personIdSet.add(personId);
            if (++count < 5000) continue;
            ++this.queryBatch;
            break;
        }
        long endTimeMillis = System.currentTimeMillis();
        LOG.info(" execute query t_hsas_perbceditbill used : {}", (Object)(endTimeMillis - startTimeMillis));
        Map<Long, Long> perContactMap = BankAccountModifyHelper.getPerContactMapByPersonIds(new ArrayList<Long>(personIdSet));
        this.updatePerBankPerContactId(personIdSet, perContactMap);
        return true;
    }

    private void updatePerBankPerContactId(Set<Long> personIdSet, Map<Long, Long> perContactMap) {
        String updateSql = "update t_hsas_perbceditbill set fpercontactid = ? where fpersonid = ?";
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(10);
        for (Long personId : personIdSet) {
            Long perContactId = perContactMap.get(personId);
            Object[] obj = perContactId == null || perContactId == 0L ? new Object[]{-1, personId} : new Object[]{perContactId, personId};
            updateList.add(obj);
        }
        DB.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)updateSql, updateList);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

