/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.business.task;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.swc.hsas.business.personhr.SyncPersonHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.threadpool.SWCUnifiedThreadPoolFactory;
import kd.swc.hsbp.common.enums.SWCUnifiedTaskTypeEnum;

public class PerprotitleDataUpgradeTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(PerprotitleDataUpgradeTask.class);
    private static Map<String, String> formIdMap = new LinkedHashMap<String, String>();
    public static final int DEAL_SIZE = 15000;
    public static final int DEFAULT_SIZE = 5000;
    public static final int SAVE_DATA_SIZE = 500;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.doUpgrade(map);
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        service.disableSchedule("48E6H33WE+OV");
    }

    private void doUpgrade(Map<String, Object> paramMap) {
        LOGGER.info("PerprotitleDataUpgradeTask...Start");
        formIdMap.forEach(this::syncPersonInfo);
    }

    private void syncPersonInfo(String orgEntity, String destEntity) {
        SWCDataServiceHelper desthelper = new SWCDataServiceHelper(destEntity);
        switch (destEntity) {
            case "hsas_perprotitlehr": 
            case "hsas_pereduexp": {
                QFilter qFilter = QFilter.of((String)"1 = 1", (Object[])new Object[0]);
                this.syncPersonWithBoid(orgEntity, destEntity, desthelper, qFilter);
                break;
            }
        }
    }

    private void syncPersonWithBoid(String orgEntity, String destEntity, SWCDataServiceHelper desthelper, QFilter qFilter) {
        Long maxBoId = 0L;
        while (true) {
            QFilter hisCurrFilter = BaseDataHisHelper.getHisCurrFilter();
            hisCurrFilter.and("id", ">", (Object)maxBoId);
            DynamicObject[] orgdys = desthelper.query("id", new QFilter[]{qFilter, hisCurrFilter}, "id", 15000);
            if (orgdys == null || orgdys.length == 0) break;
            maxBoId = orgdys[orgdys.length - 1].getLong("id");
            Set<Long> entityBoIds = Arrays.stream(orgdys).map(single -> single.getLong("id")).collect(Collectors.toSet());
            this.dealSyncPersonEntity(orgEntity, destEntity, entityBoIds);
        }
    }

    private void dealSyncPersonEntity(String orgEntity, String destEntity, Set<Long> resBoIds) {
        LOGGER.info("PerprotitleDataUpgradeTask...sync begin orgEntity:{}, destEntity:{}, resBoIds.size:{}", new Object[]{orgEntity, destEntity, resBoIds.size()});
        List subList = Lists.partition(new ArrayList<Long>(resBoIds), (int)5000);
        SyncPersonHelper syncPersonHelper = new SyncPersonHelper();
        ArrayList<Future> futureList = new ArrayList<Future>(subList.size());
        for (List empList : subList) {
            Future future = SWCUnifiedThreadPoolFactory.SERVICE.submit(() -> {
                List subEntityBoIds = Lists.partition((List)empList, (int)500);
                for (List currentEntityBoIds : subEntityBoIds) {
                    syncPersonHelper.syncPersonOneEntity(orgEntity, destEntity, currentEntityBoIds);
                }
                return Boolean.TRUE;
            }, SWCUnifiedTaskTypeEnum.SWC_HSAS_PERSONSYNCTHREADPOOL.getKey(), RequestContext.get(), OperationContext.get());
            futureList.add(future);
        }
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error((Throwable)e);
        }
    }

    static {
        formIdMap.put("hrpi_perprotitle", "hsas_perprotitlehr");
        formIdMap.put("hrpi_pereduexp", "hsas_pereduexp");
    }
}

