/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.common.dto;

import java.util.Date;
import java.util.Optional;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class DateTimeRangeEntity
implements Comparable<DateTimeRangeEntity> {
    private Date startDate;
    private Date endDate;

    private DateTimeRangeEntity() {
    }

    public DateTimeRangeEntity(Date startDate, Date endDate) {
        if (SWCDateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) {
            throw new IllegalArgumentException("init DateTimeRangeEntity error: endDate cannot before startDate\u3002");
        }
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean isCovered(DateTimeRangeEntity subDateRange) {
        return !this.startDate.after(subDateRange.getStartDate()) && !this.endDate.before(subDateRange.getEndDate());
    }

    public boolean isCovered(Date date) {
        return !date.before(this.startDate) && !date.after(this.endDate);
    }

    public Optional<DateTimeRangeEntity> plus(DateTimeRangeEntity target) {
        if (this.isIntersect(target)) {
            return Optional.of(new DateTimeRangeEntity(this.min(this.startDate, target.getStartDate()), this.max(this.endDate, target.getEndDate())));
        }
        return Optional.empty();
    }

    public boolean isIntersect(DateTimeRangeEntity target) {
        return !this.getStartDate().after(target.getEndDate()) && !this.getEndDate().before(target.getStartDate());
    }

    private Date min(Date first, Date second) {
        return first.before(second) ? first : second;
    }

    private Date max(Date first, Date second) {
        return first.after(second) ? first : second;
    }

    public String toString() {
        return "dateRange = \u3010" + SWCDateTimeUtils.format((Date)this.getStartDate()) + " -> " + SWCDateTimeUtils.format((Date)this.getEndDate()) + "\u3011";
    }

    @Override
    public int compareTo(DateTimeRangeEntity target) {
        int startValue = this.startDate.compareTo(target.getStartDate());
        if (startValue != 0) {
            return startValue;
        }
        return this.endDate.compareTo(target.getEndDate());
    }
}

