/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.common.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.common.dto.DateTimeRangeEntity;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.time.DateUtils;

public class MultiDateTimeRangeEntity {
    private List<DateTimeRangeEntity> rangeEntities = new ArrayList<DateTimeRangeEntity>(10);

    public MultiDateTimeRangeEntity() {
    }

    public MultiDateTimeRangeEntity(List<DateTimeRangeEntity> rangeEntities) {
        if (rangeEntities == null) {
            this.rangeEntities = new ArrayList<DateTimeRangeEntity>(10);
            return;
        }
        this.rangeEntities = rangeEntities;
    }

    public MultiDateTimeRangeEntity add(DateTimeRangeEntity data) {
        this.rangeEntities.add(data);
        return this;
    }

    public MultiDateTimeRangeEntity add(Date startDate, Date endDate) {
        this.rangeEntities.add(new DateTimeRangeEntity(startDate, endDate));
        return this;
    }

    public List<DateTimeRangeEntity> getRangeEntities() {
        return this.rangeEntities;
    }

    public boolean isCovered(MultiDateTimeRangeEntity subDateRange) {
        for (DateTimeRangeEntity rangeEntity : subDateRange.rangeEntities) {
            boolean isCover = false;
            for (DateTimeRangeEntity entity : this.rangeEntities) {
                if (!entity.isCovered(rangeEntity)) continue;
                isCover = true;
                break;
            }
            if (isCover) continue;
            return false;
        }
        return true;
    }

    public boolean isCovered(DateTimeRangeEntity subDateRange) {
        return this.isCovered(new MultiDateTimeRangeEntity().add(subDateRange));
    }

    public boolean isCovered(Date date) {
        for (DateTimeRangeEntity rangeEntity : this.rangeEntities) {
            if (!rangeEntity.isCovered(date)) continue;
            return true;
        }
        return false;
    }

    public MultiDateTimeRangeEntity plus(MultiDateTimeRangeEntity target) {
        return this.plus(target, false);
    }

    public MultiDateTimeRangeEntity plus(DateTimeRangeEntity target) {
        return this.plus(new MultiDateTimeRangeEntity().add(target), false);
    }

    public MultiDateTimeRangeEntity plus(Date startDate, Date endDate) {
        return this.plus(new DateTimeRangeEntity(startDate, endDate));
    }

    public MultiDateTimeRangeEntity plus(MultiDateTimeRangeEntity target, boolean isMergeAdjacent) {
        ArrayList<DateTimeRangeEntity> tempData = new ArrayList<DateTimeRangeEntity>(10);
        tempData.addAll(this.rangeEntities);
        if (target != null) {
            tempData.addAll(target.getRangeEntities());
        }
        tempData.sort(DateTimeRangeEntity::compareTo);
        ArrayList<DateTimeRangeEntity> result = new ArrayList<DateTimeRangeEntity>(10);
        DateTimeRangeEntity preDateTimeRange = (DateTimeRangeEntity)tempData.get(0);
        for (int point = 1; point < tempData.size(); ++point) {
            DateTimeRangeEntity tempDateRange = (DateTimeRangeEntity)tempData.get(point);
            Optional<DateTimeRangeEntity> plus = preDateTimeRange.plus(tempDateRange);
            if (plus.isPresent()) {
                preDateTimeRange = plus.get();
                continue;
            }
            if (isMergeAdjacent && DateUtils.isSameDay((Date)DateUtils.addDays((Date)preDateTimeRange.getEndDate(), (int)1), (Date)tempDateRange.getStartDate())) {
                preDateTimeRange = new DateTimeRangeEntity(preDateTimeRange.getStartDate(), tempDateRange.getEndDate());
                continue;
            }
            result.add(preDateTimeRange);
            preDateTimeRange = tempDateRange;
        }
        result.add(preDateTimeRange);
        return new MultiDateTimeRangeEntity(result);
    }

    public MultiDateTimeRangeEntity mergeAdjacent() {
        return this.plus(null, true);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean isIntersect() {
        if (CollectionUtils.isEmpty(this.rangeEntities) || this.rangeEntities.size() == 1) {
            return false;
        }
        ArrayList<DateTimeRangeEntity> tempData = new ArrayList<DateTimeRangeEntity>(10);
        tempData.addAll(this.rangeEntities);
        tempData.sort(DateTimeRangeEntity::compareTo);
        for (int i = 1; i < tempData.size(); ++i) {
            if (!((DateTimeRangeEntity)tempData.get(i - 1)).isIntersect((DateTimeRangeEntity)tempData.get(i))) continue;
            return true;
        }
        return false;
    }
}

