/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.entity;

import com.google.common.collect.Maps;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kd.swc.hsas.report.entity.SalaryDiffGroup;
import kd.swc.hsas.report.entity.SalaryDiffGroupMatcher;

public class SalaryDiffGroupPreOrderMatcher
extends SalaryDiffGroupMatcher {
    private boolean batchByAsync;

    public SalaryDiffGroupPreOrderMatcher() {
    }

    public SalaryDiffGroupPreOrderMatcher(int groupBatchSize) {
        super(groupBatchSize);
    }

    @Override
    public String addByBatchOrderBy(Map<String, String> orderByFieldMap, List<String> relateFields) {
        super.addByBatchOrderBy(orderByFieldMap, relateFields);
        StringBuilder query = new StringBuilder();
        Map<String, Boolean> dimOrder = this.getDimOrder();
        for (Map.Entry<String, Boolean> entry : dimOrder.entrySet()) {
            query.append(entry.getKey()).append(' ').append(entry.getValue() != false ? "DESC" : "ASC").append(',');
        }
        query.deleteCharAt(query.length() - 1);
        return query.toString();
    }

    @Override
    protected boolean isNeedNewBatch(Map<String, SalaryDiffGroup> diffGroupMap) {
        return diffGroupMap.size() > this.getGroupBatchSize() || this.getDetailSize() > this.getDetailBatchSize();
    }

    @Override
    public Map<String, SalaryDiffGroup> newGroupBatchMap() {
        return Maps.newLinkedHashMapWithExpectedSize((int)this.getGroupBatchSize());
    }

    @Override
    public Comparator<Map.Entry<String, SalaryDiffGroup>> comparator() {
        return (grp1, grp2) -> 0;
    }

    @Override
    public boolean isBatchByAsync() {
        return this.batchByAsync;
    }

    public void setBatchByAsync(boolean batchByAsync) {
        this.batchByAsync = batchByAsync;
    }
}

