/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.helper;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.HashJoinDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsas.report.helper.SalaryRptAlgoHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class CalPersonQueryHelper {
    public DataSet buildDetailDataSet(String queryEntityCode, List<Long> ids, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, String> dataTypeMap, Map<Long, List<Long>> statisticsTagRelMap) {
        return this.buildDetailDataSet(queryEntityCode, ids, null, calPersonFields, itemMap, dataTypeMap, statisticsTagRelMap);
    }

    public DataSet buildDetailDataSet(String queryEntityCode, List<Long> ids, Collection<Long> taskIds, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, String> dataTypeMap, Map<Long, List<Long>> statisticsTagRelMap) {
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryEntityCode);
        ArrayList<Object> pkList = new ArrayList<Object>(ids);
        return this.buildDetailDataSet(queryEntityType, pkList, taskIds, calPersonFields, itemMap, dataTypeMap, statisticsTagRelMap);
    }

    public DataSet buildDetailDataSet(QueryEntityType queryEntityType, List<Object> pkList, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, String> dataTypeMap, Map<Long, List<Long>> statisticsTagRelMap) {
        return this.buildDetailDataSet(queryEntityType, pkList, null, calPersonFields, itemMap, dataTypeMap, statisticsTagRelMap);
    }

    public DataSet buildDetailDataSet(QueryEntityType queryEntityType, List<Object> pkList, Collection<Long> taskIds, List<String> calPersonFields, Map<String, List<Long>> itemMap, Map<String, String> dataTypeMap, Map<Long, List<Long>> statisticsTagRelMap) {
        String selectProperties = String.join((CharSequence)",", calPersonFields);
        QFilter qFilter = new QFilter("id", "in", pkList);
        DataSet dataSet = HRQueryEntityHelper.getInstance().getQueryDataSet(queryEntityType, selectProperties, new QFilter[]{qFilter}, "");
        if (dataSet == null) {
            return null;
        }
        if (itemMap == null || itemMap.size() == 0) {
            return dataSet;
        }
        DataSet resultDataSet = null;
        HashJoinDataSet hashJoinDataSet = null;
        DataSet entryDataSet = null;
        for (Map.Entry<String, List<Long>> itemEntry : itemMap.entrySet()) {
            if (SalaryRptItemTypeEnum.ITEMTAG.getCode().equals(itemEntry.getKey())) continue;
            entryDataSet = this.buildEntryData(itemEntry.getKey(), itemEntry.getValue(), pkList, taskIds, dataTypeMap);
            Object[] fieldNames = entryDataSet.getRowMeta().getFieldNames();
            fieldNames = (String[])ArrayUtils.remove((Object[])fieldNames, (int)0);
            if (hashJoinDataSet == null) {
                hashJoinDataSet = dataSet.hashJoin(entryDataSet.toHashTable("calpersonid"), "id", (String[])fieldNames, true);
                continue;
            }
            hashJoinDataSet = hashJoinDataSet.addHashTable(entryDataSet.toHashTable("calpersonid"), "id", (String[])fieldNames, true);
        }
        resultDataSet = hashJoinDataSet != null ? hashJoinDataSet.selectLeftFields(dataSet.getRowMeta().getFieldNames()).finish() : dataSet;
        return this.addTagField(resultDataSet, statisticsTagRelMap, itemMap.get(SalaryRptItemTypeEnum.ITEMTAG.getCode()));
    }

    private DataSet addTagField(DataSet resultDataSet, Map<Long, List<Long>> statisticsTagRelMap, List<Long> tagIdList) {
        if (tagIdList == null) {
            return resultDataSet;
        }
        if (statisticsTagRelMap == null) {
            statisticsTagRelMap = new HashMap<Long, List<Long>>(0);
        }
        ArrayList<String> exprList = new ArrayList<String>(10);
        ArrayList<String> fieldList = new ArrayList<String>(10);
        List<Long> itemIdList = null;
        for (Long tagId : tagIdList) {
            itemIdList = statisticsTagRelMap.get(tagId);
            if (SWCListUtils.isEmpty(itemIdList)) {
                exprList.add("null");
                fieldList.add(SalaryRptItemTypeEnum.ITEMTAG.getCode() + "_" + tagId);
                continue;
            }
            StringBuilder exprise = new StringBuilder();
            for (Long itemId : itemIdList) {
                exprise.append(SalaryRptItemTypeEnum.ITEM.getCode()).append('_').append(itemId).append(' ').append('+').append(' ');
            }
            exprList.add(exprise.substring(0, exprise.length() - 2));
            fieldList.add(SalaryRptItemTypeEnum.ITEMTAG.getCode() + "_" + tagId);
        }
        String[] exprArr = new String[exprList.size()];
        String[] fieldArr = new String[fieldList.size()];
        exprList.toArray(exprArr);
        fieldList.toArray(fieldArr);
        return resultDataSet.addFields(exprArr, fieldArr);
    }

    private DataSet buildEntryData(String itemKey, List<Long> itemIds, List<Object> pkList, Collection<Long> taskIds, Map<String, String> dataTypeMap) {
        SalaryRptItemTypeEnum itemEnum = SalaryRptItemTypeEnum.getEnumByCode((String)itemKey);
        QFilter entryFilter = new QFilter(itemEnum.getWholeItemFieldCode(), "in", itemIds);
        QFilter calPersonFilter = new QFilter("calpersonid", "in", pkList);
        if (!CollectionUtils.isEmpty(taskIds)) {
            calPersonFilter = calPersonFilter.and(new QFilter("caltask.id", "in", taskIds));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_caltable");
        DataSet dataSet = helper.queryDataSet("QueryServiceHelper.hsas_caltable", itemEnum.getSelectProperties(), new QFilter[]{calPersonFilter, entryFilter});
        return this.transferEntry(itemEnum, dataSet, itemIds, dataTypeMap);
    }

    private DataSet transferEntry(SalaryRptItemTypeEnum itemEnum, DataSet dataSet, List<Long> itemIds, Map<String, String> dataTypeMap) {
        RowMeta rowMeta = this.buildEntryRowMeta(itemEnum, itemIds, dataTypeMap);
        Collection<Object[]> coll = this.buildEntryDataColl(itemEnum, dataSet, itemIds, dataTypeMap, rowMeta);
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        DataSet resultDataSet = Algo.create((String)this.getClass().getName()).createDataSet(new Input[]{inputs});
        return resultDataSet;
    }

    private RowMeta buildEntryRowMeta(SalaryRptItemTypeEnum itemEnum, List<Long> itemIds, Map<String, String> dataTypeMap) {
        ArrayList columnKeys = Lists.newArrayListWithCapacity((int)itemIds.size());
        ArrayList columnTypes = Lists.newArrayListWithCapacity((int)itemIds.size());
        columnKeys.add("calpersonid");
        columnTypes.add(DataType.LongType);
        for (Long salaryItemId : itemIds) {
            String columnKey = itemEnum.getCode() + "_" + salaryItemId;
            columnKeys.add(columnKey);
            DataType dataType = SalaryRptAlgoHelper.getAlgoDataType(dataTypeMap.get(columnKey));
            columnTypes.add(dataType);
        }
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])columnKeys.toArray(new String[0]), (DataType[])columnTypes.toArray(new DataType[0]));
        return rowMeta;
    }

    private Collection<Object[]> buildEntryDataColl(SalaryRptItemTypeEnum itemEnum, DataSet dataSet, List<Long> itemIds, Map<String, String> dataTypeMap, RowMeta rowMeta) {
        ArrayList coll = Lists.newArrayListWithCapacity((int)10);
        HashMap map = new HashMap(16);
        HashMap<Long, Map> allProrationIndexMap = new HashMap<Long, Map>(16);
        for (Row tmpRow : dataSet) {
            HashMap<String, Object> rowMap = null;
            Long tmpRowId = tmpRow.getLong("calpersonid");
            String salaryItemId = tmpRow.getString(itemEnum.getWholeItemFieldCode());
            String columnKey = itemEnum.getCode() + "_" + salaryItemId;
            if (SalaryRptItemTypeEnum.ITEM == itemEnum) {
                if (tmpRow.getInteger(itemEnum.getWholeProrationIndexCode()) != 0) {
                    continue;
                }
            } else if (SalaryRptItemTypeEnum.ITEMBC == itemEnum || SalaryRptItemTypeEnum.ITEMBS == itemEnum) {
                Map prorationIndexMap = allProrationIndexMap.computeIfAbsent(tmpRowId, key -> new HashMap(16));
                Integer usedProrationIndex = (Integer)prorationIndexMap.get(columnKey);
                if (usedProrationIndex != null && usedProrationIndex > tmpRow.getInteger(itemEnum.getWholeProrationIndexCode())) continue;
                prorationIndexMap.put(columnKey, tmpRow.getInteger(itemEnum.getWholeProrationIndexCode()));
            }
            if (map.get(tmpRowId) != null) {
                rowMap = (HashMap<String, Object>)map.get(tmpRowId);
            } else {
                rowMap = new HashMap<String, Object>(16);
                map.put(tmpRowId, rowMap);
            }
            rowMap.put(columnKey, tmpRow.get(itemEnum.getWholeValueFieldCode(dataTypeMap.get(columnKey))));
        }
        for (Map.Entry rowEntry : map.entrySet()) {
            Long calPersonId = (Long)rowEntry.getKey();
            Map dataMap = (Map)rowEntry.getValue();
            Object[] obj = new Object[rowMeta.getFieldCount()];
            obj[0] = calPersonId;
            int index = 1;
            for (Long salaryItemId : itemIds) {
                String columnKey = itemEnum.getCode() + "_" + salaryItemId;
                String dataType = dataTypeMap.get(columnKey);
                obj[index] = StringUtils.equals((CharSequence)dataType, (CharSequence)"amount") || StringUtils.equals((CharSequence)dataType, (CharSequence)"integer") || StringUtils.equals((CharSequence)dataType, (CharSequence)"decimal") ? (dataMap.get(columnKey) != null ? dataMap.get(columnKey) : BigDecimal.ZERO) : dataMap.get(columnKey);
                ++index;
            }
            coll.add(obj);
        }
        return coll;
    }
}

