/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.sdk.swc.hsas.common.events.salaryrpt.BuildRptDataRuleFilterEvent;
import kd.sdk.swc.hsas.common.events.salaryrpt.SalaryRptQueryParamEvent;
import kd.sdk.swc.hsas.formplugin.extpoint.salaryrpt.ISalaryDptMonthSumQueryExtPlugin;
import kd.sdk.swc.hsas.formplugin.extpoint.salaryrpt.ISalaryRptQueryExtPlugin;
import kd.swc.hsas.report.entity.SalaryRptColumnInfo;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.helper.SalaryRptHelper;
import kd.swc.hsas.report.helper.SalaryRptQueryParamHelper;
import kd.swc.hsas.report.impl.SalarySchemeRptParamHandler;
import kd.swc.hsas.report.web.SalaryDptMonthSumQueryExtPlugin;
import kd.swc.hsas.report.web.SalaryRptQueryExtPlugin;
import kd.swc.hsbp.business.report.AdminOrgHelper;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SalaryDptMonthSumRptParamHandler
extends SalarySchemeRptParamHandler {
    @Override
    protected List<QFilter> buildDataRuleFilter(FilterInfo filterInfo, SalaryRptQueryInfo salaryQueryInfo, List<QFilter> pageInfoFilters) {
        List<QFilter> filters = super.buildDataRuleFilter(filterInfo, salaryQueryInfo, pageInfoFilters);
        BuildRptDataRuleFilterEvent paramEvent = new BuildRptDataRuleFilterEvent(filterInfo, filters, pageInfoFilters, salaryQueryInfo.getPermEntityCode());
        SalaryDptMonthSumQueryExtPlugin rptQueryExtPlugin = new SalaryDptMonthSumQueryExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)rptQueryExtPlugin, ISalaryRptQueryExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.salaryrpt.ISalaryDptMonthSumQueryExtPlugin#buildDataRuleFilter", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.buildDataRuleFilter(paramEvent);
            return null;
        });
        if (paramEvent.getResultDataRuleFilters() == null || paramEvent.getResultDataRuleFilters().isEmpty()) {
            return filters;
        }
        return paramEvent.getResultDataRuleFilters();
    }

    @Override
    protected void addExtFilter(ReportQueryParam queryParam, List<QFilter> filters) {
        SalaryRptQueryParamEvent paramEvent = new SalaryRptQueryParamEvent(queryParam, filters);
        SalaryRptQueryExtPlugin rptQueryExtPlugin = new SalaryRptQueryExtPlugin();
        HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)rptQueryExtPlugin, ISalaryDptMonthSumQueryExtPlugin.class, (String)"kd.sdk.swc.hsas.formplugin.extpoint.salaryrpt.ISalaryDptMonthSumQueryExtPlugin#addExtFilter", null);
        hrPluginProxy.callReplaceIfPresent(proxy -> {
            proxy.addExtFilter(paramEvent);
            return null;
        });
    }

    @Override
    protected List<QFilter> parseFilters(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        List<QFilter> filters = super.parseFilters(filterInfo, salRptQueryInfo);
        QFilter timeFilter = SalaryRptQueryParamHelper.buildPeriodFilter(filterInfo);
        if (timeFilter != null) {
            filters.add(timeFilter);
        }
        String countStructure = filterInfo.getString("countstructure");
        long adminOrgId = 0L;
        String filterFieldCode = "";
        switch (countStructure) {
            case "1": {
                adminOrgId = filterInfo.getLong("adminorg");
                filterFieldCode = "hsas_empposorgrelhr.adminorg";
                break;
            }
            case "2": {
                adminOrgId = filterInfo.getLong("attachadminorg");
                filterFieldCode = "adminorg";
                break;
            }
        }
        salRptQueryInfo.getCustomParaMap().put("adminOrgId", adminOrgId);
        salRptQueryInfo.getCustomParaMap().put("countStructure", countStructure);
        salRptQueryInfo.getCustomParaMap().put("filterFieldCode", filterFieldCode);
        return filters;
    }

    @Override
    protected List<SalaryRptColumnInfo> buildColumnInfoList(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        ArrayList<SalaryRptColumnInfo> columnInfos = new ArrayList<SalaryRptColumnInfo>(10);
        String seqCaption = ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"SalarySumRptParamHandler_0", (String)"swc-hsas-report", (Object[])new Object[0]);
        SalaryRptColumnInfo seqCol = new SalaryRptColumnInfo("seq", seqCaption, 60, "text", false, false, true);
        columnInfos.add(seqCol);
        long adminOrgId = salRptQueryInfo.getCustomPara("adminOrgId", Long.TYPE);
        String countStructure = salRptQueryInfo.getCustomPara("countStructure", String.class);
        Map deptInfo = AdminOrgHelper.getAdminOrgDataMap((Long)adminOrgId);
        String longNumber = MapUtils.getString((Map)deptInfo, (Object)"longnumber");
        Integer deptLevel = AdminOrgHelper.getAdminOrgLevel((String)longNumber);
        Integer lastLevel = filterInfo.getInt("lastlevel");
        ArrayList<String> orgFieldList = new ArrayList<String>(10);
        for (int i = deptLevel.intValue(); i <= lastLevel; ++i) {
            String fieldKey = "org_" + i;
            String orgNameCaption = SalaryRptHelper.getDeptNameKDString(fieldKey);
            SalaryRptColumnInfo orgNameCol = new SalaryRptColumnInfo(fieldKey, orgNameCaption, 200, "text", false, false, i < 10);
            columnInfos.add(orgNameCol);
            orgFieldList.add(fieldKey);
        }
        salRptQueryInfo.getCustomParaMap().put("adminOrgFieldArr", orgFieldList.toArray(new String[0]));
        salRptQueryInfo.getCustomParaMap().put("adminOrgLongNumber", longNumber);
        salRptQueryInfo.getCustomParaMap().put("adminOrgLevel", deptLevel);
        String orgNumberCaption = SalaryRptHelper.getDeptNumberKDString();
        SalaryRptColumnInfo orgNumberCol = new SalaryRptColumnInfo("adminorg.number", orgNumberCaption, 120, "text", false, false, lastLevel < 10);
        columnInfos.add(orgNumberCol);
        SalaryRptColumnInfo orgIdCol = new SalaryRptColumnInfo("adminorg.id", "adminorg.id", 120, "bigint", true, true, false);
        if (StringUtils.equals((CharSequence)countStructure, (CharSequence)"1")) {
            orgIdCol.setDbFieldCode("hsas_empposorgrelhr.adminorg.id");
        }
        orgIdCol.setGroupBy(true);
        orgIdCol.setBuildColumn(false);
        columnInfos.add(orgIdCol);
        SalaryRptColumnInfo orgLongNumberCol = new SalaryRptColumnInfo("structlongnumber", "structlongnumber", 120, "text", false, true, false);
        columnInfos.add(orgLongNumberCol);
        String periodCaption = SalaryRptHelper.getPeriodKDString();
        SalaryRptColumnInfo periodCol = new SalaryRptColumnInfo("belongperiod", periodCaption, 100, "text", true, true, false);
        periodCol.setBuildColumn(false);
        columnInfos.add(periodCol);
        String periodStrCaption = SalaryRptHelper.getPeriodKDString();
        SalaryRptColumnInfo periodStrCol = new SalaryRptColumnInfo("periodstr", periodStrCaption, 100, "text", false, false, lastLevel < 9);
        periodStrCol.setGroupBy(true);
        columnInfos.add(periodStrCol);
        String personNumCaption = SalaryRptHelper.getPeopleCountKDString();
        SalaryRptColumnInfo personNumCol = new SalaryRptColumnInfo("personnum", personNumCaption, 120, "integer", false, false, lastLevel < 8);
        personNumCol.setTip(ResManager.loadKDString((String)"\u5728\u672c\u6c47\u603b\u884c\u6570\u636e\u4e2d\u5305\u542b\u7684\u8ba1\u85aa\u4eba\u5458\u6570\u91cf\uff08\u6839\u636e\u5de5\u53f7\u53bb\u91cd\uff09\u3002", (String)"SalaryDptMonthSumRptParamHandler_0", (String)"swc-hsas-report", (Object[])new Object[0]));
        columnInfos.add(personNumCol);
        List<SalaryRptColumnInfo> salaryRptColumnInfos = super.buildColumnInfoList(filterInfo, salRptQueryInfo);
        columnInfos.addAll(salaryRptColumnInfos);
        return columnInfos;
    }
}

