/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryrpt.RptQueryEntityHelper;
import kd.swc.hsas.business.salaryrpt.SalaryRptDateLogger;
import kd.swc.hsas.business.salaryrpt.SalaryRptItemService;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsas.report.api.SalaryRptParamHandler;
import kd.swc.hsas.report.entity.SalaryRptAmountFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptColumnInfo;
import kd.swc.hsas.report.entity.SalaryRptComboFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptDecimalFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.helper.SalaryRptAlgoHelper;
import kd.swc.hsas.report.helper.SalaryRptHelper;
import kd.swc.hsas.report.helper.SalaryRptQueryParamHelper;
import kd.swc.hsbp.business.report.RptShowNodeVo;
import kd.swc.hsbp.business.report.RptTypeVo;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class SalaryRptParamBaseHandler
implements SalaryRptParamHandler {
    private static final Log LOGGER = LogFactory.getLog(SalaryRptParamBaseHandler.class);
    private SalaryRptDateLogger timeLog = new SalaryRptDateLogger(LOGGER);

    protected SalaryRptQueryInfo initSalaryReportQueryInfo(ReportQueryParam queryParam) {
        String pageId = (String)queryParam.getCustomParam().get("pageid");
        String formId = (String)queryParam.getCustomParam().get("formid");
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            throw new KDBizException("SalaryDetailQueryRpt initSalaryReportQueryInfo : pageId can not null.");
        }
        if (StringUtils.isEmpty((CharSequence)formId)) {
            throw new KDBizException("SalaryDetailQueryRpt initSalaryReportQueryInfo : formId can not null.");
        }
        RptTypeVo rptTypeVo = SalaryRptService.getRptTypeVo((String)pageId, (String)formId);
        SalaryRptQueryInfo salaryRptQueryInfo = new SalaryRptQueryInfo();
        salaryRptQueryInfo.setPageId(pageId);
        salaryRptQueryInfo.setReportEntityCode(formId);
        salaryRptQueryInfo.setPermEntityCode(rptTypeVo.getPermEntityNum());
        salaryRptQueryInfo.setQueryEntityCode(rptTypeVo.getQueryEntityNum());
        salaryRptQueryInfo.setCustomParaMap(queryParam.getCustomParam());
        salaryRptQueryInfo.setQueryTraceId((String)queryParam.getCustomParam().get("queryTraceId"));
        return salaryRptQueryInfo;
    }

    protected abstract List<SalaryRptColumnInfo> buildColumnInfoList(FilterInfo var1, SalaryRptQueryInfo var2);

    @Override
    public SalaryRptQueryInfo handleRptQueryParam(ReportQueryParam queryParam) {
        this.timeLog.logStart("SalaryRptParamBaseHandler handleRptQueryParam");
        SalaryRptQueryInfo salRptQueryInfo = this.initSalaryReportQueryInfo(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        this.buildFilters(filterInfo, salRptQueryInfo);
        this.addExtFilter(queryParam, salRptQueryInfo.getFilters());
        this.setShowConfig(filterInfo, salRptQueryInfo);
        this.setColumnInfoList(filterInfo, salRptQueryInfo);
        this.afterSetColumnInfoList(salRptQueryInfo);
        this.timeLog.logEnd("SalaryRptParamBaseHandler handleRptQueryParam");
        LOGGER.info("[salrpt] SalaryRptParamBaseHandler handleRptQueryParam Filters:{}", salRptQueryInfo.getFilters());
        return salRptQueryInfo;
    }

    protected void addExtFilter(ReportQueryParam queryParam, List<QFilter> filters) {
    }

    protected void setColumnInfoList(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        List<SalaryRptColumnInfo> columnInfoList = this.buildColumnInfoList(filterInfo, salRptQueryInfo);
        this.addCustomColumnInfos(columnInfoList);
        this.setItemTypeToIdMap(salRptQueryInfo, columnInfoList);
        this.supplementColumnOtherInfo(salRptQueryInfo, columnInfoList);
        salRptQueryInfo.setSalaryRptColumnInfoList(columnInfoList);
    }

    protected void setShowConfig(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        salRptQueryInfo.setSumTypeSign(filterInfo.getString("sumtypesign"));
        salRptQueryInfo.setShowTotal(filterInfo.getBoolean("isshowtotal"));
        salRptQueryInfo.setShowZeroCol(filterInfo.getBoolean("isshowzero"));
        salRptQueryInfo.setShowNullCol(filterInfo.getBoolean("isshownull"));
    }

    private void buildFilters(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        List<QFilter> filters;
        String openWay = filterInfo.getString("openway");
        if (openWay == null) {
            openWay = "1";
        }
        switch (openWay) {
            case "1": {
                List<QFilter> dataRuleQFilter;
                filters = this.parseFilters(filterInfo, salRptQueryInfo);
                QFilter moreFilters = this.parseMoreFilters(filterInfo, salRptQueryInfo);
                if (moreFilters != null) {
                    filters.add(moreFilters);
                    salRptQueryInfo.setMoreFilter(moreFilters);
                }
                if (CollectionUtils.isEmpty(dataRuleQFilter = this.buildDataRuleFilter(filterInfo, salRptQueryInfo, filters))) break;
                filters.addAll(dataRuleQFilter);
                break;
            }
            default: {
                filters = filterInfo.getQFilters();
            }
        }
        salRptQueryInfo.setOpenWay(openWay);
        salRptQueryInfo.setFilters(filters);
    }

    protected List<QFilter> buildDataRuleFilter(FilterInfo filterInfo, SalaryRptQueryInfo salaryQueryInfo, List<QFilter> pageInfoFilters) {
        List dataRuleQFilter;
        ArrayList filters = Lists.newArrayListWithCapacity((int)10);
        QFilter orgFilter = SalaryRptQueryParamHelper.buildOrgFilter(filterInfo, salaryQueryInfo.getPermEntityCode());
        if (orgFilter != null) {
            filters.add(orgFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)(dataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHMBBGZQ65X", (String)salaryQueryInfo.getPermEntityCode(), (String)"47150e89000000ac")))) {
            dataRuleQFilter.stream().filter(obj -> !StringUtils.equals((CharSequence)obj.getProperty(), (CharSequence)"1")).forEach(filters::add);
        }
        return filters;
    }

    protected List<QFilter> parseFilters(FilterInfo filterInfo, SalaryRptQueryInfo salaryQueryInfo) {
        QFilter onholdStatusFilter;
        QFilter calStatusFilter;
        QFilter currencyFilter;
        QFilter laborRelTypeFilter;
        QFilter empGroupFilter;
        QFilter payRollSceneFilter;
        ArrayList filters = Lists.newArrayListWithCapacity((int)10);
        boolean isSuperUser = SWCPermissionServiceHelper.isSuperUser();
        salaryQueryInfo.addCustomPara("isSuperUser", isSuperUser);
        QFilter payRollGroupFilter = SalaryRptQueryParamHelper.buildBaseDataIdFilter(filterInfo, "payrollgroup", "hsas_calpayrolltask.payrollgroup");
        if (payRollGroupFilter != null) {
            filters.add(payRollGroupFilter);
        }
        if ((payRollSceneFilter = SalaryRptQueryParamHelper.buildBaseDataIdFilter(filterInfo, "payrollscene", "hsas_calpayrolltask.payrollscene")) != null) {
            filters.add(payRollSceneFilter);
        }
        if ((empGroupFilter = SalaryRptQueryParamHelper.buildBaseDataIdFilter(filterInfo, "empgroup", "empgroup")) != null) {
            filters.add(empGroupFilter);
        }
        if ((laborRelTypeFilter = SalaryRptQueryParamHelper.buildLaborRelTypeFilter(filterInfo)) != null) {
            filters.add(laborRelTypeFilter);
        }
        if ((currencyFilter = SalaryRptQueryParamHelper.buildCurrencyFilter(filterInfo)) != null) {
            filters.add(currencyFilter);
        }
        if ((calStatusFilter = SalaryRptQueryParamHelper.buildCalStatusFilter(filterInfo)) != null) {
            filters.add(calStatusFilter);
        }
        if ((onholdStatusFilter = SalaryRptQueryParamHelper.buildOnholdStatusFilter(filterInfo)) != null) {
            filters.add(onholdStatusFilter);
        }
        return filters;
    }

    protected QFilter parseMoreFilters(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        return (QFilter)filterInfo.getCommFilter().get(salRptQueryInfo.getQueryEntityCode());
    }

    protected List<SalaryRptColumnInfo> addCustomColumnInfos(List<SalaryRptColumnInfo> columnInfos) {
        SalaryRptColumnInfo currencyCol = new SalaryRptColumnInfo("hsas_calpayrolltask.payrollgroupv.currency", SalaryRptHelper.getCurrencyLocal().toString(), 120, "currency", true, true);
        currencyCol.setGroupBy(true);
        columnInfos.add(currencyCol);
        SalaryRptColumnInfo rowTypeCol = new SalaryRptColumnInfo("rowtype", "rowtype", 120, "text", false, true);
        columnInfos.add(rowTypeCol);
        SalaryRptColumnInfo iDCol = new SalaryRptColumnInfo("id", "id", 120, "text", true, true);
        iDCol.setBuildColumn(false);
        columnInfos.add(iDCol);
        return columnInfos;
    }

    protected void afterSetColumnInfoList(SalaryRptQueryInfo salRptQueryInfo) {
        List<SalaryRptColumnInfo> columnInfoList = salRptQueryInfo.getSalaryRptColumnInfoList();
        if (CollectionUtils.isEmpty(columnInfoList)) {
            return;
        }
        HashSet sumFieldCodes = Sets.newHashSetWithExpectedSize((int)columnInfoList.size());
        ArrayList<String> fieldNameList = new ArrayList<String>(columnInfoList.size());
        ArrayList<DataType> algoDataTypeList = new ArrayList<DataType>(columnInfoList.size());
        HashMap dataTypeMap = Maps.newHashMapWithExpectedSize((int)columnInfoList.size());
        ArrayList mainSelectFields = Lists.newArrayListWithCapacity((int)10);
        String[] orderByFieldArry = new String[5];
        ArrayList groupByFields = Lists.newArrayListWithCapacity((int)10);
        ArrayList relateFields = Lists.newArrayListWithCapacity((int)10);
        for (int i = 0; i < columnInfoList.size(); ++i) {
            String orderField;
            SalaryRptColumnInfo columnInfo = columnInfoList.get(i);
            String dataType = columnInfo.getDataType();
            String fieldCode = columnInfo.getFieldCode();
            String dbFieldCode = columnInfo.getDbFieldCode();
            if (columnInfo.isBuildColumn()) {
                fieldNameList.add(fieldCode);
                algoDataTypeList.add(SalaryRptAlgoHelper.getAlgoDataType(dataType));
                dataTypeMap.put(fieldCode, dataType);
            }
            if (columnInfo.isItem()) {
                if (dataType.equals("amount") || dataType.equals("decimal") || dataType.equals("integer")) {
                    sumFieldCodes.add(fieldCode);
                }
            } else if (columnInfo.isQuery()) {
                if (!StringUtils.isEmpty((CharSequence)dbFieldCode)) {
                    mainSelectFields.add(dbFieldCode);
                } else {
                    mainSelectFields.add(fieldCode);
                }
            }
            if (columnInfo.isGroupBy()) {
                groupByFields.add(fieldCode);
            } else if (columnInfo.isRelate()) {
                relateFields.add(fieldCode);
            }
            int sort = columnInfo.getSort();
            if (sort <= 0) continue;
            orderByFieldArry[sort - 1] = orderField = fieldCode + "&" + columnInfo.getSortType();
        }
        LinkedHashMap orderByFieldMap = Maps.newLinkedHashMapWithExpectedSize((int)orderByFieldArry.length);
        Arrays.stream(orderByFieldArry).filter(obj -> !StringUtils.isEmpty((CharSequence)obj)).forEach(obj -> orderByFieldMap.put(obj.substring(0, obj.indexOf(38)), obj.substring(obj.indexOf(38) + 1)));
        salRptQueryInfo.setOrderByFieldMap(this.addCustomOrderByField(salRptQueryInfo, orderByFieldMap));
        salRptQueryInfo.setSumFieldCodes(sumFieldCodes);
        salRptQueryInfo.setRowMeta(new RowMeta(fieldNameList.toArray(new String[0]), algoDataTypeList.toArray(new DataType[0])));
        if (salRptQueryInfo.getDataTypeMap() == null) {
            salRptQueryInfo.setDataTypeMap(dataTypeMap);
        } else {
            salRptQueryInfo.getDataTypeMap().putAll(dataTypeMap);
        }
        salRptQueryInfo.setMainSelectFields(mainSelectFields);
        salRptQueryInfo.setGroupByFields(groupByFields);
        salRptQueryInfo.setRelateFields(relateFields);
    }

    protected Map<String, String> addCustomOrderByField(SalaryRptQueryInfo salRptQueryInfo, Map<String, String> orderByFieldMap) {
        return orderByFieldMap;
    }

    protected void supplementColumnOtherInfo(SalaryRptQueryInfo queryInfo, List<SalaryRptColumnInfo> columnInfoList) {
        Map fieldPropMap = RptQueryEntityHelper.getQueryEntityDynPropMap((String)queryInfo.getQueryEntityCode());
        Map ItemTypeToItemDynMap = SalaryRptItemService.queryItemMap(queryInfo.getItemTypeToIdMap());
        SalaryRptService salaryRptService = null;
        for (SalaryRptColumnInfo columnInfo : columnInfoList) {
            DynamicProperty dynamicProperty;
            if (columnInfo.isItem()) {
                Map itemDynMap = (Map)ItemTypeToItemDynMap.get(columnInfo.getItemType());
                if (CollectionUtils.isEmpty((Map)itemDynMap)) continue;
                long itemId = columnInfo.getItemId();
                DynamicObject itemDyn = (DynamicObject)itemDynMap.get(itemId);
                if (itemDyn == null) {
                    LOGGER.info("SalaryRptParamBaseHandler supplementColumnOtherInfo itemDyn is null id = {}", (Object)itemId);
                    continue;
                }
                String name = itemDyn.getString("name");
                if (StringUtils.isEmpty((CharSequence)columnInfo.getCaption())) {
                    columnInfo.setCaption(name);
                } else {
                    List<String> parentHeaders = columnInfo.getParentHeaders();
                    if (!CollectionUtils.isEmpty(parentHeaders) && parentHeaders.remove(String.valueOf(itemId))) {
                        parentHeaders.add(name + " ");
                    }
                }
                this.initItemDataFormatInfo(columnInfo, itemDyn);
                continue;
            }
            if (StringUtils.isEmpty((CharSequence)columnInfo.getCaption())) {
                RptShowNodeVo fieldAttr;
                if (salaryRptService == null) {
                    salaryRptService = new SalaryRptService(queryInfo.getReportEntityCode());
                }
                if ((fieldAttr = salaryRptService.getFieldAliasAtt(columnInfo.getFieldCode())) != null) {
                    columnInfo.setCaption(fieldAttr.getName());
                }
            }
            if ((dynamicProperty = (DynamicProperty)fieldPropMap.get(columnInfo.getFieldCode())) == null) {
                LOGGER.info("SalaryRptParamBaseHandler supplementColumnOtherInfo fieldDyn is null fieldCode = {}", (Object)columnInfo.getFieldCode());
                continue;
            }
            if (columnInfo.isHide()) continue;
            this.initFieldDataFormatInfo(columnInfo, dynamicProperty);
        }
        Map tagMap = (Map)ItemTypeToItemDynMap.get(SalaryRptItemTypeEnum.ITEMTAG.getCode());
        this.cacheTagItemRelMap(queryInfo, tagMap);
    }

    private void initItemDataFormatInfo(SalaryRptColumnInfo columnInfo, DynamicObject itemDyn) {
        String dataType;
        SalaryRptFormatInfo dataFormatInfo = null;
        switch (dataType = columnInfo.getDataType()) {
            case "amount": {
                dataFormatInfo = new SalaryRptAmountFormatInfo(dataType);
                break;
            }
            case "decimal": {
                String scaleCode = SalaryRptItemService.getItemScaleFieldCode((String)SalaryRptItemTypeEnum.getEnumByCode((String)columnInfo.getItemType()).getEntityCode());
                if (!StringUtils.isEmpty((CharSequence)scaleCode)) {
                    dataFormatInfo = new SalaryRptDecimalFormatInfo(dataType, itemDyn.getInt(scaleCode));
                    break;
                }
                dataFormatInfo = new SalaryRptDecimalFormatInfo(dataType, 10);
                break;
            }
        }
        columnInfo.setFormatInfo(dataFormatInfo);
    }

    private void initFieldDataFormatInfo(SalaryRptColumnInfo columnInfo, DynamicProperty property) {
        String dataType;
        SalaryRptFormatInfo dataFormatInfo = null;
        if (property instanceof IntegerProp) {
            dataType = "text";
        } else if (property instanceof DecimalProp) {
            dataType = "decimal";
            dataFormatInfo = new SalaryRptDecimalFormatInfo(dataType, ((DecimalProp)property).getScale());
        } else if (property instanceof DateProp || property instanceof DateTimeProp) {
            dataType = "date";
        } else if (property instanceof ComboProp) {
            dataType = "combofield";
            dataFormatInfo = new SalaryRptComboFormatInfo(dataType, ((ComboProp)property).getComboItems());
        } else if (property instanceof BooleanProp) {
            dataType = "combofield";
            dataFormatInfo = new SalaryRptComboFormatInfo(dataType, this.buildBooleanValueMapItem());
        } else {
            dataType = "text";
        }
        columnInfo.setDataType(dataType);
        columnInfo.setFormatInfo(dataFormatInfo);
    }

    private void setItemTypeToIdMap(SalaryRptQueryInfo salRptQueryInfo, List<SalaryRptColumnInfo> columnInfoList) {
        if (CollectionUtils.isEmpty(columnInfoList)) {
            return;
        }
        Map queryItemIdsMap = null;
        String queryItemIdStr = salRptQueryInfo.getCustomPara("queryItemIds", String.class);
        if (!StringUtils.isEmpty((CharSequence)queryItemIdStr)) {
            queryItemIdsMap = (Map)SerializationUtils.deSerializeFromBase64((String)queryItemIdStr);
        }
        HashMap itemIdMap = Maps.newHashMapWithExpectedSize((int)4);
        Iterator<SalaryRptColumnInfo> iterator = columnInfoList.iterator();
        while (iterator.hasNext()) {
            SalaryRptColumnInfo columnInfo = iterator.next();
            if (!columnInfo.isItem() || !columnInfo.isQuery()) continue;
            String itemType = columnInfo.getItemType();
            long itemId = columnInfo.getItemId();
            if (queryItemIdsMap != null) {
                Set queryItemIds = (Set)queryItemIdsMap.get(SalaryRptItemTypeEnum.getEntityCodeByCode((String)itemType));
                if (!(SalaryRptItemTypeEnum.ITEMTAG.getCode().equals(itemType) || queryItemIds != null && queryItemIds.contains(itemId))) {
                    iterator.remove();
                    continue;
                }
            }
            List itemIds = itemIdMap.computeIfAbsent(columnInfo.getItemType(), key -> Lists.newArrayListWithCapacity((int)10));
            itemIds.add(columnInfo.getItemId());
        }
        salRptQueryInfo.setItemTypeToIdMap(itemIdMap);
    }

    private List<ValueMapItem> buildBooleanValueMapItem() {
        ArrayList items = Lists.newArrayListWithExpectedSize((int)4);
        LocaleString yesStr = new LocaleString(ResManager.loadKDString((String)"\u662f", (String)"SalaryRptParamBaseHandler_0", (String)"swc-hsas-report", (Object[])new Object[0]));
        ValueMapItem yesItem = new ValueMapItem();
        yesItem.setImageKey("1");
        yesItem.setValue("1");
        yesItem.setName(yesStr);
        ValueMapItem trueItem = new ValueMapItem();
        trueItem.setImageKey("true");
        trueItem.setValue("true");
        trueItem.setName(yesStr);
        LocaleString noStr = new LocaleString(ResManager.loadKDString((String)"\u5426", (String)"SalaryRptParamBaseHandler_1", (String)"swc-hsas-report", (Object[])new Object[0]));
        ValueMapItem noItem = new ValueMapItem();
        noItem.setImageKey("0");
        noItem.setValue("0");
        noItem.setName(noStr);
        ValueMapItem falseItem = new ValueMapItem();
        falseItem.setImageKey("false");
        falseItem.setValue("false");
        falseItem.setName(noStr);
        items.add(yesItem);
        items.add(trueItem);
        items.add(noItem);
        items.add(falseItem);
        return items;
    }

    private void cacheTagItemRelMap(SalaryRptQueryInfo salRptQueryInfo, Map<Long, DynamicObject> tagMap) {
        LOGGER.info("cacheTagItemRelMap start");
        Map<String, List<Long>> itemTypeToIdMap = salRptQueryInfo.getItemTypeToIdMap();
        if (itemTypeToIdMap == null || itemTypeToIdMap.size() == 0) {
            return;
        }
        List<Long> tagIdList = itemTypeToIdMap.get(SalaryRptItemTypeEnum.ITEMTAG.getCode());
        if (tagIdList == null || tagIdList.size() == 0) {
            return;
        }
        DynamicObjectCollection tagDataList = this.getStatisticstagData(tagIdList, tagMap);
        HashMap<Long, List<Long>> parentNodeRelMap = new HashMap<Long, List<Long>>(tagDataList.size());
        for (DynamicObject tag : tagDataList) {
            List childrenList = parentNodeRelMap.computeIfAbsent(tag.getLong("parent.id"), single -> new ArrayList(10));
            childrenList.add(tag.getLong("id"));
        }
        HashMap<Long, HashSet<Long>> dataMap = new HashMap<Long, HashSet<Long>>(16);
        HashSet<Long> tagIdParamSet = new HashSet<Long>(tagDataList.size());
        HashSet<Long> tempSet = null;
        for (Long tagId : tagIdList) {
            tempSet = new HashSet<Long>(16);
            tempSet.add(tagId);
            this.handleTagTreeData(tagId, parentNodeRelMap, tempSet);
            dataMap.put(tagId, tempSet);
            tagIdParamSet.addAll(tempSet);
        }
        HashMap<String, String> dataTypeMap = new HashMap<String, String>(16);
        Map<Long, List<Long>> salaryItemMap = this.getSalaryItemDataMap(tagIdParamSet, dataTypeMap);
        HashMap statisticsTagRelMap = Maps.newHashMapWithExpectedSize((int)16);
        for (Map.Entry entry : dataMap.entrySet()) {
            List itemIdList = statisticsTagRelMap.computeIfAbsent(entry.getKey(), single -> new ArrayList(10));
            for (Long tagId : (Set)entry.getValue()) {
                List<Long> tempList = salaryItemMap.get(tagId);
                if (tempList == null) continue;
                itemIdList.addAll(tempList);
            }
        }
        LOGGER.info("statisticsTagRelMap =>", (Object)((Object)statisticsTagRelMap).toString());
        HashSet itemIdSet = new HashSet(16);
        statisticsTagRelMap.values().stream().forEach(obj -> itemIdSet.addAll(obj));
        List<Long> salaryItemIdList = itemTypeToIdMap.get(SalaryRptItemTypeEnum.ITEM.getCode());
        if (salaryItemIdList == null) {
            salaryItemIdList = new ArrayList<Long>(10);
        }
        for (Long id : itemIdSet) {
            if (salaryItemIdList.contains(id)) continue;
            salaryItemIdList.add(id);
        }
        itemTypeToIdMap.put(SalaryRptItemTypeEnum.ITEM.getCode(), salaryItemIdList);
        salRptQueryInfo.setItemTypeToIdMap(itemTypeToIdMap);
        salRptQueryInfo.setStatisticsTagRelMap(statisticsTagRelMap);
        if (salRptQueryInfo.getDataTypeMap() == null) {
            salRptQueryInfo.setDataTypeMap(dataTypeMap);
        } else {
            salRptQueryInfo.getDataTypeMap().putAll(dataTypeMap);
        }
        LOGGER.info("cacheTagItemRelMap end");
    }

    private Map<Long, List<Long>> getSalaryItemDataMap(Set<Long> tagIdParamSet, Map<String, String> dataTypeMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        String fields = "id,statisticstag.id,datatype.id";
        QFilter filter = new QFilter("statisticstag.id", "in", tagIdParamSet);
        filter.and("enable", "!=", (Object)"10");
        filter.and("datatype.id", "in", (Object)new Long[]{DataTypeEnum.NUMBERIC.getDbId(), DataTypeEnum.AMOUNT.getDbId()});
        DynamicObjectCollection dataList = helper.queryOriginalCollection(fields, new QFilter[]{filter});
        HashMap<Long, List<Long>> salaryItemMap = new HashMap<Long, List<Long>>(dataList.size());
        String key = null;
        String value = null;
        for (DynamicObject obj : dataList) {
            List idList = salaryItemMap.computeIfAbsent(obj.getLong("statisticstag.id"), single -> new ArrayList(10));
            idList.add(obj.getLong("id"));
            key = SalaryRptItemTypeEnum.ITEM.getCode() + "_" + obj.getLong("id");
            value = DataTypeEnum.NUMBERIC.getDbId() == obj.getLong("datatype.id") ? (String)SalaryRptService.getRlsMap().get("num") : (String)SalaryRptService.getRlsMap().get("amount");
            dataTypeMap.put(key, value);
        }
        return salaryItemMap;
    }

    private void handleTagTreeData(Long tagId, Map<Long, List<Long>> parentNodeRelMap, Set<Long> tempSet) {
        List<Long> childList = parentNodeRelMap.get(tagId);
        if (SWCListUtils.isEmpty(childList)) {
            return;
        }
        for (Long id : childList) {
            tempSet.add(id);
            this.handleTagTreeData(id, parentNodeRelMap, tempSet);
        }
    }

    private DynamicObjectCollection getStatisticstagData(List<Long> tagIdList, Map<Long, DynamicObject> tagMap) {
        QFilter filter = new QFilter("id", "in", tagIdList);
        String longNumberValue = null;
        for (DynamicObject obj : tagMap.values()) {
            longNumberValue = obj.getLong("parent.id") == 0L ? obj.getString("number") + ".%" : "%." + obj.getString("number") + ".%";
            filter.or(new QFilter("longnumber", "like", (Object)longNumberValue));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
        String fields = "id,number,longnumber,parent.id";
        DynamicObjectCollection data = helper.queryOriginalCollection(fields, new QFilter[]{filter}, "longnumber asc");
        return data;
    }
}

