/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsas.business.salaryrpt.SalaryRptService;
import kd.swc.hsas.common.enums.SalaryRptItemTypeEnum;
import kd.swc.hsas.report.entity.SalaryRptColumnInfo;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.impl.SalaryRptParamBaseHandler;
import kd.swc.hsbp.common.util.SWCStringUtils;

public abstract class SalarySchemeRptParamHandler
extends SalaryRptParamBaseHandler {
    @Override
    protected List<SalaryRptColumnInfo> buildColumnInfoList(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        return this.parseReportScheme(filterInfo, salRptQueryInfo);
    }

    protected List<SalaryRptColumnInfo> parseReportScheme(FilterInfo filterInfo, SalaryRptQueryInfo salRptQueryInfo) {
        DynamicObject reportScheme;
        long reportSchemeId = filterInfo.getLong("displayscheme");
        String schemeEntity = salRptQueryInfo.getCustomPara("schemeEntity", String.class);
        if (SWCStringUtils.isEmpty((String)schemeEntity)) {
            schemeEntity = "hsas_salaryrptdisplayschm";
        }
        if ((reportScheme = SalaryRptService.queryRptDisplaySchemeObj((String)schemeEntity, (Long)reportSchemeId)) == null) {
            throw new KDBizException("reportScheme(" + reportSchemeId + ") is not exist. ");
        }
        this.loadAdvancedSetting(salRptQueryInfo, reportScheme);
        DynamicObjectCollection schemeEntries = reportScheme.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)schemeEntries)) {
            return Lists.newArrayList();
        }
        ArrayList columnInfos = Lists.newArrayListWithCapacity((int)schemeEntries.size());
        for (DynamicObject schemeEntry : schemeEntries) {
            SalaryRptColumnInfo columnInfo = this.createColumnInfo(schemeEntry);
            this.afterCreateColumnInfo(columnInfos, columnInfo, schemeEntry);
            columnInfos.add(columnInfo);
            this.decorateColumnInfo(columnInfos, columnInfo, schemeEntry, salRptQueryInfo);
        }
        return columnInfos;
    }

    protected void loadAdvancedSetting(SalaryRptQueryInfo salRptQueryInfo, DynamicObject reportScheme) {
    }

    protected SalaryRptColumnInfo createColumnInfo(DynamicObject schemeEntry) {
        SalaryRptColumnInfo columnInfo = new SalaryRptColumnInfo();
        String fieldCode = schemeEntry.getString("fieldalias");
        columnInfo.setFieldCode(fieldCode);
        columnInfo.setCaption(schemeEntry.getString("displayname"));
        columnInfo.setFreeze(schemeEntry.getBoolean("freeze"));
        columnInfo.setColumnWidth(schemeEntry.getInt("columnwidth"));
        columnInfo.setAlignment(schemeEntry.getString("alignment"));
        columnInfo.setSort(schemeEntry.getInt("sort"));
        columnInfo.setSortType(schemeEntry.getInt("sorttype") == 1 ? "ASC" : "DESC");
        columnInfo.setHide(schemeEntry.getBoolean("ishide"));
        String isDimension = schemeEntry.getString("isdimension");
        if (StringUtils.equals((CharSequence)isDimension, (CharSequence)"1")) {
            columnInfo.setGroupBy(true);
        } else if (StringUtils.equals((CharSequence)isDimension, (CharSequence)"2")) {
            columnInfo.setRelate(true);
        }
        String secondaryHeader = schemeEntry.getString("secondaryheader");
        if (!StringUtils.isEmpty((CharSequence)secondaryHeader)) {
            ArrayList parentHeaders = Lists.newArrayListWithCapacity((int)2);
            parentHeaders.add(secondaryHeader);
            columnInfo.setParentHeaders(parentHeaders);
        }
        String fieldType = schemeEntry.getString("fieldtype");
        columnInfo.setDataType(fieldType);
        if (fieldCode.startsWith("item")) {
            String[] splits = fieldCode.split("_");
            String itemType = splits[0];
            long itemId = Long.parseLong(splits[1]);
            SalaryRptItemTypeEnum itemTypeEnum = SalaryRptItemTypeEnum.getEnumByCode((String)itemType);
            columnInfo.setItem(true);
            columnInfo.setItemId(itemId);
            columnInfo.setItemType(itemType);
            columnInfo.setItemValueField(itemTypeEnum.getWholeValueFieldCode(fieldType));
        }
        return columnInfo;
    }

    protected void afterCreateColumnInfo(List<SalaryRptColumnInfo> columnInfos, SalaryRptColumnInfo columnInfo, DynamicObject schemeEntry) {
    }

    protected void decorateColumnInfo(List<SalaryRptColumnInfo> columnInfos, SalaryRptColumnInfo columnInfo, DynamicObject schemeEntry, SalaryRptQueryInfo salRptQueryInfo) {
    }
}

