/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.impl.matcher;

import java.util.Date;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.report.api.RowDataMatcher;
import kd.swc.hsas.report.api.RowDataMatcherSupplier;
import kd.swc.hsas.report.common.SalaryRptUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class PayRollDateMatcher
implements RowDataMatcher {
    private Date payRollDate;
    private Date payRollStartDay;
    private Date payRollEndDay;

    @Override
    public boolean match(Row row) {
        Date date = row.getDate("belongperiod");
        return SWCDateTimeUtils.isDateRangeOverlap((Date)this.payRollStartDay, (Date)this.payRollEndDay, (Date)date, (Date)date);
    }

    @Override
    public QFilter toQFilter() {
        this.payRollStartDay = SalaryRptUtils.getMonthFirstDay(this.payRollDate, 0);
        this.payRollEndDay = SalaryRptUtils.getMonthFirstDay(this.payRollDate, 1);
        QFilter filter = new QFilter("belongperiod", ">=", (Object)this.payRollStartDay);
        filter.and("belongperiod", "<", (Object)this.payRollEndDay);
        return filter;
    }

    @Override
    public String filterField() {
        return "belongperiod";
    }

    public static class Supplier
    implements RowDataMatcherSupplier {
        @Override
        public RowDataMatcher tarMatcher(FilterInfo filterInfo) {
            PayRollDateMatcher matcher = new PayRollDateMatcher();
            matcher.payRollDate = filterInfo.getDate("payrolldatetar");
            return matcher;
        }

        @Override
        public RowDataMatcher srcMatcher(FilterInfo filterInfo) {
            PayRollDateMatcher matcher = new PayRollDateMatcher();
            matcher.payRollDate = filterInfo.getDate("payrolldatesrc");
            return matcher;
        }
    }
}

