/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.impl.matcher;

import java.util.Date;
import kd.bos.algo.Row;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.report.api.RowDataMatcher;
import kd.swc.hsas.report.api.RowDataMatcherSupplier;
import kd.swc.hsas.report.common.SalaryRptUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;

public class PayRollDateRangeMatcher
implements RowDataMatcher {
    private Date payRollDateStart;
    private Date payRollDateEnd;
    private Date payRollStartDay;
    private Date payRollEndDay;

    @Override
    public boolean match(Row row) {
        Date date = row.getDate("belongperiod");
        return SWCDateTimeUtils.isDateRangeOverlap((Date)this.payRollStartDay, (Date)this.payRollEndDay, (Date)date, (Date)date);
    }

    @Override
    public QFilter toQFilter() {
        this.payRollStartDay = SalaryRptUtils.getMonthFirstDay(this.payRollDateStart, 0);
        this.payRollEndDay = SalaryRptUtils.getMonthFirstDay(this.payRollDateEnd, 1);
        QFilter filter = new QFilter("belongperiod", ">=", (Object)this.payRollStartDay);
        filter.and("belongperiod", "<", (Object)this.payRollEndDay);
        return filter;
    }

    @Override
    public String filterField() {
        return "belongperiod";
    }

    public static class Supplier
    implements RowDataMatcherSupplier {
        @Override
        public RowDataMatcher tarMatcher(FilterInfo filterInfo) {
            PayRollDateRangeMatcher matcher = new PayRollDateRangeMatcher();
            matcher.payRollDateStart = filterInfo.getDate("startpayrolldatetar");
            matcher.payRollDateEnd = filterInfo.getDate("endpayrolldatetar");
            return matcher;
        }

        @Override
        public RowDataMatcher srcMatcher(FilterInfo filterInfo) {
            PayRollDateRangeMatcher matcher = new PayRollDateRangeMatcher();
            matcher.payRollDateStart = filterInfo.getDate("startpayrolldatesrc");
            matcher.payRollDateEnd = filterInfo.getDate("endpayrolldatesrc");
            return matcher;
        }
    }
}

