/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.impl.matcher;

import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.swc.hsas.report.api.RowDataMatcher;
import kd.swc.hsas.report.api.RowDataMatcherSupplier;

public class PeriodsMatcher
implements RowDataMatcher {
    private static final String FIELD_CALPERIOD = "calperiod.id";
    private Set<Long> periodIds;

    @Override
    public boolean match(Row row) {
        return this.periodIds.contains(row.getLong(FIELD_CALPERIOD));
    }

    @Override
    public QFilter toQFilter() {
        return new QFilter(FIELD_CALPERIOD, "in", this.periodIds);
    }

    @Override
    public String filterField() {
        return FIELD_CALPERIOD;
    }

    public static class Supplier
    implements RowDataMatcherSupplier {
        @Override
        public RowDataMatcher tarMatcher(FilterInfo filterInfo) {
            PeriodsMatcher matcher = new PeriodsMatcher();
            DynamicObjectCollection periods = filterInfo.getDynamicObjectCollection("calperiodstar");
            matcher.periodIds = periods.stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
            return matcher;
        }

        @Override
        public RowDataMatcher srcMatcher(FilterInfo filterInfo) {
            PeriodsMatcher matcher = new PeriodsMatcher();
            DynamicObjectCollection periods = filterInfo.getDynamicObjectCollection("calperiodssrc");
            matcher.periodIds = periods.stream().map(ele -> ele.getLong("id")).collect(Collectors.toSet());
            return matcher;
        }
    }
}

