/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.CollectionInput;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRQueryEntityHelper;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsas.report.helper.CalPersonQueryHelper;
import kd.swc.hsas.report.web.SalaryRptBaseAbstractPlugin;
import org.apache.commons.collections4.ListUtils;
import org.jetbrains.annotations.NotNull;

public abstract class SalaryAsyncSumAbstractPlugin
extends SalaryRptBaseAbstractPlugin {
    private static final Log log = LogFactory.getLog(SalaryAsyncSumAbstractPlugin.class);
    public Integer totalCount;
    public Integer alreadyCount;
    public boolean isLoadAllData;
    public Set<String> dimDataSet;
    public DataSet preDataSet;
    public DataSet personDataSet;
    public boolean isShowTotal = true;
    public static final String FIELD_PERSON = "hsas_employee.id";
    public static final String FIELD_PERSONNUM = "personnum";
    public static final String FIELD_SEQ = "seq";
    public static final int PAGESIZE = 1000;
    protected List<Object> calPersonIds;
    public static final int DIMQUERYLIMIT = 10000;
    public static final int DIMCOUNTLIMIT = 10000;

    @Override
    protected DataSet query(ReportQueryParam reportQueryParam, Object selectObj, SalaryRptQueryInfo queryInfo) {
        this.setProgress(0);
        this.queryInfo = queryInfo;
        this.totalCount = 0;
        this.alreadyCount = 0;
        this.isShowTotal = queryInfo.isShowTotal();
        this.calPersonIds = new ArrayList<Object>(10);
        this.timeLog.logStart("SalaryAsyncSumAbstractPlugin query beforeQuery");
        this.beforeQuery(reportQueryParam, selectObj, queryInfo);
        this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin query beforeQuery");
        this.timeLog.logStart("SalaryAsyncSumAbstractPlugin query buildTotalCount");
        this.buildTotalCount();
        this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin query buildTotalCount");
        log.info("SalaryAsyncSumAbstractPlugin totalCount {}", (Object)this.totalCount);
        this.timeLog.logStart("SalaryAsyncSumAbstractPlugin query buildData");
        DataSet dataSet = this.buildData(reportQueryParam, selectObj, queryInfo);
        this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin query buildData");
        return dataSet;
    }

    @Override
    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        columns = super.getColumns(columns);
        this.setProgress(100);
        return columns;
    }

    protected void beforeQuery(ReportQueryParam reportQueryParam, Object selectObj, SalaryRptQueryInfo queryInfo) {
        this.initDetailMailSelectFields(queryInfo);
    }

    private void initDetailMailSelectFields(SalaryRptQueryInfo queryInfo) {
        List<String> detailSelectProperties = queryInfo.getMainSelectFields();
        if (!detailSelectProperties.contains(FIELD_PERSON)) {
            detailSelectProperties.add(FIELD_PERSON);
        }
        if (!detailSelectProperties.contains("id")) {
            detailSelectProperties.add("id");
        }
    }

    protected void buildTotalCount() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(this.queryInfo.getFilters());
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)this.queryInfo.getQueryEntityCode());
        List list = HRQueryEntityHelper.getInstance().queryAllPkByKSql(queryEntityType, qFilters.toArray(new QFilter[0]), null);
        if (list != null) {
            this.calPersonIds = list.stream().map(obj -> Long.parseLong(obj.toString())).collect(Collectors.toList());
            this.totalCount = this.calPersonIds.size();
        }
    }

    protected List<Object> getCalPersonIds(Integer currPageId) {
        int startIndex = currPageId * 1000;
        if (this.calPersonIds == null || this.calPersonIds.size() <= startIndex) {
            return new ArrayList<Object>(0);
        }
        int endIndex = (currPageId + 1) * 1000;
        endIndex = this.calPersonIds.size() >= endIndex ? endIndex : this.calPersonIds.size();
        return this.calPersonIds.subList(startIndex, endIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet buildData(ReportQueryParam reportQueryParam, Object selectObj, SalaryRptQueryInfo queryInfo) {
        if (this.totalCount == 0) {
            this.setProgress(99);
            return this.createEmptyDataSet();
        }
        try {
            if (!this.buildDimDataSet(reportQueryParam)) {
                this.setProgress(99);
                DataSet dataSet = this.createEmptyDataSet();
                return dataSet;
            }
            int currPageIndex = 0;
            while (!this.isLoadAllData) {
                this.timeLog.logStart("SalaryAsyncSumAbstractPlugin buildPageData");
                this.buildPageData(currPageIndex);
                ++currPageIndex;
                this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin buildPageData");
                log.info("SalaryAsyncSumAbstractPlugin alreadyCount {}", (Object)this.alreadyCount);
            }
            DataSet dataSet = this.buildResultData();
            return dataSet;
        }
        finally {
            if (this.preDataSet != null) {
                this.preDataSet.close();
            }
            if (this.personDataSet != null) {
                this.personDataSet.close();
            }
            this.setProgress(99);
        }
    }

    protected boolean buildDimDataSet(ReportQueryParam reportQueryParam) {
        List<String> groupByFields = this.queryInfo.getGroupByFields();
        List<String> mainSelectFields = this.queryInfo.getMainSelectFields();
        ArrayList<String> selectFields = new ArrayList<String>(10);
        HashMap<String, List<Long>> itemIdMap = new HashMap<String, List<Long>>(16);
        for (String groupByField : groupByFields) {
            if (mainSelectFields.contains(groupByField)) {
                selectFields.add(groupByField);
                continue;
            }
            if (!groupByField.startsWith("item")) continue;
            String itemTypeCode = groupByField.substring(0, groupByField.indexOf(95));
            String itemId = groupByField.substring(groupByField.indexOf(95) + 1);
            if (itemIdMap.get(itemTypeCode) == null) {
                itemIdMap.put(itemTypeCode, new ArrayList(10));
            }
            ((List)itemIdMap.get(itemTypeCode)).add(Long.valueOf(itemId));
        }
        if (!selectFields.contains("id")) {
            selectFields.add("id");
        }
        CalPersonQueryHelper queryHelper = new CalPersonQueryHelper();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)this.queryInfo.getQueryEntityCode());
        List subCalPersonIds = ListUtils.partition(this.calPersonIds, (int)10000);
        this.dimDataSet = new HashSet<String>(16);
        for (List subIds : subCalPersonIds) {
            try (DataSet detailDataSet = queryHelper.buildDetailDataSet(queryEntityType, subIds, selectFields, itemIdMap, this.queryInfo.getDataTypeMap(), this.queryInfo.getStatisticsTagRelMap());){
                if (detailDataSet != null) {
                    for (Row row : detailDataSet) {
                        this.dimDataSet.add(this.getDimStr(selectFields, row));
                    }
                } else {
                    log.error("SalaryAsyncSumAbstractPlugin buildDetailDataSet error");
                }
            }
            if (this.dimDataSet.size() <= 10000) continue;
            String message = ResManager.loadKDString((String)"\u67e5\u8be2\u7ef4\u5ea6\u6570\u636e\u8fc7\u5927\uff0c\u8bf7\u51cf\u5c11\u67e5\u8be2\u7ef4\u5ea6\u6216\u67e5\u8be2\u6570\u636e\u8303\u56f4\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"SalaryAsyncSumAbstractPlugin_0", (String)"swc-hsas-report", (Object[])new Object[0]);
            reportQueryParam.setMessage(message);
            return false;
        }
        return true;
    }

    @NotNull
    private String getDimStr(List<String> selectFields, Row row) {
        StringBuilder dimStringBuilder = new StringBuilder();
        for (String selectField : selectFields) {
            if (selectField.equals("id")) continue;
            dimStringBuilder.append(row.getString(selectField));
        }
        return dimStringBuilder.toString();
    }

    private void buildPageData(int currPageIndex) {
        this.timeLog.logStart("SalaryAsyncSumAbstractPlugin buildPageData queryId");
        List<Object> pkList = this.getCalPersonIds(currPageIndex);
        if (pkList == null || pkList.size() == 0) {
            this.isLoadAllData = true;
            this.setProgress(this.getCurrentPercent());
            return;
        }
        this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin buildPageData queryId");
        this.timeLog.logStart("SalaryAsyncSumAbstractPlugin buildPageData queryDetail");
        CalPersonQueryHelper queryHelper = new CalPersonQueryHelper();
        QueryEntityType queryEntityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)this.queryInfo.getQueryEntityCode());
        try (DataSet detailDataSet = queryHelper.buildDetailDataSet(queryEntityType, pkList, this.queryInfo.getMainSelectFields(), this.queryInfo.getItemTypeToIdMap(), this.queryInfo.getDataTypeMap(), this.queryInfo.getStatisticsTagRelMap());){
            this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin buildPageData queryDetail");
            this.timeLog.logStart("SalaryAsyncSumAbstractPlugin buildPageData buildPreDataSet");
            if (detailDataSet != null) {
                this.buildPreDataSet(detailDataSet);
            } else {
                log.error("SalaryAsyncSumAbstractPlugin buildDetailDataSet error");
            }
            this.timeLog.logEnd("SalaryAsyncSumAbstractPlugin buildPageData buildPreDataSet");
        }
        this.alreadyCount = pkList.size() + this.alreadyCount;
        this.setProgress(this.getCurrentPercent());
    }

    protected void buildPreDataSet(DataSet detailDataSet) {
        if ("1".equals(this.queryInfo.getCustomPara("countStructure", String.class))) {
            detailDataSet = detailDataSet.addField("hsas_empposorgrelhr.adminorg.id", "adminorg.id");
            detailDataSet = detailDataSet.removeFields(new String[]{"hsas_empposorgrelhr.adminorg.id"});
        }
        this.buildPersonGroupDataSet(detailDataSet);
        this.buildGroupDataSet(detailDataSet);
    }

    protected void buildGroupDataSet(DataSet detailDataSet) {
        ArrayList<String> groupByFields = new ArrayList<String>(this.queryInfo.getGroupByFields());
        ArrayList<String> fieldNameList = new ArrayList<String>(groupByFields);
        LinkedHashSet sumFieldCodes = Sets.newLinkedHashSet(this.queryInfo.getSumFieldCodes());
        sumFieldCodes.retainAll(Lists.newArrayList((Object[])detailDataSet.getRowMeta().getFieldNames()));
        fieldNameList.addAll(sumFieldCodes);
        String[] fieldNames = fieldNameList.toArray(new String[0]);
        if (this.preDataSet != null) {
            detailDataSet = detailDataSet.copy().select(fieldNames).union(this.preDataSet);
        }
        GroupbyDataSet groupByDataSet = detailDataSet.groupBy(groupByFields.toArray(new String[0]));
        for (String sumField : sumFieldCodes) {
            groupByDataSet = groupByDataSet.sum("case when " + sumField + " is null then 0 else " + sumField + " end ", sumField);
        }
        this.preDataSet = groupByDataSet.finish();
        this.preDataSet = this.preDataSet.select(fieldNameList.toArray(new String[0]));
    }

    protected DataSet buildResultData() {
        return this.preDataSet.select(this.queryInfo.getRowMeta().getFieldNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet addPersonNumField(DataSet dataSet) {
        try (DataSet personSumDataSet = null;){
            StringBuilder joinStringBuilder = new StringBuilder("' ' + ");
            for (String groupByField : this.queryInfo.getGroupByFields()) {
                joinStringBuilder.append(groupByField).append('+');
            }
            String joinStr = joinStringBuilder.substring(0, joinStringBuilder.length() - 1);
            dataSet = dataSet.addField(joinStr, "joinstr");
            GroupbyDataSet personGroupByDataSet = this.personDataSet.groupBy(this.queryInfo.getGroupByFields().toArray(new String[0]));
            personGroupByDataSet = personGroupByDataSet.countDistinct(new String[]{FIELD_PERSON}, FIELD_PERSONNUM);
            personSumDataSet = personGroupByDataSet.finish();
            personSumDataSet = personSumDataSet.addField(joinStr, "joinstr");
            personSumDataSet = personSumDataSet.removeFields(this.queryInfo.getGroupByFields().toArray(new String[0]));
            String[] fieldNames = dataSet.getRowMeta().getFieldNames();
            fieldNames[fieldNames.length - 1] = FIELD_PERSONNUM;
            dataSet = dataSet.join(personSumDataSet).on("joinstr", "joinstr").select(fieldNames).finish();
            this.addCustomFieldWhenAddPersonNumField(dataSet);
            DataSet dataSet2 = dataSet;
            return dataSet2;
        }
    }

    protected DataSet addCustomFieldWhenAddPersonNumField(DataSet dataSet) {
        return dataSet;
    }

    public DataSet buildSeqDataSet(DataSet dataSet) {
        dataSet = dataSet.addField("1", "seq_str").addBalanceField("seq_str", "seq_balance");
        dataSet = dataSet.addField("cast(seq_balance as string)", FIELD_SEQ);
        dataSet = dataSet.removeFields(new String[]{"seq_str"}).removeFields(new String[]{"seq_balance"});
        return dataSet;
    }

    public DataSet createEmptyDataSet() {
        CollectionInput inputs = new CollectionInput(this.queryInfo.getRowMeta(), new ArrayList());
        return Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildPersonGroupDataSet(DataSet detailDataSet) {
        ArrayList<String> groupByPersonFields = new ArrayList<String>(this.queryInfo.getGroupByFields());
        if (!groupByPersonFields.contains(FIELD_PERSON)) {
            groupByPersonFields.add(FIELD_PERSON);
        }
        try (DataSet currPersonDataSet = null;){
            currPersonDataSet = detailDataSet.copy().select(groupByPersonFields.toArray(new String[0]));
            this.personDataSet = this.personDataSet != null ? currPersonDataSet.union(this.personDataSet).groupBy(groupByPersonFields.toArray(new String[0])).finish() : currPersonDataSet.groupBy(groupByPersonFields.toArray(new String[0])).finish();
        }
    }

    private int getCurrentPercent() {
        int percent = 0;
        percent = this.isLoadAllData ? 99 : ((percent = new BigDecimal(this.alreadyCount).divide(new BigDecimal(this.totalCount), 4, 1).multiply(new BigDecimal("99")).intValue()) > 99 ? 99 : percent);
        log.info("SalaryAsyncSumAbstractPlugin percent {}", (Object)percent);
        return percent;
    }
}

