/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsas.report.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.Tips;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.ColumnStyle;
import kd.bos.entity.report.ComboReportColumn;
import kd.bos.entity.report.DecimalReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.swc.hsas.business.salaryrpt.SalaryRptDateLogger;
import kd.swc.hsas.business.salaryrpt.entity.SchemeAdvanceInfo;
import kd.swc.hsas.report.api.SalaryRptParamHandler;
import kd.swc.hsas.report.entity.SalaryRptAmountFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptColumnInfo;
import kd.swc.hsas.report.entity.SalaryRptComboFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptDecimalFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptFormatInfo;
import kd.swc.hsas.report.entity.SalaryRptQueryInfo;
import kd.swc.hsbp.common.cache.SWCPageCache;

public abstract class SalaryRptBaseAbstractPlugin
extends AbstractReportListDataPlugin {
    protected SalaryRptDateLogger timeLog = new SalaryRptDateLogger(SalaryRptBaseAbstractPlugin.class);
    protected SalaryRptQueryInfo queryInfo;

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        this.timeLog.logStart("SalaryRptBaseAbstractPlugin queryBatchBy ");
        SalaryRptParamHandler rptQueryParamHandler = this.getRptQueryParamHandler();
        this.timeLog.logStart("SalaryRptBaseAbstractPlugin queryBatchBy handleRptQueryParam ");
        this.queryInfo = rptQueryParamHandler.handleRptQueryParam(queryParam);
        this.timeLog.logEnd("SalaryRptBaseAbstractPlugin queryBatchBy handleRptQueryParam ");
        DataSet dataSet = this.queryBatchBy(queryParam, this.queryInfo);
        this.cacheQueryInfo(this.queryInfo);
        this.timeLog.logEnd("SalaryRptBaseAbstractPlugin queryBatchBy ");
        return dataSet;
    }

    protected abstract SalaryRptParamHandler getRptQueryParamHandler();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        this.timeLog.logStart("SalaryRptBaseAbstractPlugin query");
        String pageId = this.getPageId(reportQueryParam);
        this.queryInfo = this.getCacheQueryInfo(pageId);
        DataSet query = this.query(reportQueryParam, o, this.queryInfo);
        this.cacheQueryInfo(this.queryInfo);
        this.timeLog.logEnd("SalaryRptBaseAbstractPlugin query");
        return query;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        if (this.queryInfo == null) {
            return Lists.newArrayList();
        }
        List<SalaryRptColumnInfo> salaryRptColumnInfoList = this.queryInfo.getSalaryRptColumnInfoList();
        SchemeAdvanceInfo schemeAdvanceInfo = this.queryInfo.getCustomPara("schemeAdvanceInfo", SchemeAdvanceInfo.class);
        HashMap<String, ReportColumnGroup> groupMap = new HashMap<String, ReportColumnGroup>(salaryRptColumnInfoList.size());
        HashSet needCellStyleRuleCols = Sets.newHashSetWithExpectedSize((int)columns.size());
        for (SalaryRptColumnInfo columnInfo : salaryRptColumnInfoList) {
            if (!columnInfo.isBuildColumn()) continue;
            if (schemeAdvanceInfo != null && schemeAdvanceInfo.isDiffValShowDiv() && this.needCellStyleRule(columnInfo)) {
                needCellStyleRuleCols.add(columnInfo.getFieldCode());
            }
            AbstractReportColumn column = this.createReportColumn(columnInfo);
            List<String> parentHeaders = columnInfo.getParentHeaders();
            ReportColumnGroup group = this.getReportColumnGroup(parentHeaders, groupMap, columns);
            if (group != null) {
                group.getChildren().add(column);
                continue;
            }
            columns.add(column);
        }
        this.decorateAfterGetColumns(columns, this.queryInfo);
        this.cacheCellStyleRules(needCellStyleRuleCols, schemeAdvanceInfo);
        return columns;
    }

    protected boolean needCellStyleRule(SalaryRptColumnInfo columnInfo) {
        return false;
    }

    protected void decorateAfterGetColumns(List<AbstractReportColumn> columns, SalaryRptQueryInfo queryInfo) {
    }

    protected ReportColumnGroup getReportColumnGroup(List<String> parentHeaders, Map<String, ReportColumnGroup> groupMap, List<AbstractReportColumn> columns) {
        ReportColumnGroup group = null;
        if (CollectionUtils.isEmpty(parentHeaders)) {
            return null;
        }
        for (int i = 0; i < parentHeaders.size(); ++i) {
            String parentHeader = parentHeaders.get(i);
            group = groupMap.get(parentHeader);
            if (group != null) continue;
            group = new ReportColumnGroup();
            group.setCaption(new LocaleString(parentHeader));
            group.setFieldKey(parentHeader);
            groupMap.put(parentHeader, group);
            int lastIndex = i - 1;
            if (lastIndex < 0) {
                columns.add((AbstractReportColumn)group);
                continue;
            }
            ReportColumnGroup parentGroup = groupMap.get(parentHeaders.get(lastIndex));
            parentGroup.getChildren().add(group);
        }
        return group;
    }

    protected AbstractReportColumn createReportColumn(SalaryRptColumnInfo columnInfo) {
        ReportColumn reportColumn = new ReportColumn();
        String dataType = columnInfo.getDataType();
        SalaryRptFormatInfo formatInfo = columnInfo.getFormatInfo();
        switch (dataType) {
            case "amount": {
                reportColumn.setFieldType("amount");
                reportColumn.setZeroShow(true);
                if (formatInfo == null) break;
                reportColumn.setCurrencyField(((SalaryRptAmountFormatInfo)formatInfo).getCurrencyFieldCode());
                break;
            }
            case "decimal": {
                reportColumn = new DecimalReportColumn();
                reportColumn.setFieldType("decimal");
                reportColumn.setZeroShow(true);
                if (formatInfo != null) {
                    reportColumn.setScale(((SalaryRptDecimalFormatInfo)formatInfo).getScale());
                }
                if (columnInfo.isItem()) {
                    reportColumn.setZeroShow(true);
                    break;
                }
                reportColumn.setZeroShow(false);
                break;
            }
            case "integer": {
                reportColumn.setFieldType("integer");
                if (columnInfo.isItem()) {
                    reportColumn.setZeroShow(true);
                    break;
                }
                reportColumn.setZeroShow(false);
                break;
            }
            case "date": {
                reportColumn.setFieldType("date");
                break;
            }
            case "combofield": {
                reportColumn = new ComboReportColumn();
                reportColumn.setFieldType("combofield");
                if (formatInfo == null) break;
                ((ComboReportColumn)reportColumn).setComboItems(((SalaryRptComboFormatInfo)formatInfo).getValueMapItemList());
                break;
            }
            case "boolean": {
                reportColumn.setFieldType("boolean");
                break;
            }
            case "currency": {
                reportColumn.setFieldType("currency");
                reportColumn.setEntityId("bd_currency");
                break;
            }
            default: {
                reportColumn.setFieldType("text");
            }
        }
        reportColumn.setCaption(new LocaleString(columnInfo.getCaption()));
        reportColumn.setFieldKey(columnInfo.getFieldCode());
        reportColumn.setHideSingleColumnRow(false);
        reportColumn.setWidth(new LocaleString(String.valueOf(columnInfo.getColumnWidth())));
        reportColumn.setFreeze(columnInfo.isFreeze());
        reportColumn.setHide(columnInfo.isHide());
        String tipStr = columnInfo.getTip();
        if (!StringUtils.isEmpty((Object)tipStr)) {
            Tips tips = new Tips();
            tips.setType("text");
            tips.setContent(new LocaleString(tipStr));
            reportColumn.setCtlTips(tips);
        }
        ColumnStyle style = new ColumnStyle();
        style.setTextAlign(columnInfo.getAlignment());
        reportColumn.setStyle(style);
        return reportColumn;
    }

    protected DataSet queryBatchBy(ReportQueryParam queryParam, SalaryRptQueryInfo queryInfo) {
        return null;
    }

    protected abstract DataSet query(ReportQueryParam var1, Object var2, SalaryRptQueryInfo var3);

    protected String getPageId(ReportQueryParam queryParam) {
        Object pageid = queryParam.getCustomParam().get("pageid");
        if (pageid == null) {
            throw new KDBizException("pageid can not null when query data ");
        }
        return (String)pageid;
    }

    protected void cacheQueryInfo(SalaryRptQueryInfo queryInfo) {
        if (queryInfo == null) {
            return;
        }
        String pageId = queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        pageCache.put("queryInfo", (Object)this.toSerializedString(queryInfo));
        pageCache.saveChanges();
    }

    protected void cacheCellStyleRules(Set<String> needCellStyleRuleCols, SchemeAdvanceInfo schemeAdvanceInfo) {
        String pageId = this.queryInfo.getPageId();
        SWCPageCache pageCache = new SWCPageCache(pageId);
        pageCache.put("needCellStyleRuleCols", needCellStyleRuleCols);
        if (schemeAdvanceInfo != null) {
            pageCache.put("isChngRecShowDiv", (Object)(schemeAdvanceInfo.isChngRecShowDiv() ? "1" : "0"));
        }
        pageCache.saveChanges();
    }

    protected SalaryRptQueryInfo getCacheQueryInfo(String pageId) {
        Boolean isLoadAll;
        SWCPageCache pageCache = new SWCPageCache(pageId);
        String salaryReportQueryInfo = (String)pageCache.get("queryInfo", String.class);
        if (salaryReportQueryInfo == null) {
            return null;
        }
        SalaryRptQueryInfo queryInfo = (SalaryRptQueryInfo)this.fromSerializedString(salaryReportQueryInfo);
        if (!queryInfo.isLoadAll() && null != (isLoadAll = (Boolean)pageCache.get("report_isLoadAll", Boolean.class)) && isLoadAll.booleanValue()) {
            Integer totalBatch = (Integer)pageCache.get("report_totalBatch", Integer.class);
            queryInfo.setLoadAll(true);
            queryInfo.setTotalBatch(totalBatch);
        }
        return queryInfo;
    }

    /*
     * Exception decompiling
     */
    private String toSerializedString(Object obj) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private Object fromSerializedString(String str) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

