/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.util.FileNameUtils;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.business.threadpool.SWCThreadPoolFactory;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.imports.EntryDataProcesser;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.EntryProgressHandler;
import kd.swc.hsbp.formplugin.imports.ExcelParser;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.DataImportEvent;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class EntryImportStarter {
    private EntryImportContext importContext;
    private volatile boolean dataProcessStop = false;
    private volatile boolean excelReaderEnd = false;
    private volatile List<Map<Integer, String>> dataHead;
    private List<Map<Integer, String>> dataRow;
    private LinkedBlockingQueue<Map<Integer, String>> dataQueues;
    private static ThreadPool pool = SWCThreadPoolFactory.getCommonImportThreadpool();
    private CountDownLatch latch;
    private static final Log LOGGER = LogFactory.getLog(EntryImportStarter.class);

    public EntryImportStarter(EntryImportContext importContext) {
        this.importContext = importContext;
        this.dataQueues = new LinkedBlockingQueue(3000);
        this.latch = new CountDownLatch(2);
    }

    public EntryImportContext getImportContext() {
        return this.importContext;
    }

    public void setImportContext(EntryImportContext importContext) {
        this.importContext = importContext;
    }

    public boolean isDataProcessStop() {
        return this.dataProcessStop;
    }

    public void setDataProcessStop(boolean dataProcessStop) {
        this.dataProcessStop = dataProcessStop;
    }

    public boolean isExcelReaderEnd() {
        return this.excelReaderEnd;
    }

    public void setExcelReaderEnd(boolean excelReaderEnd) {
        this.excelReaderEnd = excelReaderEnd;
    }

    public List<Map<Integer, String>> getDataHead() {
        return this.dataHead;
    }

    public void setDataHead(List<Map<Integer, String>> dataHead) {
        this.dataHead = dataHead;
    }

    public List<Map<Integer, String>> getDataRow() {
        return this.dataRow;
    }

    public void setDataRow(List<Map<Integer, String>> dataRow) {
        this.dataRow = dataRow;
    }

    public LinkedBlockingQueue<Map<Integer, String>> getDataQueues() {
        return this.dataQueues;
    }

    public void setDataQueues(LinkedBlockingQueue<Map<Integer, String>> dataQueues) {
        this.dataQueues = dataQueues;
    }

    public void start() {
        pool.submit((Callable)new ExcelParser(this));
        pool.submit((Callable)new EntryDataProcesser(this));
        this.wait2End();
        this.end();
    }

    public void end() {
        this.dataProcessStop = true;
        this.writeLog();
        this.invokeAfterImport();
    }

    public void writeErrorLog(Throwable throwable) {
        try {
            this.getImportContext().getProcessHandler().getErrorLogCache().add(SWCStringUtils.formatException((Throwable)throwable));
            this.writeLog();
        }
        catch (Throwable t) {
            LOGGER.error("ImportStart_writeErrorLOGGER.", t);
        }
    }

    private void wait2End() {
        try {
            this.latch.await();
        }
        catch (InterruptedException var2) {
            LOGGER.error("wait2End interrupted by something.", (Throwable)var2);
        }
    }

    public void notifyWhenEnd() {
        this.latch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeLog() {
        EntryProgressHandler processHandler = this.importContext.getProcessHandler();
        boolean hasError = CollectionUtils.isNotEmpty(processHandler.getErrorLogCache());
        Map<Integer, List<String>> logCache = processHandler.getLogCache();
        int failedRow = processHandler.getFailedRow();
        List<String> errorLogCache = processHandler.getErrorLogCache();
        if (!hasError && failedRow == 0) {
            return;
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        String url = this.importContext.getImportFileUrl();
        OutputStream out = null;
        FileItem fileItem = null;
        FileInputStream fileInputStream = null;
        try {
            XSSFWorkbook workbook = new XSSFWorkbook(service.getInputStream(url));
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow fieldRow = sheet.getRow(this.importContext.getHeadEndRowNum());
            ImportConfig importConfig = this.importContext.getImportConfig();
            int headEndRowNum = this.importContext.getHeadEndRowNum();
            short lastCellNum = fieldRow.getLastCellNum();
            CellStyle cellStyle = this.getWarnTextStyle(workbook);
            String error = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"DynamicEntryImportStartEdit_6", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            Iterator rowIt = sheet.rowIterator();
            while (rowIt.hasNext()) {
                Row row = (Row)rowIt.next();
                Cell cell = row.createCell((int)lastCellNum);
                int rowNum = row.getRowNum();
                if (rowNum > EntryImportContext.FIX_HEAD_HEIGHT && rowNum <= headEndRowNum) {
                    cell.setCellStyle((CellStyle)this.setBorderStyle(workbook));
                }
                if (rowNum == EntryImportContext.FIX_HEAD_HEIGHT) {
                    cell.setCellStyle((CellStyle)this.setBorderStyle(workbook));
                    cell.setCellValue(error);
                    continue;
                }
                if (rowNum <= headEndRowNum) continue;
                List<String> logs = logCache.get(rowNum);
                if (hasError) {
                    logs = errorLogCache;
                }
                if (CollectionUtils.isNotEmpty(logs)) {
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(StringUtils.join((Object[])logs.toArray(), (String)";"));
                }
                if (!hasError) continue;
                break;
            }
            if (headEndRowNum > EntryImportContext.FIX_HEAD_HEIGHT) {
                sheet.addMergedRegion(new CellRangeAddress(EntryImportContext.FIX_HEAD_HEIGHT.intValue(), headEndRowNum, (int)lastCellNum, (int)lastCellNum));
            }
            File temp = File.createTempFile(UUID.randomUUID().toString(), ".xlsx");
            out = new FileOutputStream(temp);
            out.flush();
            workbook.write(out);
            Calendar cal = Calendar.getInstance();
            String formatStr = ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_{0}_{1}\u6708{2}\u65e5.xlsx", (String)"DynamicEntryImportStartEdit_18", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
            String fileName = MessageFormat.format(formatStr, importConfig.getModelName(), cal.get(2) + 1, cal.get(5));
            RequestContext ctx = RequestContext.getOrCreate();
            String path = FileNameUtils.getExportFileName((String)ctx.getTenantId(), (String)ctx.getAccountId(), (String)"hcdm", (String)("import" + UUID.randomUUID().toString()), (String)fileName);
            fileInputStream = new FileInputStream(temp);
            fileItem = new FileItem(FilenameUtils.getName((String)fileName), path, (InputStream)fileInputStream);
            String uploadFileUrl = service.upload(fileItem);
            processHandler.setAndCacheErrorLogFile(uploadFileUrl);
        }
        catch (Exception e) {
            LOGGER.error("\u9519\u8bef\u65e5\u5fd7\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
            try {
                if (fileItem != null) {
                    fileItem.close();
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    private XSSFCellStyle setBorderStyle(XSSFWorkbook workbook) {
        XSSFCellStyle style = workbook.createCellStyle();
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        return style;
    }

    private CellStyle getWarnTextStyle(XSSFWorkbook workbook) {
        XSSFFont font = workbook.createFont();
        font.setColor((short)10);
        XSSFCellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setFont((Font)font);
        return cellStyle;
    }

    private void invokeAfterImport() {
        List<Map<Integer, String>> dataHead = this.getDataHead();
        EntryProgressHandler processHandler = this.getImportContext().getProcessHandler();
        List<IDataPort> importServices = this.getImportContext().getImportServices();
        DataImportEvent event = new DataImportEvent(this, dataHead, Collections.emptyList());
        event.setProcessHandler(processHandler);
        event.setImportContext(this.getImportContext());
        event.setFilePath(this.getImportContext().getImportFileUrl());
        for (IDataPort plugin : importServices) {
            plugin.afterImport(event);
        }
    }
}

