/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.schedule.executor.AbstractTask;
import kd.hr.hbp.business.bgtask.CommonBizTask;
import kd.swc.hsbp.business.export.SWCExportEntryHelper;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.common.entity.EntryColumnWrapper;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.EntryImportStarter;
import kd.swc.hsbp.formplugin.imports.EntryProgressHandler;
import kd.swc.hsbp.formplugin.imports.IDataPort;
import kd.swc.hsbp.formplugin.imports.event.OnGetImportConfigEvent;
import org.apache.commons.collections.CollectionUtils;

public class EntryImportTask
extends CommonBizTask {
    private static final Log LOGGER = LogFactory.getLog(EntryImportTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        EntryImportContext importContext = new EntryImportContext();
        EntryImportStarter importStart = new EntryImportStarter(importContext);
        try {
            LOGGER.info("EntryImportTask_execute(),map:{}", map);
            this.initImportContext(importStart, requestContext, map);
            importStart.start();
        }
        catch (Throwable var9) {
            LOGGER.error("BigExcelImportTask_recievered_Exception", var9);
            importStart.end();
            importStart.writeErrorLog(var9);
            throw new KDException(new ErrorCode("001", "BigExcelImportTask_start failed."), "", var9);
        }
        finally {
            this.endProgress(importContext);
        }
    }

    private void endProgress(EntryImportContext importContext) {
        this.feedbackProgress(100);
        boolean hasError = CollectionUtils.isNotEmpty(importContext.getProcessHandler().getErrorLogCache());
        importContext.getProcessHandler().endProgress(hasError);
    }

    private void initImportContext(EntryImportStarter importStart, RequestContext requestContext, Map<String, Object> map) {
        RequestContext context;
        EntryImportContext importContext = importStart.getImportContext();
        importContext.setTaskid(this.taskId);
        Object sourceRc = map.get("requestContext");
        if (sourceRc instanceof RequestContext) {
            RequestContext.set((RequestContext)((RequestContext)sourceRc));
        } else if (sourceRc != null && (context = (RequestContext)JSONObject.parseObject((String)sourceRc.toString(), RequestContext.class)) != null) {
            RequestContext.set((RequestContext)context);
        }
        RequestContextThreadBinder.bind((RequestContext)RequestContext.get());
        LOGGER.info("BigExcelImportTask_started!trace_id={},map={}", (Object)RequestContext.get().getTraceId(), (Object)JSONObject.toJSONString(map));
        importContext.setRc(RequestContext.get());
        importContext.setProcessHandler(new EntryProgressHandler(importContext));
        importContext.setAppId((String)map.get("ServiceAppId"));
        importContext.setEntryPageId((String)map.get("entryview"));
        importContext.setEntryKey((String)map.get("entrykey"));
        importContext.setEntryName((String)map.get("entityname"));
        importContext.setImportFileUrl((String)map.get("importfile_url"));
        importContext.setImportType((String)map.get("importtype"));
        importContext.setTask((AbstractTask)this);
        importContext.setEntryView(SessionManager.getCurrent().getView((String)map.get("entryview")));
        this.initDataPortService(importContext);
        this.initImportConfig(importContext);
    }

    private void initImportConfig(EntryImportContext importContext) {
        OnGetImportConfigEvent event = new OnGetImportConfigEvent((Object)this);
        event.setImportConfig(new ImportConfig());
        for (IDataPort dataPort : importContext.getImportServices()) {
            dataPort.onGetImportConfig(event);
        }
        event.setImportContext(importContext);
        importContext.setImportConfig(event.getImportConfig());
        this.setEntryHeadHeight(event.getImportConfig(), importContext);
    }

    private void setEntryHeadHeight(ImportConfig importConfig, EntryImportContext importContext) {
        if (importConfig.getHeadHeight() > 0) {
            return;
        }
        String entryKey = importContext.getEntryKey();
        IFormView entryView = SessionManager.getCurrent().getView(importContext.getEntryPageId());
        EntryColumnWrapper wrapper = SWCExportEntryHelper.readEntryColumnInfo((IFormView)entryView, (String)entryKey);
        int height = SWCExportEntryHelper.calcSheetHeadHeight((List)wrapper.getContainers());
        importConfig.setHeadHeight(height);
    }

    private void initDataPortService(EntryImportContext importContext) {
        FormViewPluginProxy service = (FormViewPluginProxy)importContext.getEntryView().getService(FormViewPluginProxy.class);
        ArrayList dataPortPlugins = Lists.newArrayListWithExpectedSize((int)service.getPlugIns().size());
        for (IFormPlugin plugIn : service.getPlugIns()) {
            if (!(plugIn instanceof IDataPort)) continue;
            dataPortPlugins.add((IDataPort)plugIn);
        }
        importContext.setImportServices(dataPortPlugins);
    }
}

