/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.imports;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.olap.util.IntHolder;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.business.export.entity.ImportConfig;
import kd.swc.hsbp.formplugin.imports.EntryImportContext;
import kd.swc.hsbp.formplugin.imports.EntryImportStarter;
import kd.swc.hsbp.formplugin.imports.EntryProgressHandler;

public class ExcelParser
implements Callable {
    private static final Log log = LogFactory.getLog(ExcelParser.class);
    private EntryImportStarter entryImportStarter;

    public ExcelParser(EntryImportStarter entryImportStarter) {
        this.entryImportStarter = entryImportStarter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call() throws Exception {
        final EntryImportContext importContext = this.entryImportStarter.getImportContext();
        ImportConfig importConfig = importContext.getImportConfig();
        String url = importContext.getImportFileUrl();
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new KDBizException("url not exist");
        }
        FileService service = FileServiceFactory.getAttachmentFileService();
        final ArrayList dataHead = Lists.newArrayListWithCapacity((int)importConfig.getHeadHeight());
        final int headEndHeight = this.getEntryHeadEndHeight(importConfig.getHeadHeight());
        importContext.setHeadEndRowNum(headEndHeight);
        final IntHolder lastDataRowNumHolder = new IntHolder(-1);
        try (InputStream in = service.getInputStream(url);){
            new ExcelReader().read(in, new SheetHandler(){

                public void handleRow(SheetHandler.ParsedRow row) {
                    if (row.getRowNum() < EntryImportContext.FIX_HEAD_HEIGHT - 1) {
                        return;
                    }
                    if (row.getRowNum() <= headEndHeight) {
                        dataHead.add(row.getData());
                    } else {
                        int rowStep;
                        EntryProgressHandler processHandler = importContext.getProcessHandler();
                        if (ExcelParser.this.entryImportStarter.getDataHead() == null) {
                            ExcelParser.this.entryImportStarter.setDataHead(dataHead);
                            int actureTotalRow = this.getRowCount() - (headEndHeight + 1);
                            importContext.setTotalRows(actureTotalRow);
                            processHandler.setTotal(actureTotalRow);
                            processHandler.cacheData();
                        }
                        if (lastDataRowNumHolder.value == -1) {
                            lastDataRowNumHolder.value = row.getRowNum();
                        }
                        if ((rowStep = row.getRowNum() - lastDataRowNumHolder.value) >= 2) {
                            processHandler.setEmptyRow(processHandler.getEmptyRow() + rowStep - 1);
                            processHandler.setTotal(processHandler.getTotal() - (rowStep - 1));
                            importContext.setEmptyRows(processHandler.getEmptyRow());
                        }
                        lastDataRowNumHolder.value = row.getRowNum();
                        try {
                            if (!row.isEmpty()) {
                                row.getData().put(EntryImportContext.EXCEL_ROW_NUMBER, String.valueOf(row.getRowNum()));
                                ExcelParser.this.entryImportStarter.getDataQueues().offer(row.getData(), 300L, TimeUnit.SECONDS);
                            } else {
                                processHandler.setEmptyRow(processHandler.getEmptyRow() + 1);
                                importContext.setEmptyRows(processHandler.getEmptyRow());
                                processHandler.setTotal(processHandler.getTotal() - 1);
                            }
                        }
                        catch (InterruptedException e) {
                            log.error(e.getCause());
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            importContext.getProcessHandler().cacheData();
            this.entryImportStarter.setExcelReaderEnd(true);
        }
        catch (Throwable e) {
            log.error(e);
            this.entryImportStarter.writeErrorLog(e);
            this.entryImportStarter.setDataProcessStop(true);
        }
        finally {
            this.entryImportStarter.notifyWhenEnd();
        }
        return null;
    }

    private int getEntryHeadEndHeight(int entryHeight) {
        return entryHeight + EntryImportContext.FIX_HEAD_HEIGHT - 1;
    }

    public EntryImportStarter getEntryImportStarter() {
        return this.entryImportStarter;
    }

    public void setEntryImportStarter(EntryImportStarter entryImportStarter) {
        this.entryImportStarter = entryImportStarter;
    }
}

