/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.report;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.swc.hsbp.business.report.ReportTplHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.RptDisplayConstants;

public class RptDisplaySchemeColumnSortPlugin
extends AbstractBillPlugIn
implements SearchEnterListener,
RptDisplayConstants {
    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addClickListeners(new String[]{"btn_add", "btn_remove", "btn_confirm"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Search search = (Search)this.getView().getControl("searchap");
        if (search != null) {
            search.addEnterListener((SearchEnterListener)this);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        this.buildTree();
        this.buildTable();
    }

    private void buildTree() {
        DynamicObjectCollection entryColl = this.getEntryEntity();
        if (entryColl == null) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        TreeNode rootNode = this.getRootNode();
        treeView.addNode(rootNode);
        List<TreeNode> treeNodes = entryColl.stream().filter(entryObj -> !entryObj.getString("fieldvalue").startsWith("A")).map(entryObj -> {
            String fieldVal = entryObj.getString("fieldvalue");
            String fieldName = entryObj.getString("fieldname");
            TreeNode treeNode = new TreeNode("root", fieldVal, fieldName);
            treeNode.setLeaf(true);
            return treeNode;
        }).collect(Collectors.toList());
        rootNode.addChildren(treeNodes);
        HashMap treeNodeTableRowMap = Maps.newHashMapWithExpectedSize((int)16);
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        HashMap treeNodeMap = Maps.newHashMapWithExpectedSize((int)treeNodes.size());
        ArrayList checkNodes = Lists.newArrayListWithExpectedSize((int)10);
        treeNodes.forEach(treeNode -> {
            treeNodeMap.put(treeNode.getId(), treeNode);
            if (treeNodeTableRowMap.containsKey(treeNode.getId())) {
                checkNodes.add(treeNode);
            }
        });
        treeView.addNodes(treeNodes);
        swcPageCache.put("CACHE_TREE_DATA", (Object)treeNodeMap);
        ArrayList<TreeNode> rootNodes = new ArrayList<TreeNode>(10);
        rootNodes.add(rootNode);
        swcPageCache.put("CACHE_ROOT_NODE", (Object)SerializationUtils.serializeToBase64(rootNodes));
    }

    private void buildTreeNodeBindTableRowMap(Map<String, Integer> treeNodeTableRowMap, SWCPageCache pageCache, List<DynamicObject> entryColl) {
        pageCache.remove("CACHE_CHECK");
        treeNodeTableRowMap.clear();
        for (int i = 0; i < entryColl.size(); ++i) {
            DynamicObject dyObj = entryColl.get(i);
            String nodeid = dyObj.getString("fieldvalue");
            treeNodeTableRowMap.put(nodeid, i);
        }
        pageCache.put("CACHE_CHECK", treeNodeTableRowMap);
    }

    private void buildTable() {
        DynamicObjectCollection entryColl = this.getEntryEntity();
        if (entryColl == null) {
            return;
        }
        List<DynamicObject> sortedEntryColl = entryColl.stream().filter(entryObj -> !"0".equals(entryObj.getString("sort"))).sorted(Comparator.comparing(entryObj -> entryObj.getInt("sort"))).collect(Collectors.toList());
        HashMap treeNodeTableRowMap = Maps.newHashMapWithExpectedSize((int)16);
        SWCPageCache swcPageCache = new SWCPageCache(this.getView());
        this.buildTreeNodeBindTableRowMap(treeNodeTableRowMap, swcPageCache, sortedEntryColl);
        if (sortedEntryColl.size() == 0) {
            return;
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.batchCreateNewEntryRow("entryentity", sortedEntryColl.size());
        int index = 0;
        for (DynamicObject entryObj2 : sortedEntryColl) {
            String fieldVal = entryObj2.getString("fieldvalue");
            String fieldName = entryObj2.getString("fieldname");
            String sort = entryObj2.getString("sort");
            String sortType = entryObj2.getString("sorttype");
            model.setValue("fieldvalue", (Object)fieldVal, index);
            model.setValue("fieldname", (Object)fieldName, index);
            model.setValue("sort", (Object)sort, index);
            model.setValue("sorttype", (Object)sortType, index);
            ++index;
        }
        this.getModel().setDataChanged(false);
    }

    private DynamicObjectCollection getEntryEntity() {
        IFormView formView = this.getView().getParentView();
        if (formView == null) {
            return null;
        }
        DynamicObjectCollection entryEntity = formView.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection noItemFields = new DynamicObjectCollection();
        for (DynamicObject fieldDyn : entryEntity) {
            String fieldAlias = fieldDyn.getString("fieldalias");
            if (fieldAlias.startsWith("item")) continue;
            noItemFields.add((Object)fieldDyn);
        }
        return noItemFields;
    }

    private TreeNode getRootNode() {
        String rootNodeRes = ResManager.loadKDString((String)"\u5b57\u6bb5\u5217\u8868", (String)"RptDisplaySchemeColumnSortPlugin_0", (String)"swc-hsbp-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "root", rootNodeRes);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        ReportTplHelper.searchTreeNode((String)searchText, (IFormView)this.getView(), (boolean)true);
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btn_add": {
                this.addOperate();
                break;
            }
            case "btn_remove": {
                this.removeOperate();
                break;
            }
            case "btn_confirm": {
                this.confirmOperate();
                break;
            }
        }
    }

    private void addOperate() {
        TreeView treeView = (TreeView)this.getView().getControl("treeviewap");
        List checkedNodeIds = treeView.getTreeState().getCheckedNodeIds();
        List leftCheckedNodeIds = checkedNodeIds.stream().filter(nodeId -> !"root".equals(nodeId)).collect(Collectors.toList());
        int checkedNodeSize = leftCheckedNodeIds.size();
        if (checkedNodeSize == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"RptDisplaySchemeColumnSortPlugin_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            return;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map nodeMap = (Map)pageCache.get("CACHE_TREE_DATA", Map.class);
        Map treeNodeTableRowMap = (Map)pageCache.get("CACHE_CHECK", Map.class);
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        List selectedList = leftCheckedNodeIds.stream().filter(nodeId -> !treeNodeTableRowMap.containsKey(nodeId)).collect(Collectors.toList());
        if (selectedList.size() + entryEntity.size() > this.getMaxSortFieldCount()) {
            this.getView().showTipNotification(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e3a\u4fdd\u8bc1\u6027\u80fd\uff0c\u53ef\u9009\u62e9%s\u4e2a\u4ee5\u5185\u7684\u5b57\u6bb5\u4f5c\u4e3a\u6392\u5e8f\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RptDisplaySchemeColumnSortPlugin_2", (String)"swc-hsbp-formplugin", (Object[])new Object[0]), this.getMaxSortFieldCount()));
            return;
        }
        IDataModel model = this.getModel();
        int index = entryEntity.size();
        model.beginInit();
        for (String selectNodeId : selectedList) {
            LinkedHashMap selectNode = (LinkedHashMap)nodeMap.get(selectNodeId);
            if (selectNode == null || !"true".equals(selectNode.get("leaf").toString()) || treeNodeTableRowMap.containsKey(selectNodeId)) continue;
            int detailIndex = model.createNewEntryRow("entryentity");
            model.setValue("fieldvalue", (Object)selectNodeId, detailIndex);
            model.setValue("fieldname", selectNode.get("text"), detailIndex);
            model.setValue("sort", (Object)(detailIndex + 1), detailIndex);
            model.setValue("sorttype", (Object)"1", detailIndex);
            treeNodeTableRowMap.put(selectNodeId, detailIndex);
            ++index;
        }
        model.endInit();
        pageCache.put("CACHE_CHECK", (Object)treeNodeTableRowMap);
        this.getView().updateView("entryentity");
    }

    private void removeOperate() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Map treeNodeTableRowMap = (Map)pageCache.get("CACHE_CHECK", Map.class);
        treeNodeTableRowMap.clear();
        int index = 0;
        this.getModel().beginInit();
        for (DynamicObject entryObj : entryEntity) {
            entryObj.set("sort", (Object)(index + 1));
            treeNodeTableRowMap.put(entryObj.getString("fieldvalue"), index);
            ++index;
        }
        this.getModel().endInit();
        pageCache.put("CACHE_CHECK", (Object)treeNodeTableRowMap);
        this.getView().updateView("entryentity");
    }

    private void confirmOperate() {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity("entryentity");
        HashMap returnSortedMap = Maps.newHashMapWithExpectedSize((int)entryEntity.size());
        returnSortedMap.put("sortColumnEntryEntity", entryEntity);
        this.getView().returnDataToParent((Object)returnSortedMap);
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        switch (opKey = operate.getOperateKey()) {
            case "moveentryup": 
            case "moveentrydown": {
                IDataModel model = this.getModel();
                model.beginInit();
                DynamicObjectCollection entryentities = model.getEntryEntity("entryentity");
                ReportTplHelper.forEach((Iterable)entryentities, (index, entryObj) -> {
                    entryObj.set("sort", (Object)entryObj.getInt("seq"));
                    this.getView().updateView("sort", index.intValue());
                });
                model.endInit();
                break;
            }
        }
    }

    private int getMaxSortFieldCount() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        int maxSortFieldCount = (Integer)formShowParameter.getCustomParam("MAX_SORT_FIELD_COUNT");
        return maxSortFieldCount > 0 ? maxSortFieldCount : 5;
    }
}

