/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.form.Border;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Padding;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.relatepanel.RelatePageInfo;
import kd.swc.hsbp.business.relatepanel.SWCRelatePanelSetFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCRelatePageLeftDynamicPlugin
extends AbstractFormPlugin {
    public void initialize() {
        super.initialize();
        this.hidePartTwoPanel();
    }

    public void registerListener(EventObject eventObject) {
        this.addClickListeners(new String[]{"imgdown", "imgup"});
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        String relateEntityTypeId = (String)showParameter.getCustomParam("hsbs_entitytype_id");
        Long regionId = (Long)ObjectConverter.convert((Object)showParameter.getCustomParam("regionId"), Long.class, (boolean)true);
        FlexPanelAp headPanelAp = this.createRelatePageInfoPanelAp(relateEntityTypeId, regionId);
        HashMap<String, String> mapHead = new HashMap<String, String>();
        mapHead.put("id", "flexpanelrelateinfo");
        mapHead.put("items", (String)headPanelAp.createControl().get("items"));
        args.getItems().add(mapHead);
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormView formView = (FormView)eventObject.getSource();
        String relateEntityTypeId = (String)formView.getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        Long regionId = (Long)ObjectConverter.convert((Object)formView.getFormShowParameter().getCustomParam("regionId"), Long.class, (boolean)true);
        FlexPanelAp headPanelAp = this.createRelatePageInfoPanelAp(relateEntityTypeId, regionId);
        Container relatePanel = (Container)this.getView().getControl("flexpanelrelateinfo");
        relatePanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
        this.getView().createControlIndex(relatePanel.getItems());
    }

    public void onGetControl(OnGetControlArgs args) {
        FormView formView = (FormView)args.getSource();
        String relateEntityTypeId = (String)formView.getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        Long regionId = (Long)ObjectConverter.convert((Object)formView.getFormShowParameter().getCustomParam("regionId"), Long.class, (boolean)true);
        List pageInfoList = SWCRelatePanelSetFactory.getRelatePageInfoList((String)relateEntityTypeId, (Long)regionId);
        RelatePageInfo relatePageInfo = null;
        Label relatePagelabel = null;
        for (RelatePageInfo pageInfo : pageInfoList) {
            relatePageInfo = pageInfo;
            if (!relatePageInfo.getPageNumber().equals(args.getKey())) continue;
            relatePagelabel = new Label();
            relatePagelabel.setKey(relatePageInfo.getPageNumber());
            relatePagelabel.setView(this.getView());
            relatePagelabel.addClickListener((ClickListener)this);
            args.setControl((Control)relatePagelabel);
        }
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        String curRelatedPageName = (String)this.getView().getFormShowParameter().getCustomParam("currentRelatePage");
        Map pageIconMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageIcons");
        this.showRelatedPageInContainer(curRelatedPageName);
        this.setSelectRelatePageLabelStyle(curRelatedPageName, pageIconMap);
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            this.hidePartTwoPanel();
            Map pageIconMap = (Map)this.getView().getFormShowParameter().getCustomParam("pageIcons");
            this.setSelectRelatePageLabelStyle(curClickLabel.getKey(), pageIconMap);
            this.showRelatedPageInContainer(labelName);
            this.getPageCache().put("currentRelatePage", labelName);
        } else if (evt.getSource() instanceof Vector) {
            Vector clickImg = (Vector)evt.getSource();
            if (clickImg.getKey().equals("imgup")) {
                this.hidePartTwoPanel();
            } else if (clickImg.getKey().equals("imgdown")) {
                this.showPartTwoPanel();
            }
        }
    }

    private void setSelectRelatePageLabelStyle(String labelNumber, Map<String, String> pageIconMap) {
        ImageAp pageIconAp;
        String relateEntityTypeId = (String)this.getView().getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        RelatePageInfo relatePageInfo = null;
        LabelAp relateLabelPanelAp = null;
        FlexPanelAp relatePanelAp = null;
        Long regionId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("regionId"), Long.class, (boolean)true);
        List pageInfoList = SWCRelatePanelSetFactory.getRelatePageInfoList((String)relateEntityTypeId, (Long)regionId);
        for (RelatePageInfo pageInfo : pageInfoList) {
            relatePageInfo = pageInfo;
            if (labelNumber.equals(relatePageInfo.getPageNumber())) continue;
            relateLabelPanelAp = this.assembleRelatePageLabelAp(relatePageInfo);
            this.getView().updateControlMetadata(relateLabelPanelAp.getKey(), relateLabelPanelAp.createControl());
            relatePanelAp = this.assembleRelatePanelAp(relatePageInfo.getPageNumber() + "panel");
            relatePanelAp.getItems().add(relateLabelPanelAp);
            if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(relatePageInfo.getPageNumber())) {
                pageIconAp = this.assembleImageAp(relatePageInfo.getPageNumber(), pageIconMap);
                relatePanelAp.getItems().add(pageIconAp);
            }
            this.getView().updateControlMetadata(relatePanelAp.getKey(), relatePanelAp.createControl());
        }
        relatePageInfo = SWCRelatePanelSetFactory.getRelatePageInfo((String)relateEntityTypeId, (String)labelNumber, (Long)regionId);
        if (relatePageInfo == null) {
            return;
        }
        LabelAp selectLabelAp = this.assembleSelectRelatePageLabelAp(relatePageInfo);
        this.getView().updateControlMetadata(selectLabelAp.getKey(), selectLabelAp.createControl());
        FlexPanelAp selectFlexPanelAp = this.assembleSelectRelatePanelAp(relatePageInfo.getPageNumber() + "panel");
        selectFlexPanelAp.getItems().add(selectLabelAp);
        if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(relatePageInfo.getPageNumber())) {
            pageIconAp = this.assembleImageAp(relatePageInfo.getPageNumber(), pageIconMap);
            selectFlexPanelAp.getItems().add(pageIconAp);
        }
        this.getView().updateControlMetadata(selectFlexPanelAp.getKey(), selectFlexPanelAp.createControl());
    }

    private void showRelatedPageInContainer(String relatedPageName) {
        String originalRelatedPageName = relatedPageName;
        String relateEntityTypeId = (String)this.getView().getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        Long regionId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("regionId"), Long.class, (boolean)true);
        RelatePageInfo relatePageInfo = SWCRelatePanelSetFactory.getRelatePageInfo((String)relateEntityTypeId, (String)relatedPageName, (Long)regionId);
        String panelKey = "mainpagepanel";
        if (relatePageInfo == null) {
            return;
        }
        this.getView().getFormShowParameter().setCustomParam("currentRelatePage", (Object)relatePageInfo.getPageNumber());
        String url = relatePageInfo.getUrl();
        if (!SWCStringUtils.isEmpty((String)url)) {
            relatedPageName = url;
        }
        BaseShowParameter showParameter = null;
        switch (relatePageInfo.getPageType()) {
            case "1": {
                QFilter[] objFilterArray;
                DynamicObject[] relatePageObjArray;
                String customPKFilterStr;
                BaseShowParameter formShowParameter;
                showParameter = formShowParameter = new BaseShowParameter();
                formShowParameter.setFormId(relatedPageName);
                formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(relatedPageName);
                String currentObjId = (String)this.getView().getFormShowParameter().getCustomParam("currentObjectPKId");
                QFilter mainObjFilter = new QFilter(relatePageInfo.getMainPropName(), "=", (Object)Long.valueOf(currentObjId));
                Map customPKFilterMap = (Map)this.getView().getFormShowParameter().getCustomParam("customPKFilter");
                if (customPKFilterMap != null && (customPKFilterStr = (String)customPKFilterMap.get(relatedPageName)) != null) {
                    QFilter customPKFilter = QFilter.fromSerializedString((String)customPKFilterStr);
                    mainObjFilter.and(customPKFilter);
                }
                if ((relatePageObjArray = serviceHelper.query("id", objFilterArray = new QFilter[]{mainObjFilter})) != null && relatePageObjArray.length > 0) {
                    formShowParameter.setPkId(relatePageObjArray[0].get("id"));
                    formShowParameter.setBillStatus(BillOperationStatus.VIEW);
                    formShowParameter.setStatus(OperationStatus.VIEW);
                } else {
                    formShowParameter.setBillStatus(BillOperationStatus.ADDNEW);
                    formShowParameter.setStatus(OperationStatus.ADDNEW);
                }
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "2": {
                ListShowParameter formShowParameter = new ListShowParameter();
                showParameter = formShowParameter;
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                formShowParameter.setFormId("bos_list");
                formShowParameter.setBillFormId(relatedPageName);
                formShowParameter.setLookUp(false);
                formShowParameter.setCustomParam("type", (Object)"list");
                formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "4": {
                ListShowParameter formShowParameter = new ListShowParameter();
                showParameter = formShowParameter;
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                formShowParameter.setFormId("hsbp_cardviewtpl");
                formShowParameter.setBillFormId(relatedPageName);
                formShowParameter.setLookUp(false);
                formShowParameter.setCustomParam("type", (Object)"list");
                formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
            case "3": {
                FormShowParameter formShowParameter = new FormShowParameter();
                showParameter = formShowParameter;
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                formShowParameter.setFormId(relatedPageName);
                formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                this.getView().showForm(formShowParameter);
                break;
            }
            case "5": {
                ListShowParameter formShowParameter = new ListShowParameter();
                showParameter = formShowParameter;
                formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
                formShowParameter.getOpenStyle().setTargetKey(panelKey);
                formShowParameter.setFormId(url);
                formShowParameter.setBillFormId(originalRelatedPageName);
                formShowParameter.setLookUp(false);
                formShowParameter.setCustomParams(this.getView().getFormShowParameter().getCustomParams());
                Map customVariablesMap = (Map)this.getView().getFormShowParameter().getCustomParam("customvariables");
                String salaryFileId = (String)customVariablesMap.get("salaryfileid");
                formShowParameter.setCustomParam("salaryfileid", (Object)String.valueOf(salaryFileId));
                QFilter filter = new QFilter(relatePageInfo.getMainPropName(), "=", (Object)Long.valueOf(salaryFileId));
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
                this.getView().showForm((FormShowParameter)formShowParameter);
                break;
            }
        }
        if (showParameter != null) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("SUB_PAGE_" + originalRelatedPageName, (Object)showParameter.getPageId());
        }
    }

    private FlexPanelAp createRelatePageInfoPanelAp(String relateEntityTypeId, Long regionId) {
        String openTaxForUnitTest;
        FlexPanelAp relatePanelAp = this.assembleRelatePanelAp("relatePageflexpanellistap");
        List pageInfoList = SWCRelatePanelSetFactory.getRelatePageInfoList((String)relateEntityTypeId, (Long)regionId);
        if (this.getView() != null && (openTaxForUnitTest = (String)this.getView().getFormShowParameter().getCustomParam("openTaxForUnitTest")) != null && !TaxCalServiceHelper.getTaxCalEnableStatus().booleanValue()) {
            RelatePageInfo relatePageInfo = new RelatePageInfo("1090_S", "hsas_salarytaxfilerel", ResManager.loadKDString((String)"\u4eba\u5458\u4e2a\u7a0e\u6863\u6848", (String)"SalaryFileTaxAddNewPlugin_24", (String)"swc-hsas-formplugin", (Object[])new Object[0]), "3", "person", "", "hsas_emptaxfileinfo");
            pageInfoList.add(relatePageInfo);
        }
        this.addAllPageLabelForRelatePanel(relatePanelAp, pageInfoList);
        return relatePanelAp;
    }

    private void addAllPageLabelForRelatePanel(FlexPanelAp relatePanelAp, List<RelatePageInfo> pageInfoList) {
        RelatePageInfo pageInfo = null;
        LabelAp lblRelatePageAp = null;
        FlexPanelAp relateLabelPanelAp = null;
        Iterator<RelatePageInfo> iterator = pageInfoList.iterator();
        while (iterator.hasNext()) {
            RelatePageInfo relatePageInfo;
            pageInfo = relatePageInfo = iterator.next();
            lblRelatePageAp = this.assembleRelatePageLabelAp(pageInfo);
            relateLabelPanelAp = this.assembleRelatePanelAp(pageInfo.getPageNumber() + "panel");
            relateLabelPanelAp.getItems().add(lblRelatePageAp);
            relatePanelAp.getItems().add(relateLabelPanelAp);
        }
    }

    private ImageAp assembleImageAp(String number, Map<String, String> pageIconMap) {
        String imageKey = pageIconMap.get(number);
        ImageAp pageIconAp = new ImageAp();
        pageIconAp.setKey("pageIcon" + number);
        pageIconAp.setImgHeight("5px");
        pageIconAp.setImgWidth("5px");
        pageIconAp.setGrow(0);
        pageIconAp.setShrink(1);
        pageIconAp.setRadius("30px");
        pageIconAp.setImageKey(imageKey);
        Margin margin = new Margin();
        new Margin().setTop("6px");
        Style style = new Style();
        style.setMargin(margin);
        pageIconAp.setStyle(style);
        pageIconAp.setClickable(true);
        return pageIconAp;
    }

    private FlexPanelAp assembleRelatePanelAp(String relatePanelName) {
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey(relatePanelName);
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("row");
        relatePanelAp.setAlignItems("flex-start");
        relatePanelAp.setJustifyContent("flex-start");
        relatePanelAp.setHeight(new LocaleString("34px"));
        Style style = new Style();
        Border border = new Border();
        style.setBorder(border);
        relatePanelAp.setStyle(style);
        relatePanelAp.setBackColor("#ffffff");
        return relatePanelAp;
    }

    private FlexPanelAp assembleSelectRelatePanelAp(String relatePanelName) {
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey(relatePanelName);
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("row");
        relatePanelAp.setAlignItems("flex-start");
        relatePanelAp.setJustifyContent("flex-start");
        relatePanelAp.setHeight(new LocaleString("40px"));
        relatePanelAp.setWidth(new LocaleString("100%"));
        Style style = new Style();
        Border border = new Border();
        String borderStyle = "2px_solid_themeColor";
        border.setLeft(borderStyle);
        style.setBorder(border);
        relatePanelAp.setStyle(style);
        relatePanelAp.setBackColor("themeColor|10");
        return relatePanelAp;
    }

    private LabelAp assembleRelatePageLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = this.assembleBaseLabelAp(relatePageInfo);
        lblRelatePageAp.setForeColor("#333333");
        Style style = new Style();
        Border border = new Border();
        style.setBorder(border);
        Padding padding = new Padding();
        padding.setLeft("20px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setTop("10px");
        style.setMargin(margin);
        lblRelatePageAp.setStyle(style);
        return lblRelatePageAp;
    }

    private LabelAp assembleSelectRelatePageLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = this.assembleBaseLabelAp(relatePageInfo);
        lblRelatePageAp.setForeColor("themeColor");
        Style style = new Style();
        Padding padding = new Padding();
        padding.setLeft("16px");
        style.setPadding(padding);
        Margin margin = new Margin();
        margin.setTop("10px");
        style.setMargin(margin);
        lblRelatePageAp.setStyle(style);
        return lblRelatePageAp;
    }

    private LabelAp assembleBaseLabelAp(RelatePageInfo relatePageInfo) {
        LabelAp lblRelatePageAp = new LabelAp();
        lblRelatePageAp.setId(relatePageInfo.getPageNumber());
        lblRelatePageAp.setKey(relatePageInfo.getPageNumber());
        lblRelatePageAp.setName(new LocaleString(relatePageInfo.getPageName()));
        lblRelatePageAp.setFontSize(14);
        lblRelatePageAp.setClickable(true);
        return lblRelatePageAp;
    }

    private void showPartTwoPanel() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelparttwo"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpaneldownarrow"});
    }

    private void hidePartTwoPanel() {
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelparttwo"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpaneldownarrow"});
    }
}

