/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.ImageAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.relatepanel.RelatePageInfo;
import kd.swc.hsbp.business.relatepanel.SWCRelatePanelSetFactory;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCRelatePageRightDynamicPlugin
extends AbstractFormPlugin {
    private static Log log = LogFactory.getLog(SWCRelatePageRightDynamicPlugin.class);

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        FormShowParameter showParameter = (FormShowParameter)args.getSource();
        String relateEntityTypeId = (String)showParameter.getCustomParam("hsbs_entitytype_id");
        String currentObjectPKId = (String)showParameter.getCustomParam("currentObjectPKId");
        Map pageIconMap = (Map)showParameter.getCustomParam("pageIcons");
        Long regionId = (Long)ObjectConverter.convert((Object)showParameter.getCustomParam("regionId"), Long.class, (boolean)true);
        if (!SWCStringUtils.isEmpty((String)relateEntityTypeId) && !SWCStringUtils.isEmpty((String)currentObjectPKId)) {
            FlexPanelAp headPanelAp = this.createRelatePageInfoPanelAp(relateEntityTypeId, pageIconMap, regionId);
            HashMap<String, String> mapHead = new HashMap<String, String>();
            mapHead.put("id", "flexpanelrelateinfo");
            mapHead.put("items", (String)headPanelAp.createControl().get("items"));
            args.getItems().add(mapHead);
        }
    }

    public void beforeBindData(EventObject eventObject) {
        super.beforeBindData(eventObject);
        FormView formView = (FormView)eventObject.getSource();
        String relateEntityTypeId = (String)formView.getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        Long regionId = (Long)ObjectConverter.convert((Object)formView.getFormShowParameter().getCustomParam("regionId"), Long.class, (boolean)true);
        if (!SWCStringUtils.isEmpty((String)relateEntityTypeId)) {
            FlexPanelAp headPanelAp = this.createRelatePageInfoPanelAp(relateEntityTypeId, null, regionId);
            Container relatePanel = (Container)this.getView().getControl("flexpanelrelateinfo");
            relatePanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
            this.getView().createControlIndex(relatePanel.getItems());
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        switch (args.getOperateKey()) {
            case "save": 
            case "saveandnew": {
                BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
                DynamicObject currentDynObj = this.getModel().getDataEntity();
                baseShowParameter.setPkId((Object)currentDynObj.getLong("id"));
                break;
            }
        }
    }

    public void onGetControl(OnGetControlArgs args) {
        FormView baseView = (FormView)args.getSource();
        String relateEntityTypeId = (String)baseView.getFormShowParameter().getCustomParam("hsbs_entitytype_id");
        Long regionId = (Long)ObjectConverter.convert((Object)this.getView().getFormShowParameter().getCustomParam("regionId"), Long.class, (boolean)true);
        if (!SWCStringUtils.isEmpty((String)relateEntityTypeId)) {
            List pageInfoList = SWCRelatePanelSetFactory.getRelatePageInfoList((String)relateEntityTypeId, (Long)regionId);
            RelatePageInfo relatePageInfo = null;
            Label relatePagelabel = null;
            int size = pageInfoList.size();
            for (int i = 0; i < size; ++i) {
                relatePageInfo = (RelatePageInfo)pageInfoList.get(i);
                if (!relatePageInfo.getPageNumber().equals(args.getKey())) continue;
                relatePagelabel = new Label();
                relatePagelabel.setKey(relatePageInfo.getPageNumber());
                relatePagelabel.setView(this.getView());
                relatePagelabel.addClickListener((ClickListener)this);
                args.setControl((Control)relatePagelabel);
            }
        }
    }

    public void click(EventObject evt) {
        if (evt.getSource() instanceof Label) {
            Label curClickLabel = (Label)evt.getSource();
            String labelName = curClickLabel.getKey();
            this.showRelatedPage(labelName);
        }
    }

    protected void showRelatedPage(String currentRelatePageName) {
        String currentObjectPKId = null;
        IFormView view = this.getView();
        FormShowParameter formShowParameter = view.getFormShowParameter();
        if (formShowParameter instanceof BaseShowParameter) {
            BaseShowParameter baseShowParameter = (BaseShowParameter)formShowParameter;
            currentObjectPKId = baseShowParameter.getPkId().toString();
        } else {
            currentObjectPKId = (String)formShowParameter.getCustomParam("currentObjectPKId");
        }
        String reateEntityTypeId = (String)formShowParameter.getCustomParam("hsbs_entitytype_id");
        String caption = (String)formShowParameter.getCustomParam("caption");
        Map pageIconMap = (Map)formShowParameter.getCustomParam("pageIcons");
        Map customVariablesMap = (Map)formShowParameter.getCustomParam("customvariables");
        log.info("20210526 file emppos error of SWCRelatePageRightDynamicPlugin.customVariablesMap : {}", (Object)customVariablesMap);
        Map customPKFilterMap = (Map)formShowParameter.getCustomParam("customPKFilter");
        FormShowParameter pageFormShowParameter = new FormShowParameter();
        pageFormShowParameter.setCustomParam("currentRelatePage", (Object)currentRelatePageName);
        pageFormShowParameter.setCustomParam("currentObjectPKId", (Object)currentObjectPKId);
        pageFormShowParameter.setCustomParam("hsbs_entitytype_id", (Object)reateEntityTypeId);
        pageFormShowParameter.setCustomParam("pageIcons", (Object)pageIconMap);
        pageFormShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        pageFormShowParameter.setCustomParam("customvariables", (Object)customVariablesMap);
        pageFormShowParameter.setCustomParam("customPKFilter", (Object)customPKFilterMap);
        pageFormShowParameter.setCustomParam("regionId", formShowParameter.getCustomParam("regionId"));
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_entitytype");
        QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(reateEntityTypeId));
        QFilter[] idFilterArray = new QFilter[]{idFilter};
        DynamicObject entityTypeDynamicObj = serviceHelper.queryOne("id,name,relatepageinfo", idFilterArray);
        String relatePageName = entityTypeDynamicObj.getDynamicObject("relatepageinfo").getString("number");
        pageFormShowParameter.setFormId(relatePageName);
        if (!SWCStringUtils.isEmpty((String)caption)) {
            pageFormShowParameter.setCaption(caption);
        }
        view.showForm(pageFormShowParameter);
    }

    private FlexPanelAp createRelatePageInfoPanelAp(String relateEntityTypeId, Map<String, String> pageIconMap, Long regionId) {
        FlexPanelAp relatePanelAp = this.assembleRelatePanelAp();
        List pageInfoList = SWCRelatePanelSetFactory.getRelatePageInfoList((String)relateEntityTypeId, (Long)regionId);
        this.filterByPerm(pageInfoList);
        this.addAllPagePanels(relatePanelAp, pageInfoList, pageIconMap);
        return relatePanelAp;
    }

    private void filterByPerm(List<RelatePageInfo> pageInfoList) {
        Long userId = RequestContext.get().getCurrUserId();
        Iterator<RelatePageInfo> it = pageInfoList.iterator();
        while (it.hasNext()) {
            RelatePageInfo pageInfo = it.next();
            boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)pageInfo.getPageNumber(), (String)"47150e89000000ac");
            if (hasPerm) continue;
            it.remove();
        }
    }

    private void addAllPagePanels(FlexPanelAp relatePanelAp, List<RelatePageInfo> pageInfoList, Map<String, String> pageIconMap) {
        RelatePageInfo pageInfo = null;
        LabelAp lblRelatePageAp = null;
        Style topStyle = this.assembleRelateLableTopStyle();
        int size = pageInfoList.size();
        for (int i = 0; i < size; ++i) {
            FlexPanelAp pagePanelAp = this.assemblePagePanelAp(i);
            pageInfo = pageInfoList.get(i);
            lblRelatePageAp = this.assembleRelatePageLabelAp(pageInfo);
            pagePanelAp.getItems().add(lblRelatePageAp);
            lblRelatePageAp.setStyle(topStyle);
            if (pageIconMap != null && !pageIconMap.isEmpty() && pageIconMap.containsKey(pageInfo.getPageNumber())) {
                ImageAp pageIconAp = this.assembleImageAp(pageInfo.getPageNumber(), pageIconMap);
                pagePanelAp.getItems().add(pageIconAp);
            }
            relatePanelAp.getItems().add(pagePanelAp);
        }
    }

    private FlexPanelAp assemblePagePanelAp(int index) {
        FlexPanelAp pagePanelAp = new FlexPanelAp();
        pagePanelAp.setKey("pagepanelap" + index);
        pagePanelAp.setWrap(true);
        pagePanelAp.setDirection("row");
        pagePanelAp.setAlignContent("flex-start");
        pagePanelAp.setAlignItems("flex-start");
        pagePanelAp.setJustifyContent("center");
        return pagePanelAp;
    }

    private FlexPanelAp assembleRelatePanelAp() {
        FlexPanelAp relatePanelAp = new FlexPanelAp();
        relatePanelAp.setKey("relatePageflexpanellistap");
        relatePanelAp.setWrap(true);
        relatePanelAp.setDirection("column");
        relatePanelAp.setAlignContent("flex-start");
        relatePanelAp.setAlignItems("flex-start");
        relatePanelAp.setJustifyContent("center");
        return relatePanelAp;
    }

    private Style assembleRelateLableTopStyle() {
        Margin margin = new Margin();
        margin.setBottom("22px");
        Style style = new Style();
        style.setMargin(margin);
        return style;
    }

    private LabelAp assembleRelatePageLabelAp(RelatePageInfo pageInfo) {
        LabelAp lblRelatePageAp = new LabelAp();
        lblRelatePageAp.setId(pageInfo.getPageNumber());
        lblRelatePageAp.setKey(pageInfo.getPageNumber());
        lblRelatePageAp.setName(new LocaleString(pageInfo.getPageName()));
        lblRelatePageAp.setFontSize(14);
        lblRelatePageAp.setClickable(true);
        return lblRelatePageAp;
    }

    private ImageAp assembleImageAp(String number, Map<String, String> pageIconMap) {
        String imageKey = pageIconMap.get(number);
        ImageAp pageIconAp = new ImageAp();
        pageIconAp.setKey("pageIcon" + number);
        pageIconAp.setImgHeight("5px");
        pageIconAp.setImgWidth("5px");
        pageIconAp.setGrow(0);
        pageIconAp.setShrink(1);
        pageIconAp.setRadius("30px");
        pageIconAp.setImageKey(imageKey);
        pageIconAp.setClickable(true);
        return pageIconAp;
    }
}

