/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web.file;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.events.LoadCustomControlMetasArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.mvc.form.FormView;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.control.HRFlexPanelAp;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.file.FileDefaultEmptyPage;
import kd.swc.hsbp.formplugin.web.file.FileDefaultEmptyPageEnum;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractFileDetailDisplayPlugin
extends AbstractFormPlugin {
    protected String entityName;
    protected String fileDetailFormKey;
    protected String fileDetailFormId;
    protected String fileDetailFlexKey;
    protected String fileDetailFlexId;

    public void initParam() {
    }

    private boolean checkParam() {
        return !SWCStringUtils.isEmpty((String)this.entityName) && !SWCStringUtils.isEmpty((String)this.fileDetailFormKey) && !SWCStringUtils.isEmpty((String)this.fileDetailFormId) && !SWCStringUtils.isEmpty((String)this.fileDetailFlexKey) && !SWCStringUtils.isEmpty((String)this.fileDetailFlexId);
    }

    public void loadCustomControlMetas(LoadCustomControlMetasArgs args) {
        super.loadCustomControlMetas(args);
        this.initParam();
        if (!this.checkParam()) {
            return;
        }
        List<Map> allItems = this.getAllPanelItems();
        HashMap<String, Object> dynamicPanelMap = new HashMap<String, Object>(16);
        dynamicPanelMap.put("id", this.fileDetailFlexKey);
        dynamicPanelMap.put("items", allItems);
        args.getItems().add(dynamicPanelMap);
    }

    @NotNull
    private List<Map> getAllPanelItems() {
        String flexId;
        FlexPanelAp headPanelApExists = (FlexPanelAp)((FormMetadata)MetadataDao.readRuntimeMeta((String)this.fileDetailFormId, (MetaCategory)MetaCategory.Form)).getItem(this.fileDetailFlexId);
        List itemExists = (List)headPanelApExists.createControl().get("items");
        FlexPanelAp extPanelAp = this.createSiderPageInfoPanelAp(null);
        List extItems = (List)extPanelAp.createControl().get("items");
        HashSet<String> itemExistKeys = new HashSet<String>(16);
        for (Map conf : extItems) {
            itemExistKeys.add(String.valueOf(conf.get("id")));
        }
        ArrayList<Map> allItems = new ArrayList<Map>(10);
        HashMap<String, Map> existsFlexMap = new HashMap<String, Map>(16);
        for (Map metaItem : itemExists) {
            flexId = String.valueOf(metaItem.get("id"));
            if (!itemExistKeys.contains(flexId)) {
                allItems.add(metaItem);
                continue;
            }
            existsFlexMap.put(flexId, metaItem);
        }
        for (Map conf : extItems) {
            flexId = String.valueOf(conf.get("id"));
            Map existsFlex = (Map)existsFlexMap.get(flexId);
            if (existsFlex != null) {
                allItems.add(existsFlex);
                continue;
            }
            allItems.add(conf);
        }
        return allItems;
    }

    public void beforeBindData(EventObject e) {
        DynamicObject fileDyobj;
        super.beforeBindData(e);
        this.initParam();
        if (!this.checkParam()) {
            return;
        }
        FormView formView = (FormView)e.getSource();
        FlexPanelAp headPanelAp = this.createSiderPageInfoPanelAp(false);
        Container relatePanel = (Container)formView.getControl(this.fileDetailFlexKey);
        relatePanel.getItems().addAll(((Container)headPanelAp.buildRuntimeControl()).getItems());
        formView.createControlIndex(relatePanel.getItems());
        String fileId = (String)this.getView().getFormShowParameter().getCustomParam("key_custom_param_fileid");
        String salaryFileId = (String)this.getView().getFormShowParameter().getCustomParam("salaryfileid");
        if (SWCStringUtils.isEmpty((String)fileId)) {
            fileId = salaryFileId;
        }
        if (null != (fileDyobj = this.getFileDyobj(fileId))) {
            this.refreshFileShowParam(fileDyobj);
            this.embedAllChildPage(fileDyobj);
        }
    }

    private void embedAllChildPage(DynamicObject fileDyobj) {
        DynamicObject[] confArr;
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("status", (Object)fileDyobj.getString("status"));
        HashMap<String, String> pageIds = (HashMap<String, String>)pageCache.get("pageids", Map.class);
        if (pageIds == null) {
            pageIds = new HashMap<String, String>();
        }
        HashMap<String, Long> fileRelatedPkIds = new HashMap<String, Long>();
        this.addFileRelatedPkIds(fileRelatedPkIds, fileDyobj);
        Map<String, Object> customParams = this.getCustomParams(fileDyobj);
        for (DynamicObject conf : confArr = this.querySalaryFileRelatedExtConfig()) {
            String pageNumber = conf.getString("pagenumber");
            String showType = conf.getString("showtype");
            String pageEmbedFlexKey = conf.getString("pageembedflexkey");
            Boolean isHide = conf.getBoolean("ishide");
            if (isHide.booleanValue()) {
                if (!SWCStringUtils.isNotEmpty((String)pageEmbedFlexKey)) continue;
                this.getView().setVisible(Boolean.FALSE, new String[]{pageEmbedFlexKey});
                continue;
            }
            Boolean isSelfEmbedPpage = conf.getBoolean("isselfembedpage");
            if (isSelfEmbedPpage == null || isSelfEmbedPpage.booleanValue()) continue;
            boolean hasPerm = this.checkPermission("47150e89000000ac", pageNumber);
            if (!hasPerm) {
                this.getView().setVisible(Boolean.FALSE, new String[]{pageEmbedFlexKey});
                continue;
            }
            if ("1".equals(showType)) {
                this.embedChildPage(pageNumber, fileRelatedPkIds, pageIds, customParams, conf);
            }
            if (!"2".equals(showType)) continue;
            this.embedListChildPage(fileDyobj, pageIds, customParams, pageNumber, conf);
        }
        pageCache.put("pageids", pageIds);
    }

    private void setParentAdvCollapsible(IFormView formView, String flexKey, Boolean collapsible) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>(1);
        map.put("collapsible", collapsible);
        formView.updateControlMetadata(flexKey, map);
    }

    private void embedListChildPage(DynamicObject salaryFileDyobj, Map<String, String> pageIds, Map<String, Object> customParams, String pageNumber, DynamicObject conf) {
        if (conf == null) {
            return;
        }
        this.setParentAdvCollapsible(this.getView(), conf.getString("pageembedflexkey"), Boolean.TRUE);
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        String listFormId = conf.getString("listformid");
        if (SWCStringUtils.isEmpty((String)listFormId)) {
            listFormId = "hsbp_nosearch_list";
        }
        showParameter.setFormId(listFormId);
        showParameter.setBillFormId(pageNumber);
        showParameter.getOpenStyle().setTargetKey(conf.getString("pageembedflexkey"));
        String baseEntityId = conf.getString("pagenumber");
        String dataQueryType = conf.getString("dataquerytype");
        String mainPropKey = conf.getString("mainpropkey");
        if (SWCStringUtils.isEmpty((String)mainPropKey) && "1".equals(dataQueryType)) {
            mainPropKey = SWCBaseDataHelper.getEntityPropKey((String)baseEntityId, (String)this.entityName);
        }
        if (SWCStringUtils.isEmpty((String)mainPropKey)) {
            return;
        }
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        if ("1".equals(dataQueryType)) {
            filter.and(mainPropKey, "=", (Object)salaryFileDyobj.getLong("boid"));
        } else if ("2".equals(dataQueryType)) {
            filter.and(mainPropKey, "=", (Object)salaryFileDyobj.getLong("employee.id"));
        } else if ("3".equals(dataQueryType)) {
            filter.and(mainPropKey, "=", (Object)salaryFileDyobj.getLong("person.id"));
        }
        ListFilterParameter listFilter = showParameter.getListFilterParameter();
        listFilter.setFilter(filter);
        showParameter.setCustomParams(customParams);
        showParameter.setSendToClient(true);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
        pageIds.put(pageNumber, showParameter.getPageId());
    }

    private void embedChildPage(String pageNumber, Map<String, Long> salaryFileRelatedPkIds, Map<String, String> pageIds, Map<String, Object> customParams, DynamicObject conf) {
        Long relatedPkId;
        String flexNumber = conf.getString("pageembedflexkey");
        if (SWCStringUtils.isEmpty((String)flexNumber)) {
            flexNumber = pageNumber;
        }
        if (null != (relatedPkId = salaryFileRelatedPkIds.get(pageNumber))) {
            if (relatedPkId.compareTo(0L) == 0) {
                this.showDefaultEmptyPage(customParams, pageNumber, flexNumber);
            } else {
                String pageId = this.asyncEmbedPage(flexNumber, pageNumber, relatedPkId, customParams);
                pageIds.put(pageNumber, pageId);
            }
        } else {
            this.showDefaultEmptyPage(customParams, pageNumber, flexNumber);
        }
    }

    private String asyncEmbedPage(String targetKey, String pageNumber, Long pkId, Map<String, Object> customParams) {
        this.setParentAdvCollapsible(this.getView(), targetKey, Boolean.FALSE);
        BaseShowParameter showParameter = new BaseShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setFormId(pageNumber);
        showParameter.setCustomParams(customParams);
        showParameter.setSendToClient(true);
        if (null != pkId && !pkId.equals(0L)) {
            showParameter.setPkId((Object)pkId);
            showParameter.setStatus(OperationStatus.VIEW);
        }
        this.getView().showForm((FormShowParameter)showParameter);
        return showParameter.getPageId();
    }

    private void showDefaultEmptyPage(Map<String, Object> customParams, String pageNumber, String targetFlex) {
        this.setParentAdvCollapsible(this.getView(), targetFlex, Boolean.TRUE);
        String status = (String)customParams.get("status");
        String isOnlyView = (String)customParams.get("isOnlyView");
        FileDefaultEmptyPageEnum pageType = FileDefaultEmptyPageEnum.NEW_DATA_PAGE_TYPE;
        if ("E".equals(status) || "B".equals(status) || "true".equals(isOnlyView)) {
            pageType = FileDefaultEmptyPageEnum.VIEW_DATA_PAGE_TYPE;
        }
        FileDefaultEmptyPage defaultEmptyPage = new FileDefaultEmptyPage(pageType, targetFlex, ShowType.InContainer);
        Map<String, Object> params = defaultEmptyPage.getCustomParams();
        params.put("pageNumber", pageNumber);
        params.put("targetFlex", targetFlex);
        params.putAll(customParams);
        String showMessage = FileDefaultEmptyPage.buildCardNameValue((String)customParams.get("status"), pageNumber);
        defaultEmptyPage.setShowMessage(showMessage);
        this.getView().showForm(defaultEmptyPage.getFormShowParameter());
    }

    private boolean checkPermission(String permItemId, String entityName) {
        Long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"/UHMBBGZQ65X", (String)entityName, (String)permItemId);
        return hasPerm;
    }

    protected Map<String, Object> getCustomParams(DynamicObject fileDyobj) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put("mainEntityNumber", this.entityName);
        customParams.put("mainDataId", fileDyobj.getString("id"));
        customParams.put("status", fileDyobj.getString("status"));
        String isOnlyView = (String)this.getView().getFormShowParameter().getCustomParam("isOnlyView");
        customParams.put("isOnlyView", isOnlyView);
        return customParams;
    }

    private void addFileRelatedPkIds(Map<String, Long> fileRelatedPkIds, DynamicObject fileDyobj) {
        DynamicObject[] confArr;
        for (DynamicObject conf : confArr = this.querySalaryFileRelatedExtConfig()) {
            SWCDataServiceHelper serviceHelper;
            DynamicObject dataDy;
            Boolean isSelfEmbedPpage = conf.getBoolean("isselfembedpage");
            if (isSelfEmbedPpage == null || isSelfEmbedPpage.booleanValue()) continue;
            String baseEntityId = conf.getString("pagenumber");
            String showtype = conf.getString("showtype");
            String dataQueryType = conf.getString("dataquerytype");
            if ("2".equals(showtype)) continue;
            String mainPropKey = conf.getString("mainpropkey");
            if (SWCStringUtils.isEmpty((String)mainPropKey) && "1".equals(dataQueryType)) {
                mainPropKey = SWCBaseDataHelper.getEntityPropKey((String)baseEntityId, (String)this.entityName);
            }
            if (SWCStringUtils.isEmpty((String)mainPropKey)) continue;
            QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
            if ("1".equals(dataQueryType)) {
                filter.and(mainPropKey, "=", (Object)fileDyobj.getLong("boid"));
            } else if ("2".equals(dataQueryType)) {
                filter.and(mainPropKey, "=", (Object)fileDyobj.getLong("employee.id"));
            } else if ("3".equals(dataQueryType)) {
                filter.and(mainPropKey, "=", (Object)fileDyobj.getLong("person.id"));
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)baseEntityId);
            if (dataEntityType.getProperty("iscurrentversion") != null) {
                filter.and(new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE));
                filter.and(new QFilter("datastatus", "!=", (Object)"-1"));
            }
            if ((dataDy = (serviceHelper = new SWCDataServiceHelper(baseEntityId)).queryOne(new QFilter[]{filter})) == null) continue;
            fileRelatedPkIds.put(baseEntityId, dataDy.getLong("id"));
        }
    }

    private void refreshFileShowParam(DynamicObject salaryFileDyobj) {
        this.getView().getFormShowParameter().setCustomParam("status", (Object)salaryFileDyobj.getString("status"));
        this.getView().cacheFormShowParameter();
    }

    private DynamicObject getFileDyobj(String fileId) {
        if (SWCStringUtils.isEmpty((String)fileId)) {
            return null;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(this.entityName);
        return serviceHelper.queryOne((Object)fileId);
    }

    public FlexPanelAp createSiderPageInfoPanelAp(Boolean isSelfEmbedPpage) {
        DynamicObject[] confArr = this.querySalaryFileRelatedExtConfig();
        String customStyle = "eyJ0eXBlIjowLCJjb250ZW50IjoiwqAvKiogXG4qIOagt+S+i1xuKiDmlK/mjIHljp/nlJ9jc3PmoLflvI/lhpnms5Vcbiog5b2T5YmN5YWD57Sg55qEY2xhc3NOYW1l5L2/55SoIFwiJFwiIOS7o+abv++8jOS4jeaUr+aMgeiHquWumuS5ieWFg+e0oGNsYXNzTmFtZVxuKiDnm67liY3mj5DkvpvkuInkuKrmoLfmnb/vvIzmiZPlvIDms6jph4rljbPlj6/kvb/nlKhcbiog5rOo6YeK5YaF5a655Lya6KKr6L+H5ruk5LiN5bGV56S6XG4qIOWmgumcgOS9v+eUqOW5s+WPsOS4u+mimOiJsu+8jOWPr+S7peS9v+eUqCd0aGVtZUNvbG9yJ+adpeS7o+aMh1xuICovXG4vKipcbiog5b2T5YmN5YWD57Sg6IOM5pmv6aKc6Imy6Lef6ZqP5Li76aKY6ImyXG4qL1xuLyoqXG4kIHtcbsKgwqBiYWNrZ3JvdW5kOid0aGVtZUNvbG9yJztcbsKgfVxuKi9cbsKgLyoqXG4qIOS/ruaUueW9k+WJjeWFg+e0oOiDjOaZr+minOiJslxuKi9cbi8qKlxuJCB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG7CoC8qKlxuKiDkv67mlLnlvZPliY3lhYPntKBob3ZlcuaViOaenFxuwqAgKi9cbi8qKlxuJDpob3ZlciB7XG7CoMKgYmFja2dyb3VuZDpyZWQ7XG7CoH1cbiovXG4vKipcbiAqIOS/ruaUueW9k+WJjeWFg+e0oOS4umRpduagh+etvuWtkOWFg+e0oFxuKi9cbi8qKlxuJCA+IGRpdiB7XG7CoGJhY2tncm91bmQ6cmVkO1xuwqB9XG4gKi9cbiQgPiBkaXZ7XG5cdGhlaWdodDo0MXB4O1xufVxuJCA+IGRpdjpob3Zlcntcblx0Y29sb3I6J3RoZW1lQ29sb3InIWltcG9ydGFudDtcbn1cbiQgPiBkaXYgPiBkaXZ7XG5cdG1hcmdpbi1ib3R0b206MHB4IWltcG9ydGFudDtcbn1cbiJ9";
        FlexPanelAp siderPanelAp = new HRFlexPanelAp.Builder("siderpageflexpanellistap").setWrap(true).setDirection("column").setJustifyContent("flex-start").setAlignItems("flex-start").build();
        siderPanelAp.setCustomeStyles(customStyle);
        if (null == confArr || confArr.length == 0) {
            return siderPanelAp;
        }
        boolean isNeedSave = false;
        for (DynamicObject siderItem : confArr) {
            if (isSelfEmbedPpage != null && isSelfEmbedPpage.booleanValue() != siderItem.getBoolean("isselfembedpage")) continue;
            String pageembedflexkey = siderItem.getString("pageembedflexkey");
            String showType = siderItem.getString("showtype");
            if (SWCStringUtils.isEmpty((String)pageembedflexkey)) {
                pageembedflexkey = siderItem.getString("pagenumber").replace("_", "") + "flex";
                siderItem.set("pageembedflexkey", (Object)pageembedflexkey);
                isNeedSave = true;
            }
            FlexPanelAp itemPanelAp = ((HRFlexPanelAp.Builder)new HRFlexPanelAp.Builder(pageembedflexkey).setWrap(true).setName(siderItem.getString("pageembedflexname")).setAlignItems("flex-start").setBackColor("#ffffff").setMarginBottom("10px")).setShrink(0).setGrow(0).setAlignItems("flex-start").build();
            siderPanelAp.getItems().add(itemPanelAp);
        }
        if (isNeedSave) {
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
            serviceHelper.save(confArr);
        }
        return siderPanelAp;
    }

    private Map<String, DynamicObject> querySalaryFileRelatedExtConfigMap() {
        DynamicObject[] confArr = this.querySalaryFileRelatedExtConfig();
        HashMap<String, DynamicObject> confMap = new HashMap<String, DynamicObject>(16);
        for (DynamicObject conf : confArr) {
            confMap.put(conf.getString("pagenumber"), conf);
        }
        return confMap;
    }

    private DynamicObject[] querySalaryFileRelatedExtConfig() {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("entitytype.relatepageinfo.id", "=", (Object)this.entityName);
        return serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper.getEntityName()), new QFilter[]{filter}, "index");
    }
}

