/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web.file;

import java.io.IOException;
import java.util.EventObject;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.enums.SWCHisBaseDataType;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FileBlockBaseDataCommEdit
extends AbstractBasePlugIn {
    private static final Log logger = LogFactory.getLog(FileBlockBaseDataCommEdit.class);
    private static final String ADVBAR_CANCEL = "advbar_cancel";
    private static final String ADVBAR_SAVE = "advbar_save";
    private static final String ADVBAR_MODIFY = "advbar_modify";
    private static final String EDIT = "edit";
    private static final String PKID = "pkid";
    private static final String CACHE_NO_RELEASE_MUTEX_LOCK = "noreleaseLock";

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        this.addItemClickListeners(new String[]{"advtoolbar"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "advbar_modify": {
                break;
            }
            case "advbar_cancel": {
                if (this.getModel().getDataEntity().getLong("id") != 0L) {
                    this.getView().setStatus(OperationStatus.VIEW);
                }
                this.showCancelPage();
                break;
            }
        }
    }

    private void showCancelPage() {
        this.getView().invokeOperation("refresh");
    }

    public void afterBindData(EventObject eventObject) {
        DynamicObject dynamicObject = this.getModel().getDataEntity();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean isModify = (Boolean)pageCache.get("ismodify", Boolean.class);
        if (isModify != null && isModify.booleanValue()) {
            return;
        }
        Boolean paramIsModify = (Boolean)this.getView().getFormShowParameter().getCustomParam("ismodify");
        if (paramIsModify != null && paramIsModify.booleanValue()) {
            return;
        }
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            return;
        }
        String statusParam = (String)this.getView().getFormShowParameter().getCustomParam("status");
        String statusJudge = dynamicObject.getString("status");
        logger.info("FileBlockBaseDataCommEdit.afterBindData...statusJudge...1...statusJudge={}", (Object)statusJudge);
        if (statusParam != null) {
            statusJudge = statusParam;
        }
        logger.info("FileBlockBaseDataCommEdit.afterBindData...statusJudge...2...statusJudge={}", (Object)statusJudge);
        String isOnlyView = (String)this.getView().getFormShowParameter().getCustomParam("isOnlyView");
        if ("true".equals(isOnlyView)) {
            logger.info("FileBlockBaseDataCommEdit.afterBindData...3...isOnlyView={}", (Object)isOnlyView);
            statusJudge = "B";
        }
        logger.info("FileBlockBaseDataCommEdit.afterBindData...statusJudge...4...statusJudge={}", (Object)statusJudge);
        switch (statusJudge) {
            case "A": {
                this.showViewBeforeAudit();
                break;
            }
            case "B": {
                this.showView();
                break;
            }
            case "C": {
                this.showViewAfterAudit();
                break;
            }
            default: {
                this.showView();
            }
        }
    }

    private void showView() {
        this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        this.getView().setVisible(Boolean.FALSE, new String[]{ADVBAR_SAVE, ADVBAR_CANCEL});
        this.getView().setVisible(Boolean.FALSE, new String[]{ADVBAR_MODIFY});
    }

    private void showViewBeforeAudit() {
        this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        this.getView().setVisible(Boolean.FALSE, new String[]{ADVBAR_SAVE, ADVBAR_CANCEL});
        this.getView().setVisible(Boolean.TRUE, new String[]{ADVBAR_MODIFY});
    }

    private void showViewAfterAudit() {
        this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
        this.getView().setVisible(Boolean.TRUE, new String[]{ADVBAR_MODIFY});
        this.getView().setVisible(Boolean.FALSE, new String[]{ADVBAR_SAVE, ADVBAR_CANCEL});
    }

    protected SWCHisBaseDataType getBaseDataType() {
        return SWCHisBaseDataType.TSHISBLOCKBASEDATA;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        operate.getOption().setVariableValue("pageId", this.getView().getPageId());
        this.mutextLock(operate, args);
        if (args.isCancel()) {
            return;
        }
        if (EDIT.equals(operate.getOperateKey())) {
            this.getView().getModel().beginInit();
            this.getView().getModel().getDataEntity().set("status", (Object)"A");
            this.getModel().setDataChanged(false);
            this.getView().getModel().endInit();
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().getFormShowParameter().setStatus(OperationStatus.EDIT);
            this.getView().cacheFormShowParameter();
            this.getView().setVisible(Boolean.TRUE, new String[]{ADVBAR_SAVE, ADVBAR_CANCEL});
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("ismodify", (Object)Boolean.TRUE);
        }
        if ("save".equals(operate.getOperateKey())) {
            this.validateMainEntityStatus(args);
            String statusParam = (String)this.getView().getFormShowParameter().getCustomParam("status");
            if (statusParam != null && "C".equals(statusParam)) {
                operate.getOption().setVariableValue("status", "C");
            }
        }
    }

    private void validateMainEntityStatus(BeforeDoOperationEventArgs args) {
        String mainEntityNumber = (String)this.getView().getFormShowParameter().getCustomParam("mainEntityNumber");
        String mainDataId = (String)this.getView().getFormShowParameter().getCustomParam("mainDataId");
        String statusParam = (String)this.getView().getFormShowParameter().getCustomParam("status");
        if (SWCStringUtils.isNotEmpty((String)mainEntityNumber) && SWCStringUtils.isNotEmpty((String)mainDataId) && SWCStringUtils.isNotEmpty((String)statusParam)) {
            SWCDataServiceHelper mainEntityOrm = new SWCDataServiceHelper(mainEntityNumber);
            QFilter qFilter = new QFilter("status", "=", (Object)statusParam);
            qFilter.and("id", "=", (Object)Long.parseLong(mainDataId));
            boolean isExists = mainEntityOrm.isExists(new QFilter[]{qFilter});
            if (!isExists) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u72b6\u6001\u5df2\u66f4\u65b0\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5\u3002", (String)"SWCNewHisBlockBaseDataCommEdit_1", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        OperationResult operationResult = args.getOperationResult();
        if (null != operationResult && operationResult.isSuccess() && "save".equals(operate.getOperateKey())) {
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.remove("ismodify");
            this.removeMutexLock();
            this.getView().setStatus(OperationStatus.VIEW);
            ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
            this.getView().invokeOperation("refresh");
        }
    }

    private void mutextLock(FormOperate operate, BeforeDoOperationEventArgs args) {
        switch (operate.getOperateKey()) {
            case "edit": {
                String entityId = this.getView().getEntityId();
                String pkId = this.getModel().getDataEntity().getString("id");
                String groupId = MutexHelper.getMutexGroupId((String)entityId, (String)"modify");
                DataMutex dataMutex = DataMutex.create();
                Map<String, String> lockInfo = this.getMutexLockInfo(entityId, pkId, groupId, dataMutex);
                if (null != lockInfo && !lockInfo.isEmpty()) {
                    args.setCancel(true);
                    this.showMutexNotification(lockInfo);
                    this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
                    ((IBillView)this.getView()).setBillStatus(BillOperationStatus.VIEW);
                } else {
                    this.getPageCache().put(PKID, pkId);
                    this.addMutexLock(entityId, pkId, groupId, dataMutex);
                }
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
                break;
            }
            case "refresh": {
                this.removeMutexLock();
                break;
            }
        }
    }

    private void showMutexNotification(Map<String, String> lockInfo) {
        Map userInfo;
        String userId = lockInfo.get("userid");
        String operateKey = lockInfo.get("opkey");
        if (!SWCStringUtils.isEmpty((String)userId) && SWCStringUtils.equals((String)operateKey, (String)"modify") && null != (userInfo = UserServiceHelper.getUserInfoByID((long)Long.parseLong(userId)))) {
            String userName = (String)userInfo.get("name");
            if (!SWCStringUtils.isEmpty((String)userName)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"SWCNewHisBlockBaseDataCommEdit_2", (String)"swc-hsbp-formplugin", (Object[])new Object[]{userName}));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f51\u7edc\u4e92\u65a5\u68c0\u6d4b\u51fa\u6709\u4eba\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u5f53\u524d\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u3002", (String)"SWCNewHisBlockBaseDataCommEdit_3", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMutexLock() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        Boolean noRelaseMutextLock = (Boolean)pageCache.get(CACHE_NO_RELEASE_MUTEX_LOCK, Boolean.class);
        if (null == noRelaseMutextLock) {
            String entityId = this.getView().getEntityId();
            String pkId = this.getModel().getDataEntity().getString("id");
            DataMutex dataMutex = DataMutex.create();
            try {
                dataMutex.release(pkId, entityId, "modify");
            }
            finally {
                try {
                    dataMutex.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private Map<String, String> getMutexLockInfo(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        return dataMutex.getLockInfo(pkId, groupId, entityId);
    }

    private void addMutexLock(String entityId, String pkId, String groupId, DataMutex dataMutex) {
        dataMutex.require(pkId, groupId, entityId, "modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageRelease(EventObject eventObject) {
        String pkId = this.getPageCache().get(PKID);
        if (!SWCStringUtils.isEmpty((String)pkId)) {
            String entityId = this.getView().getEntityId();
            DataMutex dataMutex = DataMutex.create();
            try {
                dataMutex.release(pkId, entityId, "modify");
            }
            finally {
                try {
                    dataMutex.close();
                }
                catch (IOException ioException) {
                    logger.error((Throwable)ioException);
                }
            }
        }
    }
}

