/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.formplugin.web.verify;

import java.text.ParseException;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCCoreBaseBillEdit;

public class VerifyBillCardTplEdit
extends SWCCoreBaseBillEdit
implements BeforeF7SelectListener {
    public static final String FLEX_FIELD_SET_PANEL_AP = "fieldsetpanelap";
    public static final String ENTRY_AP = "entryAp";

    public void initialize() {
        super.initialize();
        this.getView().addCustomControls(new String[]{"entryentity"});
    }

    public void afterCreateNewData(EventObject eventObject) {
        super.afterCreateNewData(eventObject);
        String tempData = (String)this.getView().getFormShowParameter().getCustomParam("entryData");
        if (SWCStringUtils.isEmpty((String)tempData)) {
            return;
        }
        Map entryData = (Map)SerializationUtils.deSerializeFromBase64((String)tempData);
        if (entryData == null) {
            return;
        }
        HashMap<String, Object> valueMap = new HashMap<String, Object>(16);
        List fields = (List)entryData.get("fields");
        if (CollectionUtils.isEmpty((Collection)fields)) {
            return;
        }
        for (Map field : fields) {
            String fieldNumber = (String)field.get("fieldNumber");
            List fieldValues = (List)field.get("fieldValues");
            DynamicProperty property = (DynamicProperty)field.get("prop");
            valueMap.put(fieldNumber, this.formatValue(property, (String)fieldValues.get(0)));
        }
        if (CollectionUtils.isEmpty(valueMap)) {
            return;
        }
        IDataModel model = this.getModel();
        DataEntityPropertyCollection properties = model.getDataEntityType().getProperties();
        model.beginInit();
        valueMap.forEach((key, value) -> {
            if (properties.containsKey(key)) {
                model.setValue(key, value);
            }
        });
        model.endInit();
    }

    private Object formatValue(DynamicProperty property, String fieldValue) {
        if (SWCStringUtils.isEmpty((String)fieldValue)) {
            return null;
        }
        if (property instanceof BasedataProp) {
            return fieldValue;
        }
        if (property instanceof LongProp) {
            return Long.valueOf(fieldValue);
        }
        if (property instanceof DateProp) {
            try {
                return SWCDateTimeUtils.parseDate((String)fieldValue);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return fieldValue;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
    }
}

