/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.opplugin.file;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FileBlockBaseDataCommAuditOp
extends AbstractOperationServicePlugIn {
    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] objs = args.getDataEntities();
        if (objs == null) {
            return;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        String entityName = objs[0].getDataEntityType().getName();
        filter.and("entitytype.relatepageinfo.id", "=", (Object)entityName);
        filter.and("isselfembedpage", "=", (Object)Boolean.FALSE);
        Object[] confArr = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper.getEntityName()), new QFilter[]{filter}, "index");
        if (SWCArrayUtils.isEmpty((Object[])confArr)) {
            return;
        }
        List<Long> fileIds = Arrays.stream(objs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        List<Long> employeeIds = Arrays.stream(objs).map(obj -> obj.getLong("employee.id")).collect(Collectors.toList());
        List<Long> personIds = Arrays.stream(objs).map(obj -> obj.getLong("person.id")).collect(Collectors.toList());
        for (Object conf : confArr) {
            this.auditFileRelateData(fileIds, employeeIds, personIds, (DynamicObject)conf, "A");
            this.auditFileRelateData(fileIds, employeeIds, personIds, (DynamicObject)conf, "B");
        }
    }

    private void auditFileRelateData(List<Long> fileIds, List<Long> employeeIds, List<Long> personIds, DynamicObject conf, String status) {
        OperationResult opResultSubmit;
        boolean isSuccSubmit;
        String pageNumber = conf.getString("pagenumber");
        String mainPropKey = conf.getString("mainpropkey");
        String dataQueryType = conf.getString("dataquerytype");
        if (SWCStringUtils.isEmpty((String)mainPropKey)) {
            mainPropKey = SWCBaseDataHelper.getEntityPropKey((String)pageNumber, (String)"hsas_salaryfile");
        }
        if (SWCStringUtils.isEmpty((String)mainPropKey)) {
            return;
        }
        SWCDataServiceHelper tmpSerHelper = new SWCDataServiceHelper(pageNumber);
        QFilter tmpFilter = new QFilter("status", "=", (Object)status);
        if ("1".equals(dataQueryType)) {
            tmpFilter.and(mainPropKey, "in", fileIds);
        } else if ("2".equals(dataQueryType)) {
            tmpFilter.and(mainPropKey, "in", employeeIds);
        } else if ("3".equals(dataQueryType)) {
            tmpFilter.and(mainPropKey, "in", personIds);
        }
        Object[] dataArr = tmpSerHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)tmpSerHelper.getEntityName()), new QFilter[]{tmpFilter});
        if (SWCArrayUtils.isEmpty((Object[])dataArr)) {
            return;
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        if ("A".equals(status) && !(isSuccSubmit = (opResultSubmit = opImpl.localInvokeOperation("submit", (DynamicObject[])dataArr, this.operateOption)).isSuccess())) {
            throw new KDBizException(opResultSubmit.getMessage());
        }
        OperationResult opResultAudit = opImpl.localInvokeOperation("audit", (DynamicObject[])dataArr, this.operateOption);
        boolean isSuccAudit = opResultAudit.isSuccess();
        if (!isSuccAudit) {
            throw new KDBizException(opResultAudit.getMessage());
        }
    }
}

