/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.opplugin.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FileBlockBaseDataCommDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("status");
        fieldKeys.add("person");
        fieldKeys.add("depemp");
        fieldKeys.add("employee");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] objs = args.getDataEntities();
        if (objs == null) {
            return;
        }
        ArrayList<Long> fileIds = new ArrayList<Long>(10);
        ArrayList<Long> employeeIds = new ArrayList<Long>(10);
        ArrayList<Long> personIds = new ArrayList<Long>(10);
        for (DynamicObject selectedRow : objs) {
            if (!"A".equals(selectedRow.getString("status"))) continue;
            fileIds.add(selectedRow.getLong("id"));
            employeeIds.add(selectedRow.getLong("employee.id"));
            personIds.add(selectedRow.getLong("person.id"));
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        String entityName = objs[0].getDataEntityType().getName();
        filter.and("entitytype.relatepageinfo.id", "=", (Object)entityName);
        filter.and("isselfembedpage", "=", (Object)Boolean.FALSE);
        Object[] confArr = serviceHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper.getEntityName()), new QFilter[]{filter}, "index");
        if (SWCArrayUtils.isEmpty((Object[])confArr)) {
            return;
        }
        for (Object conf : confArr) {
            this.auditFileRelateData(fileIds, employeeIds, personIds, (DynamicObject)conf, "A");
        }
    }

    private void auditFileRelateData(List<Long> fileIds, List<Long> employeeIds, List<Long> personIds, DynamicObject conf, String status) {
        OperationResult opResultSubmit;
        boolean isSuccSubmit;
        String pageNumber = conf.getString("pagenumber");
        String mainPropKey = conf.getString("mainpropkey");
        String dataQueryType = conf.getString("dataquerytype");
        String fileEntityName = conf.getString("entitytype.relatepageinfo.id");
        if (SWCStringUtils.isEmpty((String)mainPropKey)) {
            mainPropKey = SWCBaseDataHelper.getEntityPropKey((String)pageNumber, (String)fileEntityName);
        }
        if (SWCStringUtils.isEmpty((String)mainPropKey)) {
            return;
        }
        SWCDataServiceHelper tmpSerHelper = new SWCDataServiceHelper(pageNumber);
        QFilter tmpFilter = new QFilter("status", "=", (Object)status);
        if ("1".equals(dataQueryType)) {
            tmpFilter.and(mainPropKey, "in", fileIds);
        } else if ("2".equals(dataQueryType)) {
            this.checkIsExistsOtherFileCanNotDelte(fileIds, employeeIds, fileEntityName, "employee.id");
            tmpFilter.and(mainPropKey, "in", employeeIds);
        } else if ("3".equals(dataQueryType)) {
            this.checkIsExistsOtherFileCanNotDelte(fileIds, personIds, fileEntityName, "person.id");
            tmpFilter.and(mainPropKey, "in", personIds);
        }
        Object[] dataArr = tmpSerHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)tmpSerHelper.getEntityName()), new QFilter[]{tmpFilter});
        if (SWCArrayUtils.isEmpty((Object[])dataArr)) {
            return;
        }
        OperationServiceImpl opImpl = new OperationServiceImpl();
        if ("A".equals(status) && !(isSuccSubmit = (opResultSubmit = opImpl.localInvokeOperation("delete", (DynamicObject[])dataArr, this.operateOption)).isSuccess())) {
            throw new KDBizException(opResultSubmit.getMessage());
        }
    }

    private void checkIsExistsOtherFileCanNotDelte(List<Long> fileIds, List<Long> employeeIds, String fileEntityName, String prop) {
        SWCDataServiceHelper fileSerHelper = new SWCDataServiceHelper(fileEntityName);
        QFilter fileFilter = new QFilter(prop, "in", employeeIds);
        fileFilter.and("id", "not in", fileIds);
        DynamicObject[] fileArr = fileSerHelper.query(prop, fileFilter.toArray());
        if (fileArr != null && fileArr.length != 0) {
            List canNotDelEmpIds = Arrays.stream(fileArr).map(dy -> dy.getLong(prop)).collect(Collectors.toList());
            employeeIds.removeAll(canNotDelEmpIds);
        }
    }
}

