/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.opplugin.file;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.OperationServiceImpl;
import kd.swc.hsbp.business.servicehelper.SWCBaseDataHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FileHisBlockBaseDataCommSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FileHisBlockBaseDataCommSaveOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] objs = args.getDataEntities();
        if (objs == null) {
            return;
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        String entityName = objs[0].getDataEntityType().getName();
        filter.and("pagenumber", "=", (Object)entityName);
        DynamicObject conf = serviceHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper.getEntityName()), new QFilter[]{filter}, "index");
        if (SWCObjectUtils.isEmpty((Object)conf)) {
            return;
        }
        String mainPropId = conf.getString("mainpropkey");
        String fileEntityName = conf.getString("entitytype.relatepageinfo.id");
        String dataQueryType = conf.getString("dataquerytype");
        if (SWCStringUtils.isEmpty((String)mainPropId) && "1".equals(dataQueryType)) {
            mainPropId = SWCBaseDataHelper.getEntityPropKey((String)entityName, (String)fileEntityName);
        }
        if (SWCStringUtils.isEmpty((String)mainPropId)) {
            return;
        }
        ArrayList<Long> dataIds = new ArrayList<Long>(10);
        for (DynamicObject obj : objs) {
            dataIds.add(obj.getLong(mainPropId + ".id"));
        }
        SWCDataServiceHelper fileSerHelper = new SWCDataServiceHelper(fileEntityName);
        QFilter tmpFilter = new QFilter("status", "=", (Object)"C");
        tmpFilter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        String mainPropFileRelId = "id";
        if ("2".equals(dataQueryType)) {
            mainPropFileRelId = "employee.id";
        } else if ("3".equals(dataQueryType)) {
            mainPropFileRelId = "person.id";
        }
        tmpFilter.and(mainPropFileRelId, "in", dataIds);
        Object[] fileArr = fileSerHelper.query(SWCHisBaseDataHelper.getSelectProperties((String)fileSerHelper.getEntityName()), new QFilter[]{tmpFilter});
        if (SWCArrayUtils.isEmpty((Object[])fileArr)) {
            return;
        }
        HashSet<Long> auditFileOrPerIds = new HashSet<Long>(16);
        for (Object file : fileArr) {
            auditFileOrPerIds.add(file.getLong(mainPropFileRelId));
        }
        HashSet<Long> waitAuditIds = new HashSet<Long>(16);
        ArrayList<DynamicObject> waitConfirmDys = new ArrayList<DynamicObject>(10);
        for (DynamicObject obj : objs) {
            Boolean isCurrver = obj.getBoolean("iscurrentversion");
            String status = obj.getString("status");
            String dataStatus = obj.getString("datastatus");
            if (isCurrver.booleanValue() && auditFileOrPerIds.contains(obj.getLong(mainPropId + ".id")) && "A".equals(status)) {
                waitAuditIds.add(obj.getLong("id"));
            }
            if (isCurrver.booleanValue() || !"-3".equals(dataStatus)) continue;
            waitConfirmDys.add(obj);
        }
        SWCDataServiceHelper currHelper = new SWCDataServiceHelper(entityName);
        DynamicObject[] waitAuditDys = currHelper.query(waitAuditIds.toArray());
        this.invokeOperation("submit", waitAuditDys);
        this.invokeOperation("audit", waitAuditDys);
        this.invokeOperation("confirmchange", waitConfirmDys.toArray(new DynamicObject[waitConfirmDys.size()]));
    }

    private void invokeOperation(String operationKey, DynamicObject[] dataEntities) {
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperateOption operateOption = OperateOption.create();
        OperationResult operationResult = opImpl.localInvokeOperation(operationKey, dataEntities, operateOption);
        if (operationResult == null) {
            return;
        }
        log.info("FileHisBlockBaseDataCommSaveOp operationKey={0}  operationResult.isSuccess = {1}", (Object)operationKey, (Object)operationResult.isSuccess());
        log.info("FileHisBlockBaseDataCommSaveOp operationKey={0}  operationResult.getMessage= {1}", (Object)operationKey, (Object)operationResult.getMessage());
        StringBuilder sb = new StringBuilder();
        for (IOperateInfo operateInfo : operationResult.getAllErrorOrValidateInfo()) {
            if (sb.length() >= 1) {
                sb.append(';');
            }
            sb.append(operateInfo.getMessage());
        }
        log.info("FileHisBlockBaseDataCommSaveOp operationKey={0}  operationResult.sb.toString= {1}", (Object)operationKey, (Object)sb.toString());
        if (operationResult == null) {
            throw new KDException(new ErrorCode("", "Batch save error."), new Object[0]);
        }
        if (!operationResult.isSuccess() && sb.length() >= 1) {
            throw new KDException(new ErrorCode("", sb.toString()), new Object[0]);
        }
        if (!operationResult.isSuccess()) {
            throw new KDException(new ErrorCode("", operationResult.getMessage()), new Object[0]);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        this.getOperationResult().setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SWCNewHisBlockBaseDataCommEdit_0", (String)"swc-hsbp-formplugin", (Object[])new Object[0]));
    }
}

