/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.enums;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.TextProp;
import kd.swc.hsbp.common.entity.SWCI18NParam;

public enum DataTypeEnum {
    NUMBERIC(1010L, new SWCI18NParam("\u6570\u503c", "DataTypeEnum_0", "swc-hsbp-common")),
    AMOUNT(1020L, new SWCI18NParam("\u91d1\u989d", "DataTypeEnum_1", "swc-hsbp-common")),
    STRING(1030L, new SWCI18NParam("\u6587\u672c", "DataTypeEnum_2", "swc-hsbp-common")),
    INTEGER(1040L, new SWCI18NParam("\u6574\u578b", "DataTypeEnum_3", "swc-hsbp-common")),
    BOOLEAN(1060L, new SWCI18NParam("\u903b\u8f91", "DataTypeEnum_4", "swc-hsbp-common")),
    DATE(1050L, new SWCI18NParam("\u65e5\u671f", "DataTypeEnum_5", "swc-hsbp-common")),
    NULL(0L, new SWCI18NParam("\u7a7a", "DataTypeEnum_6", "swc-hsbp-common"));

    private final long dbId;
    private SWCI18NParam name;

    private DataTypeEnum(long dbId, SWCI18NParam name) {
        this.dbId = dbId;
        this.name = name;
    }

    public static DataTypeEnum getDataType(String name) {
        DataTypeEnum dataType = null;
        if ("string".equalsIgnoreCase(name) || "text".equalsIgnoreCase(name)) {
            dataType = STRING;
        } else if ("decimal".equalsIgnoreCase(name) || "amount".equalsIgnoreCase(name) || "numberic".equalsIgnoreCase(name) || "bigdecimal".equalsIgnoreCase(name) || "num".equalsIgnoreCase(name)) {
            dataType = NUMBERIC;
        } else if ("date".equalsIgnoreCase(name)) {
            dataType = DATE;
        } else if ("null".equalsIgnoreCase(name) || "void".equalsIgnoreCase(name)) {
            dataType = NULL;
        }
        return dataType;
    }

    public static DataTypeEnum getDataType(Class<?> clazz) {
        if (String.class.isAssignableFrom(clazz)) {
            return STRING;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return NUMBERIC;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return DATE;
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return BOOLEAN;
        }
        return NULL;
    }

    public static DataTypeEnum getDataType(IDataEntityProperty property) {
        if (property instanceof TextProp || property instanceof ComboProp) {
            return STRING;
        }
        if (property instanceof AmountProp) {
            return AMOUNT;
        }
        if (property instanceof DateProp || property instanceof DateTimeProp) {
            return DATE;
        }
        if (property instanceof DecimalProp) {
            return NUMBERIC;
        }
        if (property instanceof IntegerProp) {
            return INTEGER;
        }
        if (property instanceof BooleanProp) {
            return BOOLEAN;
        }
        return NULL;
    }

    public static DataTypeEnum getDataTypeById(long dbId) {
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            if (dataType.getDbId() != dbId) continue;
            return dataType;
        }
        return NULL;
    }

    public static String getNameByDbId(long dbId) {
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            if (dataType.getDbId() != dbId) continue;
            return dataType.getName();
        }
        return NULL.getName();
    }

    public long getDbId() {
        return this.dbId;
    }

    public String getName() {
        return this.name.loadKDString();
    }
}

