/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.model.BaseResult;
import kd.swc.hsbp.common.model.Message;

public class BatchResult<T>
extends BaseResult<List<T>> {
    private final Map<T, Message> messageMap = Maps.newHashMapWithExpectedSize((int)((List)this.getData()).size());

    public BatchResult(List<T> data, Message message) {
        super(data == null ? Lists.newArrayList() : data, message);
        if (message != null) {
            for (T datum : data) {
                this.messageMap.put(datum, message);
            }
        }
    }

    public void bizMsg(T data, Message message) {
        this.messageMap.put(data, message);
    }

    public void bizMsg(T data, String msg, int status) {
        this.bizMsg(data, new Message(msg, status));
    }

    public Message bizMsg(T data) {
        return this.messageMap.get(data);
    }

    public boolean isSuccess(T data) {
        Message message = this.messageMap.get(data);
        return message == null || !message.isSuccess();
    }

    public void merge(BatchResult<T> result) {
        if (CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return;
        }
        ((List)this.getData()).addAll((Collection)result.getData());
        for (Map.Entry<T, Message> entry : result.getMessageMap().entrySet()) {
            Message message = this.messageMap.get(entry.getKey());
            if (entry.getValue() == null || message != null && entry.getValue().getStatus() <= message.getStatus()) continue;
            this.messageMap.put(entry.getKey(), entry.getValue());
        }
    }

    public int dataSize() {
        List data = (List)this.getData();
        return data == null ? 0 : data.size();
    }

    public int failSize() {
        if (CollectionUtils.isEmpty(this.messageMap)) {
            return 0;
        }
        return (int)this.messageMap.values().stream().filter(message -> !message.isSuccess()).count();
    }

    public Map<T, Message> getMessageMap() {
        return this.messageMap;
    }
}

