/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class DynamicTransformUtil {
    private static final Log LOGGER = LogFactory.getLog(DynamicTransformUtil.class);
    private static final Map<String, String> entitySelectPropMap = new ConcurrentHashMap<String, String>(16);
    private static final List<String> ignoreSysList = Arrays.asList("multilanguagetext", "masterid", "vid", "sourcevid", "changebsed", "brfd", "changedescription", "hisversion", "initstatus", "initbatch", "initdatasource");

    public static String getDynamicPropString(String entityName) {
        return DynamicTransformUtil.getDynamicPropString(entityName, null);
    }

    public static String getDynamicPropString(String entityName, Set<String> ignoreKey) {
        Set<String> ignore = DynamicTransformUtil.getIgnoreSet(ignoreKey);
        String propString = entitySelectPropMap.get(entityName);
        if (!HRStringUtils.isEmpty((String)propString)) {
            return propString;
        }
        try {
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
            if (null != dataEntityType) {
                DataEntityPropertyCollection properties = dataEntityType.getProperties();
                ArrayList<String> propList = new ArrayList<String>(properties.size());
                for (IDataEntityProperty property : dataEntityType.getProperties()) {
                    if (!DynamicTransformUtil.checkFields(property.getName(), ignore) || HRStringUtils.isEmpty((String)property.getAlias())) continue;
                    propList.add(property.getName());
                }
                propString = String.join((CharSequence)",", propList);
                entitySelectPropMap.put(entityName, propString);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getDynamicPropString entitName:{} error:{}", (Object)entityName, (Object)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_1", (String)"swc-hsbp-common", (Object[])new Object[0])), new Object[0]);
        }
        return propString == null ? "id" : propString;
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dy) {
        return DynamicTransformUtil.dynamicObjectToMap(dy, null, null);
    }

    public static Map<String, Object> dynamicObjectToMap(DynamicObject dy, Set<String> ignoreKey, List<String> needKeys) {
        return DynamicTransformUtil.getPropMap(dy, ignoreKey, needKeys);
    }

    public static Map<String, Object> dynamicObjectsToMap(List<DynamicObject> dynamicObjects) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            dynamicObjects.forEach(dynamicObject -> {
                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                properties.forEach(property -> {
                    if (!resultMap.containsKey(property.getName())) {
                        Object mapValue;
                        Object propObj = dynamicObject.get(property);
                        Object object = mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        if (propObj instanceof DynamicObject) {
                            DynamicObject propObjDy = (DynamicObject)propObj;
                            resultMap.put(property.getName() + "_id", propObjDy.get("id"));
                            DataEntityPropertyCollection props = propObjDy.getDataEntityType().getProperties();
                            if (props.containsKey((Object)"number")) {
                                resultMap.put(property.getName() + "_number", propObjDy.get("number"));
                            }
                            if (props.containsKey((Object)"name")) {
                                resultMap.put(property.getName() + "_name", propObjDy.get("name") instanceof ILocaleString ? propObjDy.getLocaleString("name").getLocaleValue() : propObjDy.get("name"));
                            }
                        } else {
                            resultMap.put(property.getName(), mapValue);
                        }
                    }
                });
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicObjectsToMap", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u5931\u8d25\u3002", (String)"DynamicTransformUtil_2", (String)"swc-hsbp-common", (Object[])new Object[0])), new Object[0]);
        }
        return resultMap;
    }

    public static List<Map<String, Object>> dynamicListToMap(List<DynamicObject> dyList) {
        return DynamicTransformUtil.dynamicListToMap(dyList, null, true);
    }

    public static List<Map<String, Object>> dynamicListToMap(List<DynamicObject> dyList, Set<String> ignoreKey) {
        return DynamicTransformUtil.dynamicListToMap(dyList, ignoreKey, true);
    }

    public static List<Map<String, Object>> dynamicAllPropListToMap(List<DynamicObject> dyList) {
        return DynamicTransformUtil.dynamicListToMap(dyList, null, false);
    }

    private static List<Map<String, Object>> dynamicListToMap(List<DynamicObject> dyList, Set<String> ignoreKey, boolean isIgnore) {
        if (null == dyList || dyList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dyList.size());
        try {
            dyList.forEach(dynamicObject -> {
                Map<String, Object> dyMap = DynamicTransformUtil.getPropMap(dynamicObject, ignoreKey, isIgnore, null);
                if (!dyMap.isEmpty()) {
                    resultList.add(dyMap);
                }
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicListToMap", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\u3002", (String)"DynamicTransformUtil_3", (String)"swc-hsbp-common", (Object[])new Object[0])), new Object[0]);
        }
        return resultList;
    }

    public static List<Map<String, Object>> dynamicListToDyMap(List<DynamicObject> dyList) {
        if (null == dyList || dyList.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(dyList.size());
        try {
            IDataEntityType dataEntityType = dyList.get(0).getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            dyList.forEach(dynamicObject -> {
                HashMap<String, Object> resultMap;
                try {
                    resultMap = new HashMap<String, Object>(properties.size());
                    for (IDataEntityProperty property : properties) {
                        Object propObj = dynamicObject.get(property);
                        Object mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                        resultMap.put(property.getName(), mapValue);
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("getPropMap property", (Throwable)ex);
                    throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_1", (String)"swc-hsbp-common", (Object[])new Object[0])), new Object[0]);
                }
                resultList.add(resultMap);
            });
        }
        catch (Exception ex) {
            LOGGER.error("transform dynamicListToDyMap", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u5931\u8d25\u3002", (String)"DynamicTransformUtil_3", (String)"swc-hsbp-common", (Object[])new Object[0])), new Object[0]);
        }
        return resultList;
    }

    private static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey, List<String> needKeys) {
        return DynamicTransformUtil.getPropMap(dy, ignoreKey, true, needKeys);
    }

    private static Map<String, Object> getPropMap(DynamicObject dy) {
        return DynamicTransformUtil.getPropMap(dy, null, false, null);
    }

    private static Map<String, Object> getPropMap(DynamicObject dy, Set<String> ignoreKey, boolean isIgnore, List<String> needKeys) {
        LinkedHashMap<String, Object> resultMap;
        if (dy == null) {
            return Collections.emptyMap();
        }
        Set<String> ignore = DynamicTransformUtil.getIgnoreSet(ignoreKey);
        try {
            IDataEntityType dataEntityType = dy.getDataEntityType();
            DataEntityPropertyCollection properties = dataEntityType.getProperties();
            resultMap = new LinkedHashMap<String, Object>(properties.size());
            for (IDataEntityProperty property : properties) {
                Object mapValue;
                if (isIgnore && ignore.contains(property.getName())) continue;
                Object propObj = dy.get(property);
                String mkey = property.getName();
                Object object = mapValue = propObj instanceof ILocaleString ? ((ILocaleString)propObj).getLocaleValue() : propObj;
                if (propObj instanceof DynamicObject) {
                    DynamicObject propObjDy = (DynamicObject)propObj;
                    DynamicTransformUtil.putResultMap(needKeys, resultMap, mkey + "_id", propObjDy.get("id"));
                    DataEntityPropertyCollection props = propObjDy.getDataEntityType().getProperties();
                    if (props.containsKey((Object)"number")) {
                        DynamicTransformUtil.putResultMap(needKeys, resultMap, mkey + "_number", propObjDy.get("number"));
                    }
                    if (!props.containsKey((Object)"name")) continue;
                    DynamicTransformUtil.putResultMap(needKeys, resultMap, mkey + "_name", propObjDy.get("name") instanceof ILocaleString ? propObjDy.getLocaleString("name").getLocaleValue() : propObjDy.get("name"));
                    continue;
                }
                DynamicTransformUtil.putResultMap(needKeys, resultMap, mkey, mapValue);
            }
        }
        catch (Exception ex) {
            LOGGER.error("getPropMap property", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ResManager.loadKDString((String)"\u83b7\u53d6\u5c5e\u6027\u5931\u8d25\u3002", (String)"DynamicTransformUtil_1", (String)"swc-hsbp-common", (Object[])new Object[0])), new Object[0]);
        }
        return resultMap;
    }

    private static void putResultMap(List<String> needKeys, Map<String, Object> resultMap, String mkey, Object mapValue) {
        if (needKeys == null || needKeys.contains(mkey)) {
            resultMap.put(mkey, mapValue);
        }
    }

    private static Set<String> getIgnoreSet(Set<String> ignoreKey) {
        if (null == ignoreKey || ignoreKey.isEmpty()) {
            ignoreKey = new HashSet<String>(ignoreSysList);
        } else {
            ignoreKey.addAll(ignoreSysList);
        }
        return ignoreKey;
    }

    private static boolean checkFields(String propName, Set<String> ignoreSet) {
        return !ignoreSet.contains(propName) && !propName.endsWith("_id") && !propName.equals("multilanguagetext");
    }

    public static void setBaseData(String mapKey, DynamicObject baseData, Map<String, Object> map) {
        if (null != baseData) {
            DataEntityPropertyCollection properties = baseData.getDataEntityType().getProperties();
            if (null != properties.get((Object)"name")) {
                map.put(mapKey, baseData.getString("name"));
            }
            if (null != properties.get((Object)"number")) {
                map.put(mapKey + "_number", baseData.getString("number"));
            }
            map.put(mapKey + "_id", baseData.getLong("id"));
        }
    }
}

