/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.util.PermCommonUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class GeneralFilterCompareService {
    private static final Log logger = LogFactory.getLog(GeneralFilterCompareService.class);
    private Set<String> compareTypeFalse = new LinkedHashSet<String>(Arrays.asList(CompareTypeEnum.NOTIN.getId(), CompareTypeEnum.ISNOTNULL.getId(), CompareTypeEnum.NOTEQUAL.getId(), CompareTypeEnum.NOTLIKE.getId()));

    public boolean isMatch(String filterString, Map<String, Object> dtoNameLangMap) {
        if (SWCStringUtils.isEmpty(filterString)) {
            return true;
        }
        try {
            return this.dealBrackets(this.getBooleanString(filterString, dtoNameLangMap));
        }
        catch (Exception exception) {
            logger.info("GeneralFilter error :", (Object)exception);
            return false;
        }
    }

    public String getShowString(String filterString, Map<String, String> filedNameLangMap) {
        StringBuilder logicExpression = new StringBuilder();
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterString, FilterCondition.class);
        if (filterCondition != null) {
            List filterRow = filterCondition.getFilterRow();
            Map<String, String> compareNameMap = this.getCompareNameMap();
            Map<String, String> andOrNameMap = this.getAndOrNameMap();
            for (int index = 0; index < filterRow.size(); ++index) {
                SimpleFilterRow row = (SimpleFilterRow)filterRow.get(index);
                logicExpression.append(row.getLeftBracket());
                String compareType = row.getCompareType();
                String rightBracket = row.getRightBracket();
                String filedName = filedNameLangMap.get(row.getFieldName());
                logicExpression.append('[').append(filedName).append("] ");
                String compareName = compareNameMap.get(compareType);
                logicExpression.append(compareName);
                logicExpression.append(' ');
                logicExpression.append('(');
                for (int i = 0; i < row.getValue().size(); ++i) {
                    FilterValue value = (FilterValue)row.getValue().get(i);
                    String valueValue = value.getValue().toString();
                    logicExpression.append(valueValue);
                    if (i >= row.getValue().size() - 1) continue;
                    logicExpression.append('\u3001');
                }
                logicExpression.append(") ");
                logicExpression.append(rightBracket);
                if (index >= filterRow.size() - 1) continue;
                logicExpression.append(andOrNameMap.get(row.getLogic()));
                logicExpression.append(' ');
            }
        }
        return logicExpression.toString();
    }

    private String getBooleanString(String filterString, Map<String, Object> dtoNameLangMap) {
        StringBuilder logicExpression = new StringBuilder();
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterString, FilterCondition.class);
        if (filterCondition != null) {
            int index = 1;
            for (SimpleFilterRow row : filterCondition.getFilterRow()) {
                logicExpression.append(row.getLeftBracket());
                String compareType = row.getCompareType();
                String rightBracket = row.getRightBracket();
                Object obj = dtoNameLangMap.get(row.getFieldName());
                if (obj instanceof Date) {
                    FilterCondition filterConditionDate = (FilterCondition)SerializationUtils.fromJsonString((String)filterString, FilterCondition.class);
                    filterConditionDate.getFilterRow().clear();
                    row.setLeftBracket("");
                    row.setRightBracket("");
                    filterConditionDate.getFilterRow().add(row);
                    QueryEntityType entityType = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)"hsas_payaccountpersonquery");
                    QFilter filter = PermCommonUtil.getQFilterFromFilterGridJsonStr((MainEntityType)entityType, (String)SerializationUtils.toJsonString((Object)filterConditionDate));
                    logicExpression.append(this.dateFilterToResult(filter, (Date)obj));
                } else {
                    if (obj instanceof Boolean) {
                        obj = obj.equals(Boolean.TRUE) ? "1" : "0";
                    }
                    StringBuilder logicExpressionTemp = new StringBuilder();
                    if (this.compareTypeFalse.contains(compareType)) {
                        logicExpressionTemp.append("false");
                    } else {
                        logicExpressionTemp.append("true");
                    }
                    logicExpressionTemp.append("&&");
                    boolean flag = true;
                    for (FilterValue value : row.getValue()) {
                        String result;
                        Object valueValue = value.getValue();
                        String valueString = valueValue.toString();
                        if (CompareTypeEnum.LIKE.getId().equals(compareType) || CompareTypeEnum.NOTLIKE.getId().equals(compareType)) {
                            if (obj != null && obj.toString().contains(valueString)) {
                                logicExpressionTemp.append("true");
                                flag = false;
                                break;
                            }
                        } else if (CompareTypeEnum.LEFTLIKE.getId().equals(compareType)) {
                            if (obj != null && obj.toString().startsWith(valueString)) {
                                logicExpressionTemp.append("true");
                                flag = false;
                                break;
                            }
                        } else if (CompareTypeEnum.RIGHTLIKE.getId().equals(compareType) && obj != null && obj.toString().endsWith(valueString)) {
                            logicExpressionTemp.append("true");
                            flag = false;
                            break;
                        }
                        if (obj instanceof Integer && "true".equals(result = this.filterToResult(compareType, (Integer)obj - Integer.parseInt(valueString)))) {
                            logicExpressionTemp.append(result);
                            flag = false;
                            break;
                        }
                        if (obj instanceof BigDecimal && "true".equals(result = this.filterToResult(compareType, ((BigDecimal)obj).compareTo(new BigDecimal(valueString))))) {
                            logicExpressionTemp.append(result);
                            flag = false;
                            break;
                        }
                        if (!(obj instanceof String) || !"true".equals(result = this.filterToResult(compareType, obj.toString().compareTo(valueString)))) continue;
                        logicExpressionTemp.append(result);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        logicExpressionTemp.append("false");
                    }
                    String result = this.getResult(logicExpressionTemp.toString());
                    logicExpression.append(result);
                }
                logicExpression.append(rightBracket);
                if (index < filterCondition.getFilterRow().size()) {
                    if ("0".equals(row.getLogic())) {
                        logicExpression.append("&&");
                    } else {
                        logicExpression.append("||");
                    }
                }
                ++index;
            }
        }
        return logicExpression.toString();
    }

    private boolean dealBrackets(String logicExpression) {
        while (logicExpression.contains("(")) {
            String tempChar;
            int i;
            int lastLeftBracketIndex = -1;
            int firStrightBracketIndex = -1;
            for (i = 0; i < logicExpression.length(); ++i) {
                tempChar = logicExpression.substring(i, i + 1);
                if (!"(".equals(tempChar)) continue;
                lastLeftBracketIndex = i;
            }
            for (i = lastLeftBracketIndex; i < logicExpression.length(); ++i) {
                tempChar = logicExpression.substring(i, i + 1);
                if (firStrightBracketIndex != -1 || !")".equals(tempChar)) continue;
                firStrightBracketIndex = i;
            }
            String calculateExpression = logicExpression.substring(lastLeftBracketIndex + 1, firStrightBracketIndex);
            boolean logicResult = this.logicOperate(calculateExpression);
            logicExpression = logicExpression.replace("(" + calculateExpression + ")", String.valueOf(logicResult));
        }
        boolean finalResult = this.logicOperate(logicExpression);
        return finalResult;
    }

    private boolean logicOperate(String logicExpression) {
        logicExpression = logicExpression.replace(" ", "");
        String logicExpressionValue = logicExpression.replace("&&", ",");
        logicExpressionValue = logicExpressionValue.replace("||", ",");
        String[] arrLogicValue = logicExpressionValue.split(",");
        String logicExpressionOperator = logicExpression;
        logicExpressionOperator = logicExpressionOperator.replace("true", ",");
        if ((logicExpressionOperator = logicExpressionOperator.replace("false", ",")).length() > 1) {
            logicExpressionOperator = logicExpressionOperator.substring(1, logicExpressionOperator.length() - 1);
        }
        String[] arrOperator = logicExpressionOperator.split(",");
        boolean logicResult = Boolean.parseBoolean(arrLogicValue[0]);
        for (int i = 0; i < arrOperator.length; ++i) {
            if ("&&".equals(arrOperator[i])) {
                logicResult = logicResult && Boolean.parseBoolean(arrLogicValue[i + 1]);
                continue;
            }
            if (!"||".equals(arrOperator[i])) continue;
            logicResult = logicResult || Boolean.parseBoolean(arrLogicValue[i + 1]);
        }
        return logicResult;
    }

    private String getResult(String logicExpressionTemp) {
        String logicResultLast;
        String logicExpressionValue = (logicExpressionTemp = logicExpressionTemp.replace(" ", "")).replace("&&", ",");
        String[] arrLogicValue = logicExpressionValue.split(",");
        String logicResultFirst = arrLogicValue[0];
        if (logicResultFirst.equals(logicResultLast = arrLogicValue[1])) {
            return "true";
        }
        return "false";
    }

    private String filterToResult(String compareType, int compareValue) {
        if (compareValue < 0 && Arrays.asList(CompareTypeEnum.LESS.getId(), CompareTypeEnum.LESSOREQUAL.getId()).contains(compareType)) {
            return "true";
        }
        if (compareValue > 0 && Arrays.asList(CompareTypeEnum.GREATER.getId(), CompareTypeEnum.GREATEROREQUAL.getId()).contains(compareType)) {
            return "true";
        }
        if (compareValue == 0) {
            return "true";
        }
        return "false";
    }

    private String dateFilterToResult(QFilter filter, Date date) {
        List nests;
        String cp = filter.getCP();
        Date filterLeftDate = (Date)filter.getValue();
        String logicExpressionTemp = "";
        if (SWCStringUtils.isNotEmpty(cp)) {
            logicExpressionTemp = logicExpressionTemp + this.dealDate(cp, date.compareTo(filterLeftDate));
        }
        if ((nests = filter.getNests(false)).size() == 1) {
            QFilter.QFilterNest nest = (QFilter.QFilterNest)nests.get(0);
            logicExpressionTemp = nest.isAnd() ? logicExpressionTemp + "&&" : logicExpressionTemp + "||";
            cp = nest.getFilter().getCP();
            filterLeftDate = (Date)nest.getFilter().getValue();
            logicExpressionTemp = logicExpressionTemp + this.dealDate(cp, date.compareTo(filterLeftDate));
            return String.valueOf(this.logicOperate(logicExpressionTemp));
        }
        return logicExpressionTemp;
    }

    private String dealDate(String cp, int compareInt) {
        String logicExpressionTemp = "";
        logicExpressionTemp = compareInt > 0 ? (cp.contains(">") ? "true" : "false") : (compareInt < 0 ? (cp.contains("<") ? "true" : "false") : (cp.contains("=") ? "true" : "false"));
        return logicExpressionTemp;
    }

    public boolean isCompleteness(List<SimpleFilterRow> relFilters) {
        Stack<Character> stack = new Stack<Character>();
        for (SimpleFilterRow relFilter : relFilters) {
            char[] chars;
            String rightBracket;
            String leftBracket = relFilter.getLeftBracket();
            if (!leftBracket.isEmpty()) {
                char[] chars2 = leftBracket.toCharArray();
                for (int i = 0; i < chars2.length; ++i) {
                    stack.push(Character.valueOf(chars2[i]));
                }
            }
            if ((rightBracket = relFilter.getRightBracket()).isEmpty()) continue;
            for (char aChar : chars = rightBracket.toCharArray()) {
                if (stack.isEmpty()) {
                    return false;
                }
                stack.pop();
            }
        }
        return stack.isEmpty();
    }

    private Map<String, String> getCompareNameMap() {
        HashMap<String, String> compareNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GeneralFilterCompareService_0", (String)"swc-hsas-business", (Object[])new Object[0]);
        compareNameLangMap.put(CompareTypeEnum.IN.getId(), name);
        name = ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"GeneralFilterCompareService_1", (String)"swc-hsas-business", (Object[])new Object[0]);
        compareNameLangMap.put(CompareTypeEnum.NOTIN.getId(), name);
        return compareNameLangMap;
    }

    private Map<String, String> getAndOrNameMap() {
        HashMap<String, String> andOrNameLangMap = new HashMap<String, String>(16);
        String name = ResManager.loadKDString((String)"\u6216", (String)"GeneralFilterCompareService_2", (String)"swc-hsas-business", (Object[])new Object[0]);
        andOrNameLangMap.put("1", name);
        name = ResManager.loadKDString((String)"\u4e14", (String)"GeneralFilterCompareService_3", (String)"swc-hsas-business", (Object[])new Object[0]);
        andOrNameLangMap.put("0", name);
        return andOrNameLangMap;
    }
}

