/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.swc.hsbp.common.enums.RuleParamTypeEnum;
import kd.swc.hsbp.common.util.RuleTypeOperatorsUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.vo.ConditionExpressInfo;
import kd.swc.hsbp.common.vo.ConditionInfo;
import kd.swc.hsbp.common.vo.RuleConditionInfo;
import kd.swc.hsbp.common.vo.RuleValidateInfo;

public class RuleValidateUtil {
    private static final Pattern noNeedValuePattern = Pattern.compile("(^[+-]*\\dd)|(^[+-]*\\dw)|(^[+-]*\\dm)|(^[+-]*\\dq)|(^[+-]*\\dp)|(^[+-]*\\dy)|(^[+-]*\\d+~[+-]*\\dm)|(^<=\\dd)|(^>=\\dd)|(is_null)|(is_not_null)$");
    private static final Pattern expressPattern = Pattern.compile("^T[0-9]+$");
    private static final Pattern leftPattern = Pattern.compile("^\\(+$");
    private static final Pattern rigthPattern = Pattern.compile("^\\)+$");

    public static RuleValidateInfo validCondition(String conditionJson) {
        RuleValidateInfo info = new RuleValidateInfo();
        if (SWCStringUtils.isEmpty(conditionJson)) {
            info.addMsg(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u81f3\u5c11\u9700\u8981\u6709\u4e00\u884c\u5b8c\u6574\u903b\u8f91\u3002", (String)"RuleValidateUtil_0", (String)"swc-hsbp-common", (Object[])new Object[0]));
            return info;
        }
        RuleConditionInfo ruleConditionInfo = (RuleConditionInfo)JSON.parseObject((String)conditionJson, RuleConditionInfo.class);
        if (ruleConditionInfo.getConditionList().isEmpty()) {
            info.addMsg(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u81f3\u5c11\u9700\u8981\u6709\u4e00\u884c\u5b8c\u6574\u903b\u8f91\u3002", (String)"RuleValidateUtil_0", (String)"swc-hsbp-common", (Object[])new Object[0]));
        } else {
            List<ConditionInfo> conditionList = ruleConditionInfo.getConditionList();
            for (ConditionInfo conditionInfo : conditionList) {
                String scopeMsg;
                String typeMsg;
                if (SWCStringUtils.isEmpty(conditionInfo.getParam())) {
                    info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u5165\u53c2\u5b57\u6bb5\u3002", (String)"RuleValidateUtil_1", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName()));
                    continue;
                }
                String operators = conditionInfo.getOperators();
                if (SWCStringUtils.isEmpty(operators)) {
                    info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u5224\u65ad\u6761\u4ef6\u3002", (String)"RuleValidateUtil_2", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName()));
                    continue;
                }
                boolean isNeedValue = true;
                if (SWCStringUtils.isNotEmpty(operators) && noNeedValuePattern.matcher(operators).matches()) {
                    isNeedValue = false;
                }
                if (!isNeedValue) continue;
                if (SWCStringUtils.isEmpty(conditionInfo.getValueType()) || "0".equals(conditionInfo.getValueType())) {
                    info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u7c7b\u578b\u3002", (String)"RuleValidateUtil_3", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName()));
                    continue;
                }
                if (SWCStringUtils.isEmpty(conditionInfo.getValue())) {
                    info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u3002", (String)"RuleValidateUtil_4", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName()));
                    continue;
                }
                if ("2".equals(conditionInfo.getValueType()) && RuleParamTypeEnum.NUMBER.getValue().equals(conditionInfo.getParamType())) {
                    typeMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u5fc5\u987b\u662f\u6570\u5b57\u7c7b\u578b\u3002", (String)"RuleValidateUtil_5", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName());
                    scopeMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e-9223372036854775808\u81f39223372036854775807\u4e4b\u95f4\u3002", (String)"RuleValidateUtil_6", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName());
                    RuleValidateUtil.validNumber(info, conditionInfo.getValue(), typeMsg, scopeMsg);
                } else if ("2".equals(conditionInfo.getValueType()) && RuleParamTypeEnum.DATE.getValue().equals(conditionInfo.getParamType()) && RuleTypeOperatorsUtils.getNumberDataValueOperators().contains(conditionInfo.getOperators())) {
                    typeMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u5fc5\u987b\u662f\u6574\u6570\u7c7b\u578b\u3002", (String)"RuleValidateUtil_12", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName());
                    scopeMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u8303\u56f4\u5fc5\u987b\u4f4d\u4e8e1\u81f331\u4e4b\u95f4\u3002", (String)"RuleValidateUtil_11", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName());
                    RuleValidateUtil.validDateNumber(info, conditionInfo.getValue(), typeMsg, scopeMsg);
                }
                if (!SWCStringUtils.equals(conditionInfo.getParamType(), RuleParamTypeEnum.DATE.getValue()) || !(!RuleTypeOperatorsUtils.getNumberDataValueOperators().contains(conditionInfo.getOperators()) & "2".equals(conditionInfo.getValueType()))) continue;
                try {
                    SWCDateTimeUtils.parseDate(conditionInfo.getValue(), "yyyy-MM-dd");
                }
                catch (ParseException e) {
                    info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6%s\u7684\u6bd4\u8f83\u503c\u5fc5\u987b\u662f\u65e5\u671f\u683c\u5f0f\u3002", (String)"RuleValidateUtil_13", (String)"swc-hsbp-common", (Object[])new Object[0]), conditionInfo.getName()));
                }
            }
            RuleValidateUtil.validExpression(ruleConditionInfo, info);
        }
        return info;
    }

    private static void validNumber(RuleValidateInfo info, String number, String numberTypeMsg, String numberScopeMsg) {
        if (!RuleValidateUtil.isNumeric(number)) {
            info.addMsg(numberTypeMsg);
            return;
        }
        BigDecimal num = new BigDecimal(number);
        if ((num = num.setScale(10, 4)).compareTo(new BigDecimal(Long.MIN_VALUE)) <= 0 || num.compareTo(new BigDecimal(Long.MAX_VALUE)) >= 0) {
            info.addMsg(numberScopeMsg);
        }
    }

    private static void validDateNumber(RuleValidateInfo info, String number, String numberTypeMsg, String numberScopeMsg) {
        if (!RuleValidateUtil.isInt(number)) {
            info.addMsg(numberTypeMsg);
            return;
        }
        BigDecimal num = new BigDecimal(number);
        if ((num = num.setScale(10, 4)).compareTo(new BigDecimal(0)) <= 0 || num.compareTo(new BigDecimal(32)) >= 0) {
            info.addMsg(numberScopeMsg);
        }
    }

    public static boolean isNumeric(String str) {
        try {
            new BigDecimal(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static boolean isInt(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void validExpression(RuleConditionInfo ruleConditionInfo, RuleValidateInfo info) {
        List<ConditionInfo> conditionList = ruleConditionInfo.getConditionList();
        String expressStr = ruleConditionInfo.getConditionExpressStr();
        List<ConditionExpressInfo> conditionExpressList = ruleConditionInfo.getConditionExpressList();
        for (int i = 0; i < conditionExpressList.size(); ++i) {
            ConditionExpressInfo conditionExpressInfo = conditionExpressList.get(i);
            String name = conditionExpressInfo.getName();
            String leftBracket = conditionExpressInfo.getLeftBracket();
            String rightBracket = conditionExpressInfo.getRightBracket();
            String logical = conditionExpressInfo.getLogical();
            if (!expressPattern.matcher(name).matches()) {
                info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\u3002", (String)"RuleValidateUtil_7", (String)"swc-hsbp-common", (Object[])new Object[0]));
                return;
            }
            if (SWCStringUtils.isNotEmpty(leftBracket) && !leftPattern.matcher(leftBracket.replaceAll(" ", "")).matches()) {
                info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\u3002", (String)"RuleValidateUtil_7", (String)"swc-hsbp-common", (Object[])new Object[0]));
                return;
            }
            if (SWCStringUtils.isNotEmpty(rightBracket) && !rigthPattern.matcher(rightBracket.replaceAll(" ", "")).matches()) {
                info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\u3002", (String)"RuleValidateUtil_7", (String)"swc-hsbp-common", (Object[])new Object[0]));
                return;
            }
            if (i != conditionExpressList.size() - 1 || !SWCStringUtils.isNotEmpty(logical)) continue;
            info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u914d\u7f6e\u9519\u8bef\u3002", (String)"RuleValidateUtil_7", (String)"swc-hsbp-common", (Object[])new Object[0]));
            return;
        }
        String[] str = expressStr.split(" ");
        int leftBracket = 0;
        int rightBracket = 0;
        for (int i = 0; i < str.length; ++i) {
            if (SWCStringUtils.isEmpty(str[i])) continue;
            if ("(".equals(str[i])) {
                ++leftBracket;
                continue;
            }
            if (")".equals(str[i])) {
                ++rightBracket;
                continue;
            }
            if ("and".equals(str[i]) || "or".equals(str[i])) continue;
            if (Pattern.matches("^T\\d{2,}$", str[i])) {
                Set expressNameList = conditionList.stream().map(ConditionInfo::getName).collect(Collectors.toSet());
                if (expressNameList.contains(str[i])) continue;
                info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6ca1\u6709\u6761\u4ef6%s", (String)"RuleValidateUtil_8", (String)"swc-hsbp-common", (Object[])new Object[0]), str[i]));
                continue;
            }
            info.addMsg(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u4e2d\u5b58\u5728\u65e0\u6548\u5b57\u7b26%s\u3002", (String)"RuleValidateUtil_9", (String)"swc-hsbp-common", (Object[])new Object[0]), str[i]));
        }
        if (leftBracket != rightBracket) {
            info.addMsg(ResManager.loadKDString((String)"\u6761\u4ef6\u903b\u8f91\u8868\u8fbe\u5f0f\u7684\u62ec\u53f7\u4e2a\u6570\u4e0d\u5339\u914d\u3002", (String)"RuleValidateUtil_10", (String)"swc-hsbp-common", (Object[])new Object[0]));
        }
    }
}

