/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class SWCArrayUtils {
    public static int getCount(Object[] objs) {
        int count = 0;
        if (objs == null) {
            return count;
        }
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            if (objs[i] == null) continue;
            ++count;
        }
        return count;
    }

    public static final boolean hasSameElements(Object[] objs0, Object[] objs1) {
        if (objs0 == objs1) {
            return true;
        }
        if (objs0 != null && objs1 != null && objs0.length == objs1.length) {
            int index;
            int length = objs0.length;
            boolean[] found_map = new boolean[length];
            for (index = 0; index < length; ++index) {
                found_map[index] = false;
            }
            for (index = 0; index < length; ++index) {
                int jIndex;
                for (jIndex = 0; jIndex < length && (found_map[jIndex] || !(objs0[index] == null ? (found_map[jIndex] = objs0[index] == objs1[jIndex]) : (found_map[jIndex] = objs0[index].equals(objs1[jIndex])))); ++jIndex) {
                }
                if (jIndex != length) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final Object[] removeElement(Object[] objs, Object obj) {
        int length = objs.length;
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            if (obj == objs[i]) continue;
            list.add(objs[i]);
        }
        if (list.size() == length) {
            return objs;
        }
        Object[] array = (Object[])Array.newInstance(objs.getClass().getComponentType(), list.size());
        return list.toArray(array);
    }

    public static final int[] removeElement(int[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        int[] t_array = new int[array.length - 1];
        if (t_array.length != 0) {
            System.arraycopy(array, 0, t_array, 0, index);
            System.arraycopy(array, index + 1, t_array, index, t_array.length - index);
        }
        return t_array;
    }

    public static final Object[] removeElement(Object[] array, int index) {
        if (index < 0 || index >= array.length) {
            throw new IndexOutOfBoundsException("Bad parameter for delete column.");
        }
        Object[] t_array = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
        if (t_array.length != 0) {
            System.arraycopy(array, 0, t_array, 0, index);
            System.arraycopy(array, index + 1, t_array, index, t_array.length - index);
        }
        return t_array;
    }

    public static final Object[] insertElement(Object[] array, int index, Object val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object[] t_array = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        System.arraycopy(array, 0, t_array, 0, index);
        t_array[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, t_array, index + 1, t_array.length - index - 1);
        }
        return t_array;
    }

    public static final int[] insertElement(int[] array, int index, int val) {
        if (index < 0 || index > array.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] t_array = new int[array.length + 1];
        System.arraycopy(array, 0, t_array, 0, index);
        t_array[index] = val;
        if (index != array.length) {
            System.arraycopy(array, index, t_array, index + 1, t_array.length - index - 1);
        }
        return t_array;
    }

    public static final int[] removeUniqueElement(int[] arr, int key) {
        if (arr == null) {
            return null;
        }
        int index = -1;
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] != key) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return arr;
        }
        int[] newA = new int[arr.length - 1];
        if (newA.length != 0) {
            System.arraycopy(arr, 0, newA, 0, index);
            System.arraycopy(arr, index + 1, newA, index, newA.length - index);
        }
        return newA;
    }

    public static final boolean containElement(Object[] objs, Object element) {
        return SWCArrayUtils.findElement(objs, element, -1) != -1;
    }

    public static final int findElement(Object[] objs, Object element, int expect) {
        if (objs == null) {
            return -1;
        }
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            if (objs[i] != element && (objs[i] == null || !objs[i].equals(element)) || expect == i) continue;
            return i;
        }
        return -1;
    }

    public static final int findStringElement(String[] objs, String element, int expect, boolean ignoreCase) {
        if (objs == null) {
            return -1;
        }
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            if (objs[i] != null && (objs[i] == null || !objs[i].equals(element) && (!ignoreCase || !objs[i].equalsIgnoreCase(element))) || expect == i) continue;
            return i;
        }
        return -1;
    }

    public static final boolean difference(Object[] objs0, Object[] objs1, ArrayList<Object> missing, ArrayList<Object> additional) {
        int index;
        if (objs0 == objs1) {
            return true;
        }
        Object[] rObjs0 = objs0 == null ? new Object[]{} : objs0;
        Object[] rObjs1 = objs1 == null ? new Object[]{} : objs1;
        int length0 = rObjs0.length;
        int length1 = rObjs1.length;
        int[] index1 = new int[length1];
        for (index = 0; index < length1; ++index) {
            index1[index] = index;
        }
        for (index = 0; index < length0; ++index) {
            boolean found = false;
            for (int jIndex = 0; jIndex < length1; ++jIndex) {
                if (rObjs0[index] != rObjs1[jIndex]) continue;
                found = true;
                index1[jIndex] = -1;
                break;
            }
            if (found) continue;
            additional.add(rObjs0[index]);
        }
        for (index = 0; index < length1; ++index) {
            if (index1[index] == -1) continue;
            missing.add(rObjs1[index]);
        }
        return missing.size() == 0 && additional.size() == 0;
    }

    public static final String objectArray2String(Object[] objs, String split) {
        if (objs == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int length = objs.length;
        for (int i = 0; i < length; ++i) {
            buffer.append(objs[i] == null ? "null" : objs[i].toString());
            buffer.append(split);
        }
        if (buffer.length() > 0) {
            return buffer.substring(0, buffer.length() - split.length());
        }
        return buffer.toString();
    }

    public static final String byteArray2String(byte[] arr, String split) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            sb.append(arr[i]);
            sb.append(split);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - split.length());
        }
        return sb.toString();
    }

    public static final String intArray2String(int[] arr, String split) {
        if (arr == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            sb.append(arr[i]);
            sb.append(split);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - split.length());
        }
        return sb.toString();
    }

    public static final ArrayList<Object> objects2ArrayList(Object[] objs) {
        ArrayList<Object> al = new ArrayList<Object>();
        if (objs != null) {
            int length = objs.length;
            for (int i = 0; i < length; ++i) {
                al.add(objs[i]);
            }
        }
        return al;
    }

    public static final Object[] copyGenericArray(Object[] array) {
        Object[] copy = new Object[array.length];
        System.arraycopy(array, 0, copy, 0, copy.length);
        return copy;
    }

    public static final void clearArray(Object[] array) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            array[i] = null;
        }
    }

    public static final byte[] addByteArray(byte[] arra, byte[] arrb) {
        byte[] arrc = new byte[arra.length + arrb.length];
        System.arraycopy(arra, 0, arrc, 0, arra.length);
        System.arraycopy(arrb, 0, arrc, arra.length, arrb.length);
        return arrc;
    }

    public static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    public static final boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }
}

