/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbp.common.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class SWCBaseUtils {
    public static String join(String[] arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            sb.append(arr[i]).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(Set<String> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String obj : arr) {
            sb.append((Object)obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(List<String> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String obj : arr) {
            sb.append((Object)obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(Collection<Object> arr, String separator) {
        StringBuilder sb = new StringBuilder();
        for (Object obj : arr) {
            sb.append(obj).append(separator);
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.lastIndexOf(separator));
        }
        return null;
    }

    public static String join(String separator, String ... arr) {
        String[] arrnew = (String[])arr.clone();
        return SWCBaseUtils.join(arrnew, separator);
    }

    public static Long getPk(Object entity) {
        if (entity instanceof DynamicObject) {
            return (Long)((DynamicObject)entity).getPkValue();
        }
        if (entity instanceof Long) {
            return (Long)entity;
        }
        if (entity instanceof Integer) {
            return Long.valueOf(entity.toString());
        }
        return null;
    }

    public static BigDecimal getBigDecimal(Object obj) {
        if (obj != null && StringUtils.isNotBlank((Object)obj) && !" ".equals(obj)) {
            return new BigDecimal(obj.toString());
        }
        return BigDecimal.ZERO;
    }

    public static DynamicObject copyField(DynamicObject destObj, DynamicObject srcObj, String[] fields) {
        if (destObj != null && srcObj != null && fields != null) {
            for (String field : fields) {
                if (srcObj.get(field) == null) continue;
                destObj.set(field, srcObj.get(field));
            }
        }
        return destObj;
    }

    public static DynamicObject copyFieldId(DynamicObject destObj, DynamicObject srcObj, String[] fields) {
        if (destObj != null && srcObj != null && fields != null) {
            for (String field : fields) {
                if (srcObj.get(field) != null) {
                    destObj.set(field.replace(".id", ""), srcObj.get(field));
                    continue;
                }
                destObj.set(field.replace(".id", ""), null);
            }
        }
        return destObj;
    }

    public static Row queryDataSetOne(DataSet dataSet) {
        Iterator it = dataSet.iterator();
        if (it.hasNext()) {
            return (Row)it.next();
        }
        return null;
    }

    public static Object getAssetBookInfo(DynamicObject assetBook, String property) {
        DynamicObjectCollection coll = assetBook.getDynamicObjectCollection("assetbook_entry");
        if (coll.size() > 0) {
            return ((DynamicObject)coll.get(0)).get(property);
        }
        return null;
    }

    public static String pojo2Json(Object obj) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T json2Pojo(Class<T> type, String json) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            return (T)objectMapper.readValue(json, type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isEmpty(Map<Object, Object> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Collection<Object> collection) {
        return collection == null || collection.size() == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    public static boolean isEmpty(DynamicObject dynamicObject) {
        return dynamicObject == null || dynamicObject.getLong("id") == 0L;
    }

    public static Map<Object, Object> key2Map(Collection<Object> collection) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(collection.size());
        for (Object value : collection) {
            map.put(value, value);
        }
        return map;
    }

    public static Map<Object, Object> key2Map(Object[] arr) {
        HashMap<Object, Object> map = new HashMap<Object, Object>(arr.length);
        for (Object value : arr) {
            map.put(value, value);
        }
        return map;
    }

    public static List<Object> filter(List<Object> filterList, List<Object> list) {
        ArrayList<Object> retList = new ArrayList<Object>(filterList.size());
        Map<Object, Object> filterMap = SWCBaseUtils.key2Map(filterList);
        for (Object obj : list) {
            if (filterMap.containsKey(obj)) continue;
            retList.add(obj);
        }
        return retList;
    }

    public static Object[] filter(Object[] filterArr, Object[] arr) {
        ArrayList<Object> retList = new ArrayList<Object>(filterArr.length);
        Map<Object, Object> filterMap = SWCBaseUtils.key2Map(filterArr);
        for (Object obj : arr) {
            if (filterMap.containsKey(obj)) continue;
            retList.add(obj);
        }
        return retList.toArray();
    }

    public static String addString_id(String str) {
        return str.concat("_id");
    }

    public static Date getMinEffectDate() {
        try {
            return SWCDateTimeUtils.parseDate("1900-01-01");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMinStartDate() {
        try {
            return SWCDateTimeUtils.parseDate("1900-01-01");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMaxLoseEffectDate() {
        try {
            return SWCDateTimeUtils.parseDate("2999-12-31");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date getMaxEndDate() {
        try {
            return SWCDateTimeUtils.parseDate("2999-12-31");
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static String getComboFieldDisplayValue(DynamicObject dy, String field) {
        IDataEntityProperty dataEntityProperty = (IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)field);
        String value = dy.getString(field);
        if (dataEntityProperty instanceof ComboProp) {
            List comboItems = ((ComboProp)dataEntityProperty).getComboItems();
            for (ValueMapItem comboItem : comboItems) {
                if (!comboItem.getValue().equals(value)) continue;
                value = comboItem.getName().getLocaleValue();
                break;
            }
        }
        return value;
    }

    public static String getEntityNameByFieldName(String fieldName, MainEntityType mainEntityType) {
        if (SWCStringUtils.isEmpty(fieldName)) {
            return "";
        }
        int index = fieldName.indexOf(46);
        if (index < 0) {
            return mainEntityType.getName();
        }
        String key = fieldName.substring(0, index);
        String subKey = fieldName.substring(index + 1);
        BasedataProp property = (BasedataProp)mainEntityType.getProperty(key);
        MainEntityType subtype = (MainEntityType)property.getComplexType();
        return SWCBaseUtils.getEntityNameByFieldName(subKey, subtype);
    }
}

